/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.GenericUiPlugin;
import org.eclipse.jst.server.generic.ui.internal.editor.UpdateServerPropertyOperation;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class AntBuildFileSelectionEditorSection
extends ServerEditorSection {
    protected GenericServer fServer;
    private PropertyChangeListener fPropertyChangeListener;
    protected Text buildFileText;
    protected boolean fUpdating;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.fServer = (GenericServer)this.server.loadAdapter(GenericServer.class, (IProgressMonitor)new NullProgressMonitor());
        }
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("generic_server_instance_properties") && !AntBuildFileSelectionEditorSection.this.fUpdating) {
                    AntBuildFileSelectionEditorSection.this.fUpdating = true;
                    Object value = AntBuildFileSelectionEditorSection.this.fServer.getServerInstanceProperties().get("org.eclipse.jst.server.generic.core.custom_build_file");
                    AntBuildFileSelectionEditorSection.this.buildFileText.setText(value == null ? "" : (String)value);
                    AntBuildFileSelectionEditorSection.this.fUpdating = false;
                }
            }
        };
        this.server.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void createSection(final Composite parent) {
        super.createSection(parent);
        FormToolkit formToolkit = this.getFormToolkit(parent.getDisplay());
        Section section = formToolkit.createSection(parent, 450);
        section.setText(GenericServerUIMessages.AntPublisherSectionHeading);
        section.setDescription(GenericServerUIMessages.AntPublisherSectionDescription);
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = formToolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        Label buildFileLabel = formToolkit.createLabel(composite, GenericServerUIMessages.LabelBuildFile);
        buildFileLabel.setForeground(formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.buildFileText = formToolkit.createText(composite, "");
        String oldValue = this.fServer.getServerInstanceProperties().get("org.eclipse.jst.server.generic.core.custom_build_file") == null ? "" : (String)this.fServer.getServerInstanceProperties().get("org.eclipse.jst.server.generic.core.custom_build_file");
        this.buildFileText.setText(oldValue);
        this.buildFileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AntBuildFileSelectionEditorSection.this.executeUpdateOperation("org.eclipse.jst.server.generic.core.custom_build_file", AntBuildFileSelectionEditorSection.this.buildFileText.getText());
            }
        });
        GridData gridData = new GridData(768);
        this.buildFileText.setLayoutData((Object)gridData);
        Button buildFileBtn = formToolkit.createButton(composite, GenericServerUIMessages.ButtonBrowseForBuildFile, 8);
        buildFileBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setAllowMultiple(false);
                dialog.setTitle(GenericServerUIMessages.AntBuildDialogTitle);
                dialog.setMessage(GenericServerUIMessages.AntBuildDialogDescription);
                dialog.addFilter((ViewerFilter)new BuildFileFilter());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (dialog.open() == 0) {
                    IFile file = (IFile)dialog.getFirstResult();
                    AntBuildFileSelectionEditorSection.this.buildFileText.setText(VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", file.getFullPath().toString()));
                }
            }
        });
        formToolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    public void dispose() {
        super.dispose();
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public IStatus[] getSaveStatus() {
        try {
            File f;
            String filename = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.buildFileText.getText());
            if (filename != null && filename.length() > 0 && !(f = new File(filename)).exists()) {
                Status[] st = new Status[]{new Status(4, "org.eclipse.jst.server.generic.ui", GenericServerUIMessages.ErrorNoAntBuildFile)};
                return st;
            }
        }
        catch (CoreException e) {
            GenericUiPlugin.getDefault().getLog().log(e.getStatus());
        }
        return super.getSaveStatus();
    }

    protected void executeUpdateOperation(String propertyName, String propertyValue) {
        if (!this.fUpdating) {
            this.fUpdating = true;
            this.execute((IUndoableOperation)new UpdateServerPropertyOperation(this.server, GenericServerUIMessages.UpdateOperationDescription, propertyName, propertyValue));
            this.fUpdating = false;
        }
    }

    private class BuildFileFilter
    extends ViewerFilter {
        private BuildFileFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml")) return false;
                IContentType contentType = IDE.getContentType((IFile)file);
                if (contentType == null) return false;
                return "org.eclipse.ant.core.antBuildFile".equals(contentType.getId());
            }
            if (element instanceof IProject && !((IProject)element).isOpen()) {
                return false;
            }
            if (!(element instanceof IContainer)) return false;
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (true) {
                    if (i >= resources.length) {
                        return false;
                    }
                    if (this.select(viewer, parentElement, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            return false;
        }
    }
}

