/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.ExportBreakpointsOperation;
import org.eclipse.debug.ui.actions.ImportBreakpointsOperation;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.debug.ui.DebugUiPlugin;

public class BreakpointsContextUtil {
    public static InputStream exportBreakpoints(Collection<IBreakpoint> breakpoints, IProgressMonitor progressMonitor) {
        if (breakpoints.size() == 0) {
            return null;
        }
        ExportBreakpointsOperation exportBreakpointOperation = new ExportBreakpointsOperation(breakpoints.toArray(new IBreakpoint[0]));
        try {
            exportBreakpointOperation.run(progressMonitor);
            return new ByteArrayInputStream(exportBreakpointOperation.getBuffer().toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(2, DebugUiPlugin.ID_PLUGIN, "Could not export context breakpoints", (Throwable)e));
            return null;
        }
    }

    public static List<IBreakpoint> importBreakpoints(IInteractionContext context, IProgressMonitor progressMonitor) {
        InputStream stream = ContextCore.getContextManager().getAdditionalContextData(context, DebugUiPlugin.CONTRIBUTOR_ID);
        if (stream == null) {
            return new ArrayList<IBreakpoint>();
        }
        return BreakpointsContextUtil.importBreakpoints(stream, progressMonitor);
    }

    public static List<IBreakpoint> importBreakpoints(InputStream stream, IProgressMonitor progressMonitor) {
        Scanner scanner = new Scanner(stream);
        scanner.useDelimiter("\\A");
        String breakpoints = scanner.next();
        scanner.close();
        ImportBreakpointsOperation importBreakpointOperation = new ImportBreakpointsOperation(new StringBuffer(breakpoints), true, false);
        try {
            importBreakpointOperation.run(progressMonitor);
            return new ArrayList<IBreakpoint>(Arrays.asList(importBreakpointOperation.getImportedBreakpoints()));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(2, DebugUiPlugin.ID_PLUGIN, "Could not import context breakpoints", (Throwable)e));
            return new ArrayList<IBreakpoint>();
        }
    }

    public static void removeBreakpoints(Collection<IBreakpoint> breakpoints) {
        try {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints.toArray(new IBreakpoint[0]), true);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(2, DebugUiPlugin.ID_PLUGIN, "Could not remove obsolete breakpoints from workspace", (Throwable)e));
        }
    }
}

