/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.parallel;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.internal.etfw.ILaunchFactory;
import org.eclipse.ptp.internal.etfw.IToolLaunchConfigurationDelegate;
import org.eclipse.ptp.internal.etfw.RemoteBuildLaunchUtils;
import org.eclipse.ptp.internal.etfw.ToolLaunchManager;
import org.eclipse.ptp.internal.etfw.parallel.Activator;
import org.eclipse.ptp.internal.etfw.parallel.ParallelLaunchFactory;
import org.eclipse.ptp.internal.etfw.parallel.messages.Messages;
import org.eclipse.ptp.launch.ParallelLaunchConfigurationDelegate;
import org.eclipse.remote.core.launch.IRemoteLaunchConfigService;

public class ParallelToolLaunchConfigurationDelegate
extends ParallelLaunchConfigurationDelegate
implements IToolLaunchConfigurationConstants,
IToolLaunchConfigurationDelegate {
    private boolean initialized = false;

    public boolean getInitialized() {
        return this.initialized;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        if (this.initialized) {
            this.initialized = false;
            super.launch(configuration, mode, launchIn, monitor);
            return;
        }
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
            progress.setTaskName(NLS.bind((String)Messages.ParallelToolLaunchConfigurationDelegate_Launching, (Object)configuration.getName()));
            progress.setWorkRemaining(90);
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            String progName = wc.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", "defaultValue");
            String progPath = wc.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", "defaultValue");
            String projName = wc.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", "defaultValue");
            IFileStore pdir = EFS.getLocalFileSystem().getStore((IPath)new Path(progPath));
            IFileStore prog = pdir.getChild(progName);
            this.verifyProject(configuration);
            wc.setAttribute("perf_executable_name", prog.toURI().getPath());
            wc.setAttribute("perf_project_name", projName);
            wc.setAttribute("perf_framework_attribute_for_arguments_value", "org.eclipse.ptp.launch.ARGUMENT_ATTR");
            wc.setAttribute("perf_project_name_tag_for_name_value", "org.eclipse.ptp.launch.PROJECT_ATTR");
            wc.setAttribute("perf_executable_name_tag_for_name_value", "org.eclipse.ptp.launch.APPLICATION_NAME");
            wc.setAttribute("perf_executable_path_tag_for_path_value", "org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH");
            IRemoteLaunchConfigService launchConfigService = Activator.getService(IRemoteLaunchConfigService.class);
            String rmId = launchConfigService.getActiveConnection(configuration).getConnectionType().getId();
            rmId = String.valueOf(rmId) + ".";
            wc.setAttribute("perf_framework_attribute_for_JAXB_arguments_value", String.valueOf(rmId) + "progArgs");
            wc.setAttribute("perf_executable_path_tag_for_JAXB_path_value", String.valueOf(rmId) + "executablePath");
            wc.setAttribute("perf_executable_directory_tag_for_JAXB_exec_dir_value", String.valueOf(rmId) + "executableDirectory");
            wc.doSave();
            ParallelLaunchFactory lf = new ParallelLaunchFactory();
            progress.worked(80);
            if (launchIn instanceof IPLaunch) {
                if (!this.verifyLaunchAttributes(configuration, mode, (IProgressMonitor)progress.newChild(10)) || progress.isCanceled()) {
                    return;
                }
                ToolLaunchManager plaunch = new ToolLaunchManager((LaunchConfigurationDelegate)this, (ILaunchFactory)lf, (IBuildLaunchUtils)new RemoteBuildLaunchUtils(configuration));
                plaunch.launch(configuration, mode, launchIn, monitor);
            }
            this.initialized = false;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void setInitialized(boolean init) {
        this.initialized = init;
    }

    protected boolean verifyLaunchAttributes(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        try {
            boolean value = super.verifyLaunchAttributes(configuration, mode, monitor);
            if (value) {
                value = this.verifyProfilingTool(configuration);
            }
            boolean bl = value;
            return bl;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected boolean verifyProfilingTool(ILaunchConfiguration configuration) throws CoreException {
        String whichParser = configuration.getAttribute("ETFW_VERSION", "");
        String whichTool = configuration.getAttribute("selected_performance_tool", "");
        if (whichParser.isEmpty() || whichTool.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.etfw.parallel", Messages.ParallelToolLaunchConfigurationDelegate_ProfilingToolNotSpecified));
        }
        return true;
    }
}

