/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.test.internal.performance.InternalPerformanceMeter;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.data.Scalar;

class TestPerformanceMeter
extends InternalPerformanceMeter {
    private long fStartTime;
    private List<DataPoint> fDataPoints = new ArrayList<DataPoint>();
    private Map<Dim, Scalar> fStart = new HashMap<Dim, Scalar>();
    private Map<Dim, Scalar> fStop = new HashMap<Dim, Scalar>();

    TestPerformanceMeter(String scenarioId) {
        super(scenarioId);
        this.fStartTime = System.currentTimeMillis();
    }

    void addPair(Dim dimension, long start, long end) {
        this.fStart.put(dimension, new Scalar(dimension, start));
        this.fStop.put(dimension, new Scalar(dimension, end));
    }

    @Override
    public void dispose() {
        this.fDataPoints = null;
        super.dispose();
    }

    @Override
    public Sample getSample() {
        if (this.fDataPoints != null) {
            return new Sample(this.getScenarioName(), this.fStartTime, new HashMap<String, String>(), this.fDataPoints.toArray(new DataPoint[this.fDataPoints.size()]));
        }
        return null;
    }

    @Override
    public void start() {
        this.fDataPoints.add(new DataPoint(0, this.fStart));
    }

    @Override
    public void stop() {
        this.fDataPoints.add(new DataPoint(1, this.fStop));
    }
}

