/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.EnableKernelEventComposite;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.EnableLoggersComposite;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.EnableUstEventsComposite;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableEventsDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;

public class EnableEventsDialog
extends Dialog
implements IEnableEventsDialog {
    public static final String ENABLE_EVENT_ICON_FILE = "icons/elcl16/enable_event.gif";
    private Composite fDialogComposite;
    private EnableKernelEventComposite fKernelComposite;
    private EnableUstEventsComposite fUstComposite;
    private EnableLoggersComposite fJulComposite;
    private EnableLoggersComposite fLog4jComposite;
    private EnableLoggersComposite fPythonComposite;
    private Button fKernelButton;
    private Button fUstButton;
    private Button fJulButton;
    private Button fLog4jButton;
    private Button fPythonButton;
    private TraceProviderGroup fProviderGroup;
    private TraceDomainComponent fDomainComponent;
    private TraceDomainType fDomain;

    public EnableEventsDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public boolean isAllEvents() {
        switch (this.fDomain) {
            case KERNEL: {
                return this.fKernelComposite.isAllEvents();
            }
            case JUL: {
                return this.fJulComposite.isAllTracePoints();
            }
            case UST: {
                return this.fUstComposite.isAllTracePoints();
            }
            case LOG4J: {
                return this.fLog4jComposite.isAllTracePoints();
            }
            case PYTHON: {
                return this.fPythonComposite.isAllTracePoints();
            }
        }
        return false;
    }

    @Override
    public boolean isTracepoints() {
        switch (this.fDomain) {
            case JUL: 
            case LOG4J: 
            case PYTHON: {
                return true;
            }
            case KERNEL: {
                return this.fKernelComposite.isTracepoints();
            }
            case UST: {
                return this.fUstComposite.isTracepoints();
            }
        }
        return false;
    }

    @Override
    public boolean isAllTracePoints() {
        switch (this.fDomain) {
            case KERNEL: {
                return this.fKernelComposite.isAllTracePoints();
            }
            case UST: {
                return this.fUstComposite.isAllTracePoints();
            }
            case JUL: {
                return this.fJulComposite.isAllTracePoints();
            }
            case LOG4J: {
                return this.fLog4jComposite.isAllTracePoints();
            }
            case PYTHON: {
                return this.fPythonComposite.isAllTracePoints();
            }
        }
        return false;
    }

    @Override
    public boolean isSyscalls() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.isSyscalls();
        }
        return false;
    }

    @Override
    public boolean isAllSyscalls() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.isAllSyscalls();
        }
        return false;
    }

    @Override
    public List<String> getEventNames() {
        switch (this.fDomain) {
            case JUL: {
                return this.fJulComposite.getEventNames();
            }
            case KERNEL: {
                return this.fKernelComposite.getEventNames();
            }
            case UST: {
                return this.fUstComposite.getEventNames();
            }
            case LOG4J: {
                return this.fLog4jComposite.getEventNames();
            }
            case PYTHON: {
                return this.fPythonComposite.getEventNames();
            }
        }
        return null;
    }

    @Override
    public boolean isDynamicProbe() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.isDynamicProbe();
        }
        return false;
    }

    @Override
    public String getProbeName() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.getProbeName();
        }
        return null;
    }

    @Override
    public String getProbeEventName() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.getProbeEventName();
        }
        return null;
    }

    @Override
    public boolean isDynamicFunctionProbe() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.isDynamicFunctionProbe();
        }
        return false;
    }

    @Override
    public String getFunctionEventName() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.getFunctionEventName();
        }
        return null;
    }

    @Override
    public String getFunction() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return this.fKernelComposite.getFunction();
        }
        return null;
    }

    @Override
    public boolean isWildcard() {
        if (this.fDomain.equals((Object)TraceDomainType.UST)) {
            return this.fUstComposite.isWildcard();
        }
        return false;
    }

    @Override
    public String getWildcard() {
        if (this.fDomain.equals((Object)TraceDomainType.UST)) {
            return this.fUstComposite.getWildcard();
        }
        return null;
    }

    @Override
    public boolean isLogLevel() {
        switch (this.fDomain) {
            case JUL: {
                return this.fJulComposite.isLogLevel();
            }
            case KERNEL: {
                return false;
            }
            case UST: {
                return this.fUstComposite.isLogLevel();
            }
            case LOG4J: {
                return this.fLog4jComposite.isLogLevel();
            }
            case PYTHON: {
                return this.fPythonComposite.isLogLevel();
            }
        }
        return false;
    }

    @Override
    public LogLevelType getLogLevelType() {
        switch (this.fDomain) {
            case JUL: {
                return this.fJulComposite.getLogLevelType();
            }
            case KERNEL: {
                return null;
            }
            case UST: {
                return this.fUstComposite.getLogLevelType();
            }
            case LOG4J: {
                return this.fLog4jComposite.getLogLevelType();
            }
            case PYTHON: {
                return this.fPythonComposite.getLogLevelType();
            }
        }
        return null;
    }

    @Override
    public ITraceLogLevel getLogLevel() {
        switch (this.fDomain) {
            case JUL: {
                return this.fJulComposite.getLogLevel();
            }
            case KERNEL: {
                return null;
            }
            case UST: {
                return this.fUstComposite.getLogLevel();
            }
            case LOG4J: {
                return this.fLog4jComposite.getLogLevel();
            }
            case PYTHON: {
                return this.fPythonComposite.getLogLevel();
            }
        }
        return null;
    }

    @Override
    public TraceDomainType getDomain() {
        return this.fDomain;
    }

    @Override
    public void setTraceProviderGroup(TraceProviderGroup providerGroup) {
        this.fProviderGroup = providerGroup;
    }

    @Override
    public void setTraceDomainComponent(TraceDomainComponent domain) {
        this.fDomainComponent = domain;
        if (this.fDomainComponent != null) {
            this.fDomain = this.fDomainComponent.getDomain();
        } else if (this.fProviderGroup != null) {
            this.fDomain = this.fProviderGroup.hasKernelProvider() ? TraceDomainType.KERNEL : TraceDomainType.UST;
        }
    }

    @Override
    public String getFilterExpression() {
        switch (this.fDomain) {
            case KERNEL: {
                return this.fKernelComposite.getFilterExpression();
            }
            case UST: {
                return this.fUstComposite.getFilterExpression();
            }
        }
        return null;
    }

    @Override
    public List<String> getExcludedEvents() {
        if (this.fDomain.equals((Object)TraceDomainType.UST)) {
            return this.fUstComposite.getExcludedEvents();
        }
        return null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableEventsDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(ENABLE_EVENT_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Group domainGroup = new Group(this.fDialogComposite, 32);
        domainGroup.setText(Messages.TraceControl_DomainDisplayName);
        this.fKernelButton = new Button((Composite)domainGroup, 16);
        this.fKernelButton.setText(Messages.TraceControl_KernelDomainDisplayName);
        this.fUstButton = new Button((Composite)domainGroup, 16);
        this.fUstButton.setText(Messages.TraceControl_UstDisplayName);
        int nbColumns = 2;
        this.fKernelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnableEventsDialog.this.fKernelButton.getSelection()) {
                    EnableEventsDialog.this.disposeAllComposite();
                    EnableEventsDialog.this.createKernelComposite();
                    EnableEventsDialog.this.fDialogComposite.layout();
                }
            }
        });
        this.fUstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnableEventsDialog.this.fUstButton.getSelection()) {
                    EnableEventsDialog.this.disposeAllComposite();
                    EnableEventsDialog.this.createUstComposite();
                    EnableEventsDialog.this.fDialogComposite.layout();
                }
            }
        });
        if (this.fProviderGroup.isJulLoggingSupported()) {
            this.fJulButton = new Button((Composite)domainGroup, 16);
            this.fJulButton.setText(Messages.TraceControl_JULDomainDisplayName);
            ++nbColumns;
            this.fJulButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (EnableEventsDialog.this.fJulButton.getSelection()) {
                        EnableEventsDialog.this.disposeAllComposite();
                        EnableEventsDialog.this.createJulComposite();
                        EnableEventsDialog.this.fDialogComposite.layout();
                    }
                }
            });
        }
        if (this.fProviderGroup.isLog4jLoggingSupported()) {
            this.fLog4jButton = new Button((Composite)domainGroup, 16);
            this.fLog4jButton.setText(Messages.TraceControl_LOG4JDomainDisplayName);
            ++nbColumns;
            this.fLog4jButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (EnableEventsDialog.this.fLog4jButton.getSelection()) {
                        EnableEventsDialog.this.disposeAllComposite();
                        EnableEventsDialog.this.createLog4jComposite();
                        EnableEventsDialog.this.fDialogComposite.layout();
                    }
                }
            });
        }
        if (this.fProviderGroup.isPythonLoggingSupported()) {
            this.fPythonButton = new Button((Composite)domainGroup, 16);
            this.fPythonButton.setText(Messages.TraceControl_PythonDomainDisplayName);
            ++nbColumns;
            this.fPythonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (EnableEventsDialog.this.fPythonButton.getSelection()) {
                        EnableEventsDialog.this.disposeAllComposite();
                        EnableEventsDialog.this.createPythonComposite();
                        EnableEventsDialog.this.fDialogComposite.layout();
                    }
                }
            });
        }
        layout = new GridLayout(nbColumns, true);
        domainGroup.setLayout((Layout)layout);
        switch (this.fDomain) {
            case KERNEL: {
                this.fKernelButton.setSelection(true);
                break;
            }
            case UST: {
                this.fUstButton.setSelection(true);
                break;
            }
            case JUL: {
                this.fJulButton.setSelection(true);
                break;
            }
            case LOG4J: {
                this.fLog4jButton.setSelection(true);
                break;
            }
            case PYTHON: {
                this.fPythonButton.setSelection(true);
                break;
            }
        }
        GridData data = new GridData(768);
        domainGroup.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fKernelButton.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fUstButton.setLayoutData((Object)data);
        this.fUstComposite = null;
        this.fKernelComposite = null;
        this.fJulComposite = null;
        this.fLog4jComposite = null;
        this.fPythonComposite = null;
        switch (this.fDomain) {
            case KERNEL: {
                this.createKernelComposite();
                break;
            }
            case UST: {
                this.createUstComposite();
                break;
            }
            case JUL: {
                this.createJulComposite();
                break;
            }
            case LOG4J: {
                this.createLog4jComposite();
                break;
            }
            case PYTHON: {
                this.createPythonComposite();
                break;
            }
        }
        if (this.fDomainComponent != null) {
            this.fKernelButton.setEnabled(false);
            this.fUstButton.setEnabled(false);
            if (this.fProviderGroup.isJulLoggingSupported()) {
                this.fJulButton.setEnabled(false);
            }
            if (this.fProviderGroup.isLog4jLoggingSupported()) {
                this.fLog4jButton.setEnabled(false);
            }
            if (this.fProviderGroup.isPythonLoggingSupported()) {
                this.fPythonButton.setEnabled(false);
            }
        } else if (this.fProviderGroup != null && !this.fProviderGroup.hasKernelProvider()) {
            this.fKernelButton.setEnabled(false);
            this.fUstButton.setEnabled(true);
            if (this.fProviderGroup.isJulLoggingSupported()) {
                this.fJulButton.setEnabled(true);
            }
            if (this.fProviderGroup.isLog4jLoggingSupported()) {
                this.fLog4jButton.setEnabled(true);
            }
            if (this.fProviderGroup.isPythonLoggingSupported()) {
                this.fPythonButton.setEnabled(true);
            }
        }
        this.getShell().setMinimumSize(new Point(550, 850));
        return this.fDialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        if (this.fKernelButton.getSelection()) {
            this.fDomain = TraceDomainType.KERNEL;
        } else if (this.fUstButton.getSelection()) {
            this.fDomain = TraceDomainType.UST;
        } else if (this.fJulButton.getSelection()) {
            this.fDomain = TraceDomainType.JUL;
        } else if (this.fLog4jButton.getSelection()) {
            this.fDomain = TraceDomainType.LOG4J;
        } else if (this.fPythonButton.getSelection()) {
            this.fDomain = TraceDomainType.PYTHON;
        }
        if (this.fKernelComposite != null && !this.fKernelComposite.isValid()) {
            return;
        }
        if (this.fUstComposite != null && !this.fUstComposite.isValid()) {
            return;
        }
        if (this.fJulComposite != null && !this.fJulComposite.isValid()) {
            return;
        }
        if (this.fLog4jComposite != null && !this.fLog4jComposite.isValid()) {
            return;
        }
        if (this.fPythonComposite != null && !this.fPythonComposite.isValid()) {
            return;
        }
        super.okPressed();
    }

    private void disposeAllComposite() {
        this.disposeKernelComposite();
        this.disposeUstComposite();
        this.disposeJulComposite();
        this.disposeLog4jComposite();
        this.disposePythonComposite();
    }

    private void createKernelComposite() {
        if (this.fKernelComposite == null) {
            this.fKernelComposite = new EnableKernelEventComposite(this.fDialogComposite, 0, this.fProviderGroup);
            GridLayout layout = new GridLayout(1, true);
            this.fKernelComposite.setLayout((Layout)layout);
            this.fKernelComposite.setLayoutData(new GridData(1808));
            this.fKernelComposite.createContent();
        }
    }

    private void disposeKernelComposite() {
        if (this.fKernelComposite != null) {
            this.fKernelComposite.dispose();
            this.fKernelComposite = null;
        }
    }

    private void createUstComposite() {
        if (this.fUstComposite == null) {
            this.fUstComposite = new EnableUstEventsComposite(this.fDialogComposite, 0, this.fProviderGroup);
            GridLayout layout = new GridLayout(1, true);
            this.fUstComposite.setLayout((Layout)layout);
            this.fUstComposite.setLayoutData(new GridData(1808));
            this.fUstComposite.createContent();
        }
    }

    private void disposeUstComposite() {
        if (this.fUstComposite != null) {
            this.fUstComposite.dispose();
            this.fUstComposite = null;
        }
    }

    private void createJulComposite() {
        if (this.fJulComposite == null) {
            this.fJulComposite = new EnableLoggersComposite(this.fDialogComposite, 0, this.fProviderGroup, TraceDomainType.JUL);
            GridLayout layout = new GridLayout(1, true);
            this.fJulComposite.setLayout((Layout)layout);
            this.fJulComposite.setLayoutData(new GridData(1808));
            this.fJulComposite.createContent();
        }
    }

    private void disposeJulComposite() {
        if (this.fJulComposite != null) {
            this.fJulComposite.dispose();
            this.fJulComposite = null;
        }
    }

    private void createLog4jComposite() {
        if (this.fLog4jComposite == null) {
            this.fLog4jComposite = new EnableLoggersComposite(this.fDialogComposite, 0, this.fProviderGroup, TraceDomainType.LOG4J);
            GridLayout layout = new GridLayout(1, true);
            this.fLog4jComposite.setLayout((Layout)layout);
            this.fLog4jComposite.setLayoutData(new GridData(1808));
            this.fLog4jComposite.createContent();
        }
    }

    private void disposeLog4jComposite() {
        if (this.fLog4jComposite != null) {
            this.fLog4jComposite.dispose();
            this.fLog4jComposite = null;
        }
    }

    private void createPythonComposite() {
        if (this.fPythonComposite == null) {
            this.fPythonComposite = new EnableLoggersComposite(this.fDialogComposite, 0, this.fProviderGroup, TraceDomainType.PYTHON);
            GridLayout layout = new GridLayout(1, true);
            this.fPythonComposite.setLayout((Layout)layout);
            this.fPythonComposite.setLayoutData(new GridData(1808));
            this.fPythonComposite.createContent();
        }
    }

    private void disposePythonComposite() {
        if (this.fPythonComposite != null) {
            this.fPythonComposite.dispose();
            this.fPythonComposite = null;
        }
    }
}

