/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.activator;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.ExportBreakpointsOperation;
import org.eclipse.debug.ui.actions.ImportBreakpointsOperation;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.debug.ui.util.BreakpointCacheUtil;
import org.osgi.framework.BundleContext;

public class TransformationDebugUIActivator
extends AbstractUIPlugin
implements IBreakpointListener {
    public static final String PLUGIN_ID = "org.eclipse.viatra.transformation.tooling.debug.ui";
    public static final String ICON_VIATRA_ACT_BRKP = "viatra_debug_act_brkp";
    public static final String ICON_VIATRA_ACT_BRKPD = "viatra_debug_act_brkp_dis";
    public static final String ICON_VIATRA_ACT_STOPPED = "viatra_debug_act_stopped";
    public static final String ICON_VIATRA_ACTIVATION = "viatra_debug_act";
    public static final String ICON_VIATRA_ATOM = "viatra_debug_atom";
    public static final String ICON_VIATRA_BRKP = "viatra_debug_brkp";
    public static final String ICON_VIATRA_BRKPD = "viatra_debug_brkpd";
    public static final String ICON_VIATRA_LOGO = "viatra_debug_logo";
    public static final String ICON_VIATRA_DEBUG_LOGO = "viatra_debug_logo_debugging";
    private static TransformationDebugUIActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (BreakpointCacheUtil.breakpointCacheExists()) {
            ImportBreakpointsOperation operation = new ImportBreakpointsOperation(BreakpointCacheUtil.getBreakpointCacheLocation().trim(), false, false);
            try {
                operation.run(null);
            }
            catch (InvocationTargetException e) {
                ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage(), (Throwable)e);
            }
        }
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        plugin = null;
        super.stop(context);
    }

    public static TransformationDebugUIActivator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(ICON_VIATRA_ACT_BRKP, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/activation_brkp.gif"));
        reg.put(ICON_VIATRA_ACT_BRKPD, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/activation_brkpd.gif"));
        reg.put(ICON_VIATRA_ACT_STOPPED, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/activation_stopped.gif"));
        reg.put(ICON_VIATRA_ACTIVATION, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/activation.gif"));
        reg.put(ICON_VIATRA_ATOM, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/atom.gif"));
        reg.put(ICON_VIATRA_BRKP, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/brkp_obj.gif"));
        reg.put(ICON_VIATRA_BRKPD, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/brkpd_obj.gif"));
        reg.put(ICON_VIATRA_LOGO, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/rsz_viatra_logo.png"));
        reg.put(ICON_VIATRA_DEBUG_LOGO, TransformationDebugUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/viatra_debug.gif"));
    }

    public void logException(String message, Throwable exception) {
        ILog logger = this.getLog();
        logger.log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.saveBreakPoints();
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.saveBreakPoints();
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.saveBreakPoints();
    }

    private void saveBreakPoints() {
        ExportBreakpointsOperation operation = new ExportBreakpointsOperation(BreakpointCacheUtil.filterBreakpoints(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints()), BreakpointCacheUtil.getBreakpointCacheLocation());
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

