/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class BreakpointInTargetMap<SDK, UI> {
    private final Map<SDK, UI> sdkToUiMap = new HashMap<SDK, UI>();
    private final Map<UI, SDK> uiToSdkMap = new HashMap<UI, SDK>();

    public synchronized SDK getSdkBreakpoint(UI uiBreakpoint) {
        return (SDK)BasicUtil.getSafe(this.uiToSdkMap, uiBreakpoint);
    }

    public synchronized UI getUiBreakpoint(SDK sdkBreakpoint) {
        return (UI)BasicUtil.getSafe(this.sdkToUiMap, sdkBreakpoint);
    }

    public synchronized void add(SDK sdkBreakpoint, UI uiBreakpoint) {
        SDK conflict1 = this.uiToSdkMap.put(uiBreakpoint, sdkBreakpoint);
        UI conflict2 = this.sdkToUiMap.put(sdkBreakpoint, uiBreakpoint);
        if (conflict1 != null || conflict2 != null) {
            throw new RuntimeException();
        }
    }

    public synchronized void remove(UI uiBreakpoint) {
        Object sdkBreakpoint = BasicUtil.removeSafe(this.uiToSdkMap, uiBreakpoint);
        if (sdkBreakpoint == null) {
            throw new RuntimeException();
        }
        BasicUtil.removeSafe(this.sdkToUiMap, (Object)sdkBreakpoint);
    }

    public synchronized void clear() {
        this.sdkToUiMap.clear();
        this.uiToSdkMap.clear();
    }
}

