/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.model.extensions.BPELActivityDeserializer;
import org.eclipse.bpel.model.extensions.BPELExtensionRegistry;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class ExtensionActivityValidator
extends CActivityValidator {
    @Override
    @ARule(sa=-1, desc="Check the extensionActivity", author="michal.chmielewski@oracle.com", date="02/15/2007", warnings="BPELC_UNKNOWN_EXTENSION__ACTIVITY", errors="BPELC_MISSING_EXTENSION__ACTIVITY")
    protected void start() {
        super.start();
        BPELExtensionRegistry extensionRegistry = BPELExtensionRegistry.getInstance();
        if (this.mNode.children().size() == 1) {
            INode child = this.mNode.children().get(0);
            BPELActivityDeserializer deserializer = extensionRegistry.getActivityDeserializer(child.nodeName());
            if (deserializer == null) {
                IProblem problem = this.createWarning();
                String node = this.toString(child.nodeName());
                String name = child.getAttribute(new QName("name"));
                if (name == null || name.length() == 0) {
                    name = "";
                }
                problem.fill("BPELC_UNKNOWN_EXTENSION__ACTIVITY", node, name);
            }
        } else {
            IProblem problem = this.createError();
            String node = this.toString(this.mNode.nodeName());
            String name = this.mNode.getAttribute(new QName("name"));
            if (name == null || name.length() == 0) {
                name = "";
            }
            problem.fill("BPELC_MISSING_EXTENSION__ACTIVITY", node, name);
        }
    }
}

