/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.qt.core.index.QMakeProjectInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class QMakeProjectInfoManager {
    private static final PDListener PD_LISTENER = new PDListener();
    private static final RCListener RC_LISTENER = new RCListener();
    private static final Object CACHE_SYNC = new Object();
    private static Map<IProject, QMakeProjectInfo> CACHE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void start() {
        Object object = CACHE_SYNC;
        synchronized (object) {
            CACHE = new HashMap<IProject, QMakeProjectInfo>();
        }
        CoreModel.getDefault().addCProjectDescriptionListener((ICProjectDescriptionListener)PD_LISTENER, 5);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)RC_LISTENER, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void stop() {
        ArrayList<QMakeProjectInfo> infos;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)RC_LISTENER);
        CoreModel.getDefault().removeCProjectDescriptionListener((ICProjectDescriptionListener)PD_LISTENER);
        Object object = CACHE_SYNC;
        synchronized (object) {
            infos = new ArrayList<QMakeProjectInfo>(CACHE.values());
            CACHE = null;
        }
        for (QMakeProjectInfo info : infos) {
            if (info == null) continue;
            info.destroy();
        }
    }

    public static QMakeProjectInfo getQMakeProjectInfoFor(IProject project) {
        return QMakeProjectInfoManager.getQMakeProjectInfoFor(project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QMakeProjectInfo getQMakeProjectInfoFor(IProject project, boolean create) {
        QMakeProjectInfo info;
        Object object = CACHE_SYNC;
        synchronized (object) {
            block7: {
                block6: {
                    if (CACHE != null) break block6;
                    return null;
                }
                info = CACHE.get(project);
                if (info != null) {
                    return info;
                }
                if (create) break block7;
                return null;
            }
            info = new QMakeProjectInfo(project);
            CACHE.put(project, info);
        }
        info.updateState();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeProjectFromCache(IResource project) {
        QMakeProjectInfo info;
        Object object = CACHE_SYNC;
        synchronized (object) {
            if (CACHE == null) {
                return;
            }
            info = CACHE.remove(project);
        }
        if (info != null) {
            info.destroy();
        }
    }

    private static final class PDListener
    implements ICProjectDescriptionListener {
        private PDListener() {
        }

        public void handleEvent(CProjectDescriptionEvent event) {
            QMakeProjectInfo info;
            ICDescriptionDelta projectDelta = event.getProjectDelta();
            if (projectDelta != null && (projectDelta.getChangeFlags() & 1) != 0 && (info = QMakeProjectInfoManager.getQMakeProjectInfoFor(event.getProject(), false)) != null) {
                info.updateState();
            }
        }
    }

    private static final class RCListener
    implements IResourceChangeListener {
        private RCListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            RDVisitor visitor = new RDVisitor();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IResource project = event.getResource();
                    if (project == null || project.getType() != 4) break;
                    visitor.addProjectToDelete(project);
                    break;
                }
                case 1: {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) break;
                    try {
                        delta.accept((IResourceDeltaVisitor)visitor);
                        break;
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
            visitor.process();
        }
    }

    private static final class RDVisitor
    implements IResourceDeltaVisitor {
        private final Set<IResource> projectsToDelete = new HashSet<IResource>();
        private final Set<IResource> projectsToUpdate = new HashSet<IResource>();
        private final Set<IPath> changedFiles = new HashSet<IPath>();

        private RDVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null) {
                switch (resource.getType()) {
                    case 1: {
                        this.addChangedFile(resource);
                        return false;
                    }
                    case 4: {
                        switch (delta.getKind()) {
                            case 4: {
                                if ((delta.getFlags() & 0x80000) != 0) {
                                    this.addProjectToUpdate(resource);
                                }
                                return true;
                            }
                            case 2: {
                                this.addProjectToDelete(resource);
                                return false;
                            }
                        }
                    }
                }
            }
            return true;
        }

        private void addProjectToUpdate(IResource project) {
            this.projectsToUpdate.add(project);
        }

        private void addProjectToDelete(IResource project) {
            this.projectsToDelete.add(project);
        }

        private void addChangedFile(IResource file) {
            IPath fullPath = file.getFullPath();
            if (fullPath != null) {
                this.changedFiles.add(fullPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            ArrayList<QMakeProjectInfo> infos;
            for (IResource project : this.projectsToDelete) {
                QMakeProjectInfoManager.removeProjectFromCache(project);
            }
            Object object = CACHE_SYNC;
            synchronized (object) {
                if (CACHE == null) {
                    return;
                }
                infos = new ArrayList<QMakeProjectInfo>(CACHE.values());
            }
            for (QMakeProjectInfo info : infos) {
                if (!this.projectsToUpdate.contains(info.getProject()) && !info.containsAnySensitiveFile(this.changedFiles)) continue;
                info.updateState();
            }
        }
    }
}

