/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.equinox;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.libra.framework.core.FrameworkCorePlugin;
import org.eclipse.libra.framework.core.IOSGIExecutionEnvironment;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.equinox.IEquinoxVersionHandler;
import org.eclipse.libra.framework.equinox.Messages;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.project.IBundleClasspathEntry;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.wst.server.core.IModule;

public class EquinoxHandler
implements IEquinoxVersionHandler {
    public IStatus verifyInstallPath(IPath location) {
        boolean isFound = false;
        IPath plugins = location.append("plugins");
        if (plugins.toFile().exists()) {
            File[] files;
            File[] fileArray = files = plugins.toFile().listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().indexOf("org.eclipse.osgi_") > -1) {
                    isFound = true;
                    break;
                }
                ++n2;
            }
            if (isFound) {
                return Status.OK_STATUS;
            }
        }
        return new Status(4, "org.eclipse.libra.framework.equinox", 0, Messages.warningCantReadConfig, null);
    }

    public String getFrameworkClass() {
        return "org.eclipse.core.runtime.adaptor.EclipseStarter";
    }

    public List getFrameworkClasspath(IPath installPath, IPath configPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath plugins = installPath.append("plugins");
        if (plugins.toFile().exists()) {
            File[] files;
            File[] fileArray = files = plugins.toFile().listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().indexOf("org.eclipse.osgi_") > -1) {
                    IPath path = plugins.append(file.getName());
                    cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
                }
                ++n2;
            }
        }
        return cp;
    }

    public String[] getFrameworkProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.add("-dev");
        programArgs.add("file:" + configPath.append("dev.properties").toOSString());
        programArgs.add("-configuration");
        programArgs.add(configPath.makeAbsolute().toOSString());
        if (debug) {
            programArgs.add("-debug");
        }
        programArgs.add("-os");
        programArgs.add(TargetPlatform.getOS());
        programArgs.add("-ws");
        programArgs.add(TargetPlatform.getWS());
        programArgs.add("-arch");
        programArgs.add(TargetPlatform.getOSArch());
        programArgs.add("-consoleLog");
        programArgs.add("-console");
        return programArgs.toArray(new String[programArgs.size()]);
    }

    public String[] getExcludedFrameworkProgramArguments(boolean debug, boolean starting) {
        return null;
    }

    public String[] getFrameworkVMArguments(IPath installPath, boolean jmxEnabled, int jmxPort, String javaProfileID, IPath configPath, IPath deployPath, boolean isTestEnv) {
        IExecutionEnvironment[] environment;
        String profilePath = deployPath.append("java.profile").toOSString();
        Properties javaProfileProps = null;
        IExecutionEnvironment[] iExecutionEnvironmentArray = environment = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int n = environment.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment e = iExecutionEnvironmentArray[n2];
            if (javaProfileID.equals(e.getId())) {
                javaProfileProps = e.getProfileProperties();
                break;
            }
            ++n2;
        }
        try {
            if (IOSGIExecutionEnvironment.JAVASE6_SERVER.toString().equals(javaProfileID)) {
                this.copyFile(this.getClass().getResourceAsStream("java6-server.profile"), new File(profilePath));
            } else if (javaProfileProps != null) {
                FileOutputStream os = new FileOutputStream(new File(profilePath));
                javaProfileProps.store(os, "THIS FILE IS AUTO GENERATED");
            }
        }
        catch (IOException e) {
            Trace.trace((byte)2, (String)("Could not set equinox VM arguments:" + e.getMessage()), (Throwable)e);
        }
        String vmArgs = "";
        if (javaProfileID != null && !javaProfileID.equals(IOSGIExecutionEnvironment.Default.toString())) {
            vmArgs = String.valueOf(vmArgs) + "-Dosgi.java.profile=file:" + profilePath;
        }
        if (jmxEnabled) {
            return new String[]{"-Dcom.sun.management.jmxremote.port=" + jmxPort, "-Dcom.sun.management.jmxremote.authenticate=false", "-Dcom.sun.management.jmxremote.ssl=false", "-Declipse.ignoreApp=true", "-Dosgi.noShutdown=true", vmArgs};
        }
        return new String[]{"-Declipse.ignoreApp=true", "-Dosgi.noShutdown=true", vmArgs};
    }

    public IStatus canAddModule(IModule module) {
        String id = module.getModuleType().getId();
        if ("osgi.bundle".equals(id)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.libra.framework.equinox", 0, Messages.errorNotBundle, null);
    }

    public IStatus prepareFrameworkInstanceDirectory(IPath baseDir) {
        return Status.OK_STATUS;
    }

    public IStatus prepareDeployDirectory(IPath deployPath) {
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, (String)("Creating runtime directory at " + deployPath.toOSString()));
        }
        if (!(temp = deployPath.append("plugins").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = deployPath.append("auto").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = deployPath.append("cache").toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }

    public boolean supportsServeModulesWithoutPublish() {
        return true;
    }

    public void prepareFrameworkConfigurationFile(IPath configPath, String workspaceBundles, String frameworkJar, TargetBundle[] kernelBundles) {
        String[] wsBundleIds = workspaceBundles.split(" ");
        this.prepareDevProperties(configPath, wsBundleIds);
        this.prepareConfigIni(configPath, wsBundleIds, frameworkJar, kernelBundles);
    }

    private void prepareConfigIni(IPath configPath, String[] wsBundleIds, String frameworkJar, TargetBundle[] krBundles) {
        int n;
        int n2;
        Object[] objectArray;
        String propertyInstall = "";
        String[] stringArray = wsBundleIds;
        int n3 = wsBundleIds.length;
        int n4 = 0;
        while (n4 < n3) {
            IPluginModelBase[] models;
            String bundle = stringArray[n4];
            if (bundle.indexOf("@") != -1) {
                bundle = bundle.substring(0, bundle.indexOf("@"));
            }
            objectArray = models = PluginRegistry.getWorkspaceModels();
            n2 = models.length;
            n = 0;
            while (n < n2) {
                IPluginModelBase iPluginModelBase = objectArray[n];
                if (bundle.indexOf(iPluginModelBase.getPluginBase().getId()) > -1) {
                    String bpath = iPluginModelBase.getInstallLocation();
                    if (bpath.endsWith("/")) {
                        bpath = bpath.substring(0, bpath.length() - 1);
                    }
                    propertyInstall = iPluginModelBase.isFragmentModel() ? String.valueOf(propertyInstall) + "reference:file:" + bpath + ", " : String.valueOf(propertyInstall) + "reference:file:" + bpath + "@start, ";
                }
                ++n;
            }
            ++n4;
        }
        Properties properties = new Properties();
        properties.setProperty("osgi.instance.area.default", "file:" + configPath.toPortableString().substring(0, configPath.toPortableString().indexOf(".metadata")));
        properties.put("osgi.framework", frameworkJar);
        properties.setProperty("osgi.configuration.cascaded", "false");
        int start = 4;
        properties.put("osgi.bundles.defaultStartLevel", Integer.toString(start));
        int i = 0;
        while (i < krBundles.length) {
            String targetBundlePath = "reference:file:" + krBundles[i].getBundleInfo().getLocation().getRawPath();
            if (targetBundlePath != null && !targetBundlePath.trim().equalsIgnoreCase("") && targetBundlePath.indexOf("org.eclipse.osgi_") <= -1) {
                File file = new File(targetBundlePath.substring(targetBundlePath.indexOf("/")));
                if (file.isFile()) {
                    propertyInstall = String.valueOf(propertyInstall) + targetBundlePath;
                    propertyInstall = krBundles[i].isFragment() ? String.valueOf(propertyInstall) + ", " : String.valueOf(propertyInstall) + "@start, ";
                } else {
                    objectArray = file.list();
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        IPluginModelBase string2 = objectArray[n];
                        if (string2.indexOf(".jar") > -1) {
                            propertyInstall = String.valueOf(propertyInstall) + targetBundlePath + (String)string2;
                            String fbundleId = this.getBundleId((String)string2);
                            PluginRegistry.findModel((String)fbundleId);
                            propertyInstall = krBundles[i].isFragment() ? String.valueOf(propertyInstall) + ", " : String.valueOf(propertyInstall) + "@start, ";
                        }
                        ++n;
                    }
                }
            }
            ++i;
        }
        properties.setProperty("osgi.bundles", propertyInstall);
        properties.put("eclipse.ignoreApp", "true");
        properties.put("osgi.noShutdown", "true");
        try {
            properties.store(new FileOutputStream(configPath.append("config.ini").makeAbsolute().toFile()), "## AUTO GENERATED ##");
        }
        catch (IOException e) {
            Trace.trace((byte)2, (String)("Could not create equinox dev.properties configrutaion file:" + e.getMessage()), (Throwable)e);
        }
    }

    private String getBundleId(String targetBundlePath) {
        int vversioNloc;
        Path kbPath = new Path(targetBundlePath);
        String bundleId = kbPath.lastSegment();
        if (bundleId.endsWith(".jar")) {
            bundleId = bundleId.substring(0, bundleId.length() - 4);
        }
        if ((vversioNloc = bundleId.indexOf("_")) > 0) {
            bundleId = bundleId.substring(0, vversioNloc);
        }
        return bundleId;
    }

    private String[] prepareDevProperties(IPath configPath, String[] wsBundleIds) {
        try {
            FileWriter fstream = new FileWriter(String.valueOf(configPath.toPortableString()) + "/dev.properties");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("#OSAMI AUTO GENERATED\n");
            String[] stringArray = wsBundleIds;
            int n = wsBundleIds.length;
            int n2 = 0;
            while (n2 < n) {
                String bundle = stringArray[n2];
                if (bundle.indexOf("@") != -1) {
                    bundle = bundle.substring(0, bundle.indexOf("@"));
                }
                IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
                String modelId = "";
                IPluginModelBase[] iPluginModelBaseArray = models;
                int n3 = models.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n4];
                    if (bundle.indexOf(iPluginModelBase.getPluginBase().getId()) > -1) {
                        IPath ploc;
                        IProject pluginProject = iPluginModelBase.getUnderlyingResource().getProject();
                        IJavaProject javaProject = JavaCore.create((IProject)pluginProject);
                        IBundleProjectDescription bundleProjectDescription = FrameworkCorePlugin.getDescription((IProject)pluginProject);
                        Path bpath = new Path(iPluginModelBase.getInstallLocation());
                        bpath = bpath.equals((Object)(ploc = pluginProject.getLocation())) ? pluginProject.getFullPath() : bpath.makeRelativeTo(ploc.removeLastSegments(1));
                        IBundleClasspathEntry[] allCPEntry = bundleProjectDescription.getBundleClasspath();
                        modelId = iPluginModelBase.getPluginBase().getId();
                        out.write("\n" + modelId + "=");
                        IBundleClasspathEntry[] iBundleClasspathEntryArray = allCPEntry;
                        int n5 = allCPEntry.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IBundleClasspathEntry bcpe = iBundleClasspathEntryArray[n6];
                            if (bcpe.getSourcePath() != null && bcpe.getBinaryPath() == null) {
                                out.write(" " + ploc.removeLastSegments(1).append(javaProject.getOutputLocation()) + ",");
                            } else if (bcpe.getSourcePath() != null && bcpe.getBinaryPath() != null) {
                                out.write(" " + bcpe.getBinaryPath().toOSString() + ",");
                            } else if (bcpe.getLibrary() != null && bcpe.getLibrary().toOSString().endsWith(".jar")) {
                                out.write(" " + bcpe.getLibrary().toOSString() + ",");
                            } else {
                                out.write(" " + javaProject.getOutputLocation().makeRelativeTo(pluginProject.getFullPath()) + ",");
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            out.close();
        }
        catch (Exception e) {
            Trace.trace((byte)2, (String)("Could not create equinox dev.properties configuration file:" + e.getMessage()), (Throwable)e);
        }
        return wsBundleIds;
    }

    private void copyFile(InputStream source, File destFile) throws IOException {
        FileOutputStream destination = null;
        try {
            int c;
            destination = new FileOutputStream(destFile);
            while ((c = source.read()) != -1) {
                destination.write(c);
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

