/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.preferences.MavenConfigurationImpl;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectCreationListener;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.eclipse.m2e.tests.common.FileHelpers;
import org.eclipse.m2e.tests.common.FilexWagon;
import org.eclipse.m2e.tests.common.JobHelpers;
import org.eclipse.m2e.tests.common.WorkspaceHelpers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractMavenProjectTestCase {
    public static final int DELETE_RETRY_COUNT = 10;
    public static final long DELETE_RETRY_DELAY = 6000L;
    protected static final IProgressMonitor monitor = new NullProgressMonitor();
    protected IWorkspace workspace;
    @Rule
    public TestName name = new TestName();
    protected File repo;
    protected ProjectRegistryRefreshJob projectRefreshJob;
    protected Job downloadSourcesJob;
    protected IMavenConfiguration mavenConfiguration;
    private String oldUserSettingsFile;

    @Before
    public void setUp() throws Exception {
        ArtifactRepository localRepository;
        this.workspace = ResourcesPlugin.getWorkspace();
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.setAutoBuilding(false);
        this.setAutomaticallyUpdateConfiguration(false);
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", ".svn/");
        JavaCore.setOptions((Hashtable)options);
        this.projectRefreshJob = MavenPluginActivator.getDefault().getProjectManagerRefreshJob();
        this.projectRefreshJob.sleep();
        this.downloadSourcesJob = ((BuildPathManager)MavenJdtPlugin.getDefault().getBuildpathManager()).getDownloadSourcesJob();
        this.downloadSourcesJob.sleep();
        this.oldUserSettingsFile = this.mavenConfiguration.getUserSettingsFile();
        File settings = new File("settings.xml").getCanonicalFile();
        if (settings.canRead()) {
            String userSettingsFile = settings.getAbsolutePath();
            this.mavenConfiguration.setUserSettingsFile(userSettingsFile);
        }
        if ((localRepository = MavenPlugin.getMaven().getLocalRepository()) != null) {
            this.repo = new File(localRepository.getBasedir());
        } else {
            Assert.fail((String)"Cannot determine local repository path");
        }
        LifecycleMappingFactory.setUseDefaultLifecycleMappingMetadataSource((boolean)true);
        LifecycleMappingFactory.setDefaultLifecycleMappingMetadataSource(null);
        WorkspaceHelpers.cleanWorkspace();
        FilexWagon.setRequestFailPattern(null);
        FilexWagon.setRequestFilterPattern(null, true);
    }

    @After
    public void tearDown() throws Exception {
        this.waitForJobsToComplete();
        WorkspaceHelpers.cleanWorkspace();
        this.mavenConfiguration.setUserSettingsFile(this.oldUserSettingsFile);
        this.projectRefreshJob.wakeUp();
        this.setAutoBuilding(false);
        this.setAutomaticallyUpdateConfiguration(false);
        FilexWagon.reset();
    }

    protected void setAutoBuilding(boolean autobuilding) throws CoreException {
        IWorkspaceDescription description = this.workspace.getDescription();
        description.setAutoBuilding(autobuilding);
        this.workspace.setDescription(description);
    }

    protected boolean isAutoBuilding() {
        IWorkspaceDescription description = this.workspace.getDescription();
        return description.isAutoBuilding();
    }

    protected void setAutomaticallyUpdateConfiguration(boolean update) {
        ((MavenConfigurationImpl)this.mavenConfiguration).setAutomaticallyUpdateConfiguration(update);
    }

    protected void refreshMavenProject(IProject project) {
        MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(project, false, false));
    }

    protected void deleteProject(String projectName) throws CoreException, InterruptedException {
        IProject project = this.workspace.getRoot().getProject(projectName);
        this.deleteProject(project);
    }

    protected void deleteProject(IProject project) throws InterruptedException, CoreException {
        Exception cause = null;
        int i = 0;
        while (i < 10) {
            block5: {
                try {
                    this.doDeleteProject(project);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    cause = e;
                    Thread.sleep(6000L);
                    break block5;
                }
                return;
            }
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", "Could not delete project", (Throwable)cause));
    }

    private void doDeleteProject(final IProject project) throws CoreException, InterruptedException {
        AbstractMavenProjectTestCase.waitForJobsToComplete(monitor);
        this.workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (project.exists()) {
                    this.deleteMember(".classpath", project, monitor);
                    this.deleteMember(".project", project, monitor);
                    project.delete(false, true, monitor);
                }
            }

            private void deleteMember(String name, IProject project2, IProgressMonitor monitor) throws CoreException {
                IResource member = project2.findMember(name);
                if (member != null && member.exists()) {
                    member.delete(true, monitor);
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    protected IProject createProject(String projectName, String pomResource) throws CoreException {
        IProject project = this.workspace.getRoot().getProject(projectName);
        this.workspace.run(monitor -> {
            IFile pomFile;
            project.create(monitor);
            if (!project.isOpen()) {
                project.open(monitor);
            }
            if (!(pomFile = project.getFile("pom.xml")).exists()) {
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(pomResource);
                        pomFile.create((InputStream)is, true, monitor);
                    }
                    catch (FileNotFoundException ex) {
                        throw new CoreException((IStatus)new Status(4, "", 0, ex.toString(), (Throwable)ex));
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    throw throwable;
                }
                IOUtil.close((InputStream)is);
            }
        }, null);
        return project;
    }

    protected IProject createExisting(String projectName, String projectLocation) throws IOException, CoreException {
        return this.createExisting(projectName, projectLocation, false);
    }

    protected IProject createExisting(String projectName, String projectLocation, boolean addNature) throws IOException, CoreException {
        File dir = new File(this.workspace.getRoot().getLocation().toFile(), projectName);
        if (dir.isFile()) {
            dir = dir.getParentFile();
        }
        AbstractMavenProjectTestCase.copyDir(new File(projectLocation), dir);
        IProject project = this.workspace.getRoot().getProject(projectName);
        this.workspace.run(monitor -> {
            if (!project.exists()) {
                IProjectDescription projectDescription = this.workspace.newProjectDescription(project.getName());
                if (addNature) {
                    projectDescription.setNatureIds(new String[]{"org.eclipse.m2e.core.maven2Nature"});
                }
                projectDescription.setLocation(null);
                project.create(projectDescription, monitor);
                project.open(0, monitor);
            } else {
                project.refreshLocal(2, monitor);
            }
        }, null);
        if (!this.isAutoBuilding()) {
            this.refreshMavenProject(project);
        }
        return project;
    }

    protected IProject importProject(String pomLocation) throws IOException, CoreException {
        return this.importProject(pomLocation, new ResolverConfiguration());
    }

    protected IProject importProject(String pomLocation, ResolverConfiguration configuration) throws IOException, CoreException {
        return this.importProject(pomLocation, configuration, null);
    }

    protected IProject importProject(String pomLocation, ResolverConfiguration configuration, IProjectCreationListener listener) throws IOException, CoreException {
        File pomFile = new File(pomLocation);
        return this.importProjects(pomFile.getParentFile().getCanonicalPath(), new String[]{pomFile.getName()}, configuration, false, listener)[0];
    }

    protected IProject[] importProjects(String basedir, String[] pomNames, ResolverConfiguration configuration) throws IOException, CoreException {
        return this.importProjects(basedir, pomNames, configuration, false);
    }

    protected IProject[] importProjects(String basedir, String[] pomNames, ResolverConfiguration configuration, boolean skipSanityCheck) throws IOException, CoreException {
        return this.importProjects(basedir, pomNames, configuration, skipSanityCheck, null);
    }

    protected IProject[] importProjects(String basedir, String[] pomNames, ResolverConfiguration configuration, boolean skipSanityCheck, IProjectCreationListener listener) throws IOException, CoreException {
        Model model;
        MavenModelManager mavenModelManager = MavenPlugin.getMavenModelManager();
        IWorkspaceRoot root = this.workspace.getRoot();
        File src = new File(basedir);
        File dst = new File(root.getLocation().toFile(), src.getName());
        AbstractMavenProjectTestCase.copyDir(src, dst);
        ArrayList<MavenProjectInfo> projectInfos = new ArrayList<MavenProjectInfo>();
        String[] stringArray = pomNames;
        int n = pomNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pomName = stringArray[n2];
            File pomFile = new File(dst, pomName);
            model = mavenModelManager.readMavenModel(pomFile);
            MavenProjectInfo projectInfo = new MavenProjectInfo(pomName, pomFile, model, null);
            this.setBasedirRename(projectInfo);
            projectInfos.add(projectInfo);
            ++n2;
        }
        ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration(configuration);
        ArrayList importResults = new ArrayList();
        this.workspace.run(monitor -> {
            boolean bl = importResults.addAll(MavenPlugin.getProjectConfigurationManager().importProjects((Collection)projectInfos, importConfiguration, listener, monitor));
        }, MavenPlugin.getProjectConfigurationManager().getRule(), 1, AbstractMavenProjectTestCase.monitor);
        IProject[] projects = new IProject[projectInfos.size()];
        int i = 0;
        while (i < projectInfos.size()) {
            IMavenProjectImportResult importResult = (IMavenProjectImportResult)importResults.get(i);
            Assert.assertSame(projectInfos.get(i), (Object)importResult.getMavenProjectInfo());
            projects[i] = importResult.getProject();
            Assert.assertNotNull((String)("Failed to import project " + projectInfos), (Object)projects[i]);
            if (!skipSanityCheck) {
                model = ((MavenProjectInfo)projectInfos.get(i)).getModel();
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(projects[i], AbstractMavenProjectTestCase.monitor);
                if (facade == null) {
                    Assert.fail((String)("Project " + model.getGroupId() + "-" + model.getArtifactId() + "-" + model.getVersion() + " was not imported. Errors: " + WorkspaceHelpers.toString(WorkspaceHelpers.findErrorMarkers(projects[i]))));
                }
            }
            ++i;
        }
        return projects;
    }

    private void setBasedirRename(MavenProjectInfo projectInfo) throws IOException {
        File workspaceRoot = this.workspace.getRoot().getLocation().toFile();
        File basedir = projectInfo.getPomFile().getParentFile().getCanonicalFile();
        projectInfo.setBasedirRename(basedir.getParentFile().equals(workspaceRoot) ? 2 : 0);
    }

    protected IProject importProject(String projectName, String projectLocation, ResolverConfiguration configuration) throws IOException, CoreException {
        ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration(configuration);
        importConfiguration.setProjectNameTemplate(projectName);
        return this.importProject(projectName, projectLocation, importConfiguration);
    }

    protected IProject importProject(String projectName, String projectLocation, ProjectImportConfiguration importConfiguration) throws IOException, CoreException {
        File dir = new File(this.workspace.getRoot().getLocation().toFile(), projectName);
        AbstractMavenProjectTestCase.copyDir(new File(projectLocation), dir);
        File pomFile = new File(dir, "pom.xml");
        Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
        MavenProjectInfo projectInfo = new MavenProjectInfo(projectName, pomFile, model, null);
        this.setBasedirRename(projectInfo);
        this.workspace.run(monitor -> {
            MavenPlugin.getProjectConfigurationManager().importProjects(Collections.singleton(projectInfo), importConfiguration, monitor);
            IProject project = this.workspace.getRoot().getProject(importConfiguration.getProjectName(projectInfo.getModel()));
            Assert.assertNotNull((String)("Failed to import project " + projectInfo), (Object)project);
        }, MavenPlugin.getProjectConfigurationManager().getRule(), 1, AbstractMavenProjectTestCase.monitor);
        return this.workspace.getRoot().getProject(projectName);
    }

    protected void waitForJobsToComplete() throws InterruptedException, CoreException {
        AbstractMavenProjectTestCase.waitForJobsToComplete(monitor);
    }

    public static void waitForJobsToComplete(IProgressMonitor monitor) throws InterruptedException, CoreException {
        JobHelpers.waitForJobsToComplete(monitor);
    }

    protected IClasspathEntry[] getMavenContainerEntries(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathContainer container = BuildPathManager.getMaven2ClasspathContainer((IJavaProject)javaProject);
        return container.getClasspathEntries();
    }

    protected static String toString(IMarker[] markers) {
        return WorkspaceHelpers.toString(markers);
    }

    protected static String toString(List<IMarker> markers) {
        return WorkspaceHelpers.toString(markers);
    }

    protected void copyContent(IProject project, String from, String to) throws Exception {
        this.copyContent(project, project.getFile(from).getContents(), to, true);
    }

    protected void copyContent(IProject project, String from, String to, boolean waitForJobsToComplete) throws Exception {
        this.copyContent(project, project.getFile(from).getContents(), to, waitForJobsToComplete);
    }

    protected void copyContent(IProject project, File from, String to) throws Exception {
        this.copyContent(project, new FileInputStream(from), to, true);
    }

    private void copyContent(IProject project, InputStream contents, String to, boolean waitForJobsToComplete) throws CoreException, IOException, InterruptedException {
        IFile file;
        try {
            file = project.getFile(to);
            if (!file.exists()) {
                file.create(contents, 1, monitor);
            } else {
                file.setContents(contents, 1, monitor);
            }
        }
        finally {
            contents.close();
        }
        if (waitForJobsToComplete) {
            if (!this.isAutoBuilding() && file.getParent().getType() == 4 && "pom.xml".equals(file.getName())) {
                this.refreshMavenProject(project);
            }
            this.waitForJobsToComplete();
        }
    }

    public static void copyDir(File src, File dst) throws IOException {
        FileHelpers.copyDir(src, dst);
    }

    public static void copyDir(File src, File dst, FileFilter filter) throws IOException {
        FileHelpers.copyDir(src, dst, filter);
    }

    protected static List<IMarker> findErrorMarkers(IProject project) throws CoreException {
        return WorkspaceHelpers.findErrorMarkers(project);
    }

    protected static List<IMarker> findMarkers(IProject project, int targetSeverity) throws CoreException {
        return WorkspaceHelpers.findMarkers(project, targetSeverity);
    }

    protected static void assertNoErrors(IProject project) throws CoreException {
        WorkspaceHelpers.assertNoErrors(project);
    }

    protected static Set<IProject> getProjectsFromEvents(Collection<MavenProjectChangedEvent> events) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (MavenProjectChangedEvent event : events) {
            projects.add(event.getSource().getProject());
        }
        return projects;
    }

    @SafeVarargs
    protected static <T> void assertContainsOnly(Set<? extends T> actual, T ... expected) {
        HashSet expectedSet = new HashSet();
        Collections.addAll(expectedSet, expected);
        Assert.assertEquals(expectedSet, actual);
    }

    protected void injectFilexWagon() throws Exception {
        PlexusContainer container = ((MavenImpl)MavenPlugin.getMaven()).getPlexusContainer();
        if (container.getContainerRealm().getResource(String.valueOf(FilexWagon.class.getName().replace('.', '/')) + ".class") == null) {
            container.getContainerRealm().importFrom(FilexWagon.class.getClassLoader(), FilexWagon.class.getName());
            ComponentDescriptor descriptor = new ComponentDescriptor();
            descriptor.setRealm(container.getContainerRealm());
            descriptor.setRoleClass(Wagon.class);
            descriptor.setImplementationClass(FilexWagon.class);
            descriptor.setRoleHint("filex");
            descriptor.setInstantiationStrategy("per-lookup");
            container.addComponentDescriptor(descriptor);
        }
    }

    protected void deserializeFromWorkspaceState(IMavenProjectFacade projectFacade) throws IllegalAccessException {
        Field[] fieldArray = projectFacade.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isTransient(field.getModifiers())) {
                field.setAccessible(true);
                field.set(projectFacade, null);
            }
            ++n2;
        }
        MavenPluginActivator.getDefault().getMavenProjectManagerImpl().putMavenProject((MavenProjectFacade)projectFacade, null);
    }
}

