/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.opener;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.facet.util.emf.core.IEObjectBrowserOpener;
import org.eclipse.modisco.facet.util.emf.core.IEPackageBrowserOpener;
import org.eclipse.modisco.facet.util.emf.core.IResourceBrowserOpener;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.editors.BrowserUtils;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.common.ui.internal.editorInputs.ResourceEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class BrowserOpener
implements IResourceBrowserOpener,
IEPackageBrowserOpener,
IEObjectBrowserOpener {
    public void openResource(final Resource resource) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)new ResourceEditorInput(resource), (String)"org.eclipse.modisco.infra.browser.editorID", (boolean)true);
                }
                catch (Exception e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)MoDiscoBrowserPlugin.getPlugin());
                }
            }
        });
    }

    public void openEObject(EObject eObject) {
        BrowserUtils.openEObjectInBrowser(eObject, true);
    }

    public void openEPackage(EPackage ePackage) {
        try {
            URIEditorInput input = new URIEditorInput(URI.createURI((String)ePackage.getNsURI()));
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"org.eclipse.modisco.infra.browser.editorID", (boolean)true);
        }
        catch (Exception e) {
            MoDiscoBrowserPlugin.logException(e);
        }
    }

    public String getBrowserName() {
        return EcoreBrowser.HUMAN_READABLE_NAME;
    }
}

