/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.rcptt.internal.launching.ext.ui.ExternalAUTMainTab;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AUTProgramBlock {
    protected Combo fApplicationCombo;
    private Button fProductButton;
    private Combo fProductCombo;
    private Button fApplicationButton;
    private ExternalAUTMainTab fTab;
    private Listener fListener = new Listener();
    private ControlDecoration fProductComboDecoration;
    private String configurationProductName;

    private void updateProductDecorator() {
        if (!this.fProductCombo.isEnabled()) {
            this.fProductComboDecoration.hide();
            return;
        }
        String productValue = this.fProductCombo.getText();
        String[] knownProducts = this.getProductNames();
        boolean found = false;
        int i = 0;
        while (i < knownProducts.length) {
            String knownProduct = knownProducts[i];
            if (knownProduct.equals(productValue)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            this.fProductComboDecoration.hide();
        } else {
            this.fProductComboDecoration.show();
        }
    }

    public AUTProgramBlock(ExternalAUTMainTab tab) {
        this.fTab = tab;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.ProgramBlock_programToRun);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createProductSection((Composite)group);
        this.createApplicationSection((Composite)group);
    }

    protected void createProductSection(Composite parent) {
        this.fProductButton = new Button(parent, 16);
        this.fProductButton.setText(PDEUIMessages.ProgramBlock_runProduct);
        this.fProductButton.addSelectionListener((SelectionListener)this.fListener);
        this.fProductCombo = SWTFactory.createCombo((Composite)parent, (int)4, (int)1, (String[])this.getProductNames());
        this.fProductCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fProductCombo.addModifyListener((ModifyListener)this.fListener);
        this.fProductComboDecoration = new ControlDecoration((Control)this.fProductCombo, 16512);
        FieldDecoration warningDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
        this.fProductComboDecoration.setDescriptionText(PDEUIMessages.ProgramBlock_productDecorationWarning0);
        this.fProductComboDecoration.setImage(warningDecoration.getImage());
    }

    private String[] getProductNames() {
        ITargetPlatformHelper target = this.fTab.getTarget();
        if (target != null) {
            return target.getProducts();
        }
        return new String[0];
    }

    private String[] getApplicationNames() {
        ITargetPlatformHelper target = this.fTab.getTarget();
        if (target != null) {
            return target.getApplications();
        }
        return new String[0];
    }

    private String getDefaultApplication() {
        String result;
        ITargetPlatformHelper target = this.fTab.getTarget();
        if (target != null && (result = target.getDefaultApplication()) != null) {
            return result;
        }
        return "org.eclipse.ui.ide.workbench";
    }

    protected void createApplicationSection(Composite parent) {
        this.fApplicationButton = new Button(parent, 16);
        this.fApplicationButton.setText(PDEUIMessages.ProgramBlock_runApplication);
        this.fApplicationCombo = SWTFactory.createCombo((Composite)parent, (int)12, (int)1, (String[])this.getApplicationNames());
        this.fApplicationCombo.addSelectionListener((SelectionListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.initializeProductSection(config);
        this.initializeApplicationSection(config);
        boolean bUseProduct = config.getAttribute("useProduct", false);
        this.updateProductEnablement(bUseProduct);
        boolean useProduct = bUseProduct && this.fProductCombo.getItemCount() > 0;
        this.fApplicationButton.setSelection(!useProduct);
        this.fProductButton.setSelection(useProduct);
        this.updateProductDecorator();
    }

    private void updateProductEnablement(boolean bUseProduct) {
        boolean useProduct = bUseProduct && this.fProductCombo.getItemCount() > 0;
        this.fApplicationCombo.setEnabled(!useProduct);
        this.fProductButton.setEnabled(this.fProductCombo.getItemCount() > 0);
        this.fProductCombo.setEnabled(useProduct);
    }

    protected void initializeProductSection(ILaunchConfiguration config) throws CoreException {
        this.configurationProductName = config.getAttribute("product", null);
        if (this.configurationProductName != null) {
            this.fProductCombo.setText(this.configurationProductName);
        }
    }

    protected void initializeApplicationSection(ILaunchConfiguration config) throws CoreException {
        String attribute = this.getApplicationAttribute();
        String application = config.getAttribute(attribute, null);
        if (application == null || this.fApplicationCombo.indexOf(application) == -1) {
            application = null;
            StringTokenizer tokenizer = new StringTokenizer(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equals("-application") || !tokenizer.hasMoreTokens()) continue;
                application = tokenizer.nextToken();
                break;
            }
            int index = -1;
            if (application != null) {
                index = this.fApplicationCombo.indexOf(application);
            }
            if (index == -1) {
                index = this.fApplicationCombo.indexOf(this.getDefaultApplication());
            }
            if (index != -1) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(index));
            } else if (this.fApplicationCombo.getItemCount() > 0) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(0));
            }
        } else {
            this.fApplicationCombo.setText(application);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.saveApplicationSection(config);
        this.saveProductSection(config);
    }

    protected void saveProductSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("useProduct", this.fProductButton.getSelection());
        config.setAttribute("product", this.fProductCombo.getText());
    }

    protected void saveApplicationSection(ILaunchConfigurationWorkingCopy config) {
        String text = this.fApplicationCombo.getText();
        String attribute = this.getApplicationAttribute();
        if (text.length() == 0 || text.equals(TargetPlatform.getDefaultApplication())) {
            config.setAttribute(attribute, null);
        } else {
            config.setAttribute(attribute, text);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        String product = TargetPlatform.getDefaultProduct();
        if (product != null) {
            config.setAttribute("useProduct", true);
            config.setAttribute("product", product);
        }
    }

    protected String getApplicationAttribute() {
        return "application";
    }

    public void updateInfo(ITargetPlatformHelper currentTargetPlatform) {
        if (this.fProductCombo.isDisposed() || this.fApplicationCombo.isDisposed()) {
            return;
        }
        if (currentTargetPlatform != null) {
            String product;
            String productText;
            String[] products = currentTargetPlatform.getProducts();
            String[] applications = currentTargetPlatform.getApplications();
            this.fProductCombo.setItems(products);
            this.fApplicationCombo.setItems(applications);
            this.updateProductEnablement(this.fProductButton.getSelection());
            String applicationText = this.fApplicationCombo.getText();
            if (applicationText == null || applicationText.trim().length() == 0) {
                String defaultApplication = currentTargetPlatform.getDefaultApplication();
                if (defaultApplication != null && this.fApplicationCombo.indexOf(defaultApplication) != -1) {
                    this.fApplicationCombo.setText(defaultApplication);
                } else if (applications.length != 0) {
                    this.fApplicationCombo.setText(applications[0]);
                }
            }
            if (((productText = this.fProductCombo.getText()) == null || productText.trim().length() == 0) && (product = currentTargetPlatform.getDefaultProduct()) != null) {
                this.fProductCombo.setText(product);
                this.fProductButton.setSelection(true);
                this.fApplicationButton.setSelection(false);
                this.fProductCombo.setEnabled(true);
                this.fApplicationCombo.setEnabled(false);
                this.updateProductDecorator();
            }
        } else {
            this.fProductCombo.setItems(new String[0]);
            this.fApplicationCombo.setItems(new String[0]);
            this.updateProductDecorator();
        }
    }

    class Listener
    extends SelectionAdapter
    implements ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AUTProgramBlock.this.fProductButton) {
                boolean enabled = AUTProgramBlock.this.fProductButton.getSelection();
                AUTProgramBlock.this.fProductCombo.setEnabled(enabled);
                AUTProgramBlock.this.fApplicationCombo.setEnabled(!enabled);
                AUTProgramBlock.this.updateProductDecorator();
            }
            AUTProgramBlock.this.fTab.scheduleUpdateJob();
        }

        public void modifyText(ModifyEvent e) {
            if (e.getSource() == AUTProgramBlock.this.fProductCombo) {
                AUTProgramBlock.this.updateProductDecorator();
            }
        }
    }
}

