/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.Before;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunBefores
extends AbstractStatementWithScreenshot {
    private final List<FrameworkMethod> befores;
    private Requirements requirements;

    public RunBefores(String configId, Statement next, TestClass testClass, FrameworkMethod method, Object target, Requirements requirements) {
        super(configId, next, testClass, method, target);
        this.befores = testClass.getAnnotatedMethods(Before.class);
        this.requirements = requirements;
    }

    public void evaluate() throws Throwable {
        FrameworkMethod before = null;
        try {
            this.requirements.runBefore();
            Iterator<FrameworkMethod> iterator = this.befores.iterator();
            while (iterator.hasNext()) {
                FrameworkMethod bfr;
                before = bfr = iterator.next();
                before.invokeExplosively(this.target, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            if (ScreenshotCapturer.shouldCaptureScreenshotOnException(throwable)) {
                if (this.isClassLevel()) {
                    this.frameworkMethod = before;
                    this.createScreenshot("Before");
                } else {
                    this.createScreenshot("Before_" + before.getName());
                }
            }
            throw throwable;
        }
        this.nextStatement.evaluate();
    }
}

