/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template.ast;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.s.structured.IStructuredType;
import org.eclipse.scout.sdk.core.s.structured.StructuredType;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstMethodBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.WrappedTrackedNodePosition;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstInnerTypeGetterBuilder
extends AstMethodBuilder<AstInnerTypeGetterBuilder> {
    private String m_innerTypeFindMethodName;
    private Expression m_leftHandSideExpression;
    private String m_readOnlyPrefix;
    private String m_readOnlySuffix;
    private SimpleName m_typeLiteralName;

    protected AstInnerTypeGetterBuilder(AstNodeFactory owner) {
        super(owner);
    }

    public AstInnerTypeGetterBuilder withMethodNameToFindInnerType(String innerTypeFindMethodName) {
        this.m_innerTypeFindMethodName = innerTypeFindMethodName;
        return this;
    }

    public AstInnerTypeGetterBuilder withReadOnlySuffix(String suffix) {
        this.m_readOnlySuffix = suffix;
        return this;
    }

    public AstInnerTypeGetterBuilder withReadOnlyPrefix(String prefix) {
        this.m_readOnlyPrefix = prefix;
        return this;
    }

    public AstInnerTypeGetterBuilder withMethodToFindInnerTypeExpression(Expression methodToFindInnerTypeExp) {
        this.m_leftHandSideExpression = methodToFindInnerTypeExp;
        return this;
    }

    public String getReadOnlyPrefix() {
        return this.m_readOnlyPrefix;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    public String getMethodNameToFinderInnerType() {
        return this.m_innerTypeFindMethodName;
    }

    public Expression getMethodToFindInnerTypeExpression() {
        return this.m_leftHandSideExpression;
    }

    @Override
    public String getMethodName() {
        return this.getReadOnlyPrefix() + super.getMethodName() + this.getReadOnlySuffix();
    }

    protected Block getInnerTypeGetterBody() {
        AST ast = this.getFactory().getAst();
        TypeLiteral fieldClass = ast.newTypeLiteral();
        this.m_typeLiteralName = ast.newSimpleName(super.getMethodName() + this.getReadOnlySuffix());
        fieldClass.setType((Type)ast.newSimpleType((Name)this.m_typeLiteralName));
        MethodInvocation get = ast.newMethodInvocation();
        get.setName(ast.newSimpleName(this.m_innerTypeFindMethodName));
        get.arguments().add(fieldClass);
        if (this.m_leftHandSideExpression != null) {
            get.setExpression(this.m_leftHandSideExpression);
        }
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression((Expression)get);
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        return body;
    }

    @Override
    public AstInnerTypeGetterBuilder insert() {
        if (this.getModifiers().isEmpty()) {
            this.withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        }
        if (this.getReadOnlyPrefix() == null) {
            this.withReadOnlyPrefix("get");
        }
        if (this.getReadOnlySuffix() == null) {
            this.withReadOnlySuffix("");
        }
        if (this.getBody() == null) {
            this.withBody(this.getInnerTypeGetterBody());
        }
        Ensure.notNull((Object)this.getMethodNameToFinderInnerType());
        super.insert();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            WrappedTrackedNodePosition methodPos = new WrappedTrackedNodePosition(this.getFactory().getRewrite().track((ASTNode)this.get().getName()), this.getReadOnlyPrefix().length(), -this.getReadOnlyPrefix().length() - this.getReadOnlySuffix().length());
            Type returnTypeNode = this.getReturnType();
            if (returnTypeNode instanceof QualifiedType) {
                QualifiedType t = (QualifiedType)returnTypeNode;
                returnTypeNode = t.getName();
            }
            WrappedTrackedNodePosition returnNamePos = new WrappedTrackedNodePosition(this.getFactory().getRewrite().track((ASTNode)returnTypeNode), 0, -this.getReadOnlySuffix().length());
            WrappedTrackedNodePosition typeLiteralPos = new WrappedTrackedNodePosition(this.getFactory().getRewrite().track((ASTNode)this.m_typeLiteralName), 0, -this.getReadOnlySuffix().length());
            links.addLinkedPosition(returnNamePos, false, "TYPE_NAME");
            links.addLinkedPosition(methodPos, false, "TYPE_NAME");
            links.addLinkedPosition(typeLiteralPos, false, "TYPE_NAME");
        }
        return this;
    }

    @Override
    protected void insertMethod() {
        ASTNode methodSibling = AstInnerTypeGetterBuilder.getSiblingForGetter(this.get().getName().getIdentifier(), this.getDeclaringType(), this.getFactory().getScoutElementProvider());
        ListRewrite rewrite = this.getFactory().getRewrite().getListRewrite((ASTNode)this.getDeclaringType(), this.getDeclaringType().getBodyDeclarationsProperty());
        if (methodSibling == null) {
            List originalList = rewrite.getOriginalList();
            if (originalList.isEmpty()) {
                rewrite.insertFirst((ASTNode)this.get(), null);
            } else {
                rewrite.insertAfter((ASTNode)this.get(), (ASTNode)originalList.get(originalList.size() - 1), null);
            }
        } else {
            rewrite.insertBefore((ASTNode)this.get(), methodSibling, null);
        }
    }

    protected static ASTNode getSiblingForGetter(String getterName, TypeDeclaration declaringType, EclipseEnvironment scoutElementProvider) {
        IType t = (IType)Ensure.notNull((Object)AstUtils.getTypeBinding((AbstractTypeDeclaration)declaringType));
        org.eclipse.scout.sdk.core.model.api.IType jdtTypeToScoutType = scoutElementProvider.toScoutType(t);
        IStructuredType structuredForm = StructuredType.of((org.eclipse.scout.sdk.core.model.api.IType)jdtTypeToScoutType);
        IJavaElement methodSibling = structuredForm.getSiblingMethodFieldGetter(getterName);
        if (methodSibling == null) {
            return null;
        }
        if (methodSibling instanceof IMethod) {
            String sigOfSiblingMethod = ((IMethod)methodSibling).identifier(true);
            return Arrays.stream(declaringType.getMethods()).filter(methodDeclaration -> sigOfSiblingMethod.equals(AstUtils.createMethodIdentifier((MethodDeclaration)methodDeclaration))).findFirst().orElse(null);
        }
        if (methodSibling instanceof IField) {
            String elemName = methodSibling.elementName();
            for (FieldDeclaration field : declaringType.getFields()) {
                List fragments = field.fragments();
                for (VariableDeclarationFragment fragment : fragments) {
                    if (!elemName.equals(fragment.getName().getIdentifier())) continue;
                    return field;
                }
            }
        } else if (methodSibling instanceof org.eclipse.scout.sdk.core.model.api.IType) {
            String elemName = methodSibling.elementName();
            return Arrays.stream(declaringType.getTypes()).filter(innerType -> elemName.equals(innerType.getName().getIdentifier())).findFirst().orElse(null);
        }
        return null;
    }
}

