/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.internal.support.MappingsSupport;
import org.eclipse.swtchart.extensions.internal.support.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;

public class SetColorAction
extends AbstractMenuListener {
    public SetColorAction(SeriesListUI seriesListUI) {
        super(seriesListUI);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Set Color";
            }

            public String getToolTipText() {
                return "Adjust the color of the selected series.";
            }

            public void run() {
                SeriesListUI seriesListUI = SetColorAction.this.getSeriesListUI();
                Table table = seriesListUI.getTable();
                List<ISeries<?>> selectedSeries = SetColorAction.this.getSelectedSeries();
                if (selectedSeries.size() > 0) {
                    Color colorActive = SeriesLabelProvider.getColor(selectedSeries.get(0));
                    RGB rgbActive = colorActive == null ? new RGB(255, 0, 0) : colorActive.getRGB();
                    ColorDialog colorDialog = new ColorDialog(table.getShell());
                    colorDialog.setText("Set Series Color");
                    colorDialog.setRGB(rgbActive);
                    RGB rgbNew = colorDialog.open();
                    if (rgbNew != null) {
                        for (ISeries<?> series : selectedSeries) {
                            MappingsSupport.mapSettings(series, "Color", rgbNew, SetColorAction.this.getScrollableChart());
                        }
                        SetColorAction.this.refresh();
                    }
                }
            }
        });
    }
}

