/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.tabs.refprojects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tcf.te.launch.core.interfaces.IReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectItemValidator;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectsPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.interfaces.ILaunchConfigurationTabFormPart;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.launch.ui.tabs.refprojects.RefProjectsCheckStateProvider;
import org.eclipse.tcf.te.launch.ui.tabs.refprojects.RefProjectsContentProvider;
import org.eclipse.tcf.te.ui.forms.parts.AbstractTableSection;
import org.eclipse.tcf.te.ui.swt.listener.AbstractDecorationCellPaintListener;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class RefProjectsSection
extends AbstractTableSection
implements ILaunchConfigurationTabFormPart {
    private ControlDecoration controlDecoration;
    protected static final String PROPERTY_VALIDATION_RESULT = "validation_result.transient";

    public RefProjectsSection(IManagedForm form, Composite parent) {
        String[] stringArray = new String[5];
        stringArray[0] = Messages.ReferencedProjectsSection_add_button;
        stringArray[1] = Messages.ReferencedProjectsSection_delete_button;
        stringArray[3] = Messages.ReferencedProjectsSection_up_button;
        stringArray[4] = Messages.ReferencedProjectsSection_down_button;
        super(form, parent, 0, stringArray);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        IReferencedProjectItem[] items = ReferencedProjectsPersistenceDelegate.getReferencedProjects((ILaunchConfiguration)configuration);
        this.getTablePart().getViewer().setInput((Object)items);
        if (items != null && items.length > 0) {
            ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)items[0]), true);
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        ReferencedProjectsPersistenceDelegate.setReferencedProjects((ILaunchConfigurationWorkingCopy)wc, (IReferencedProjectItem[])((IReferencedProjectItem[])this.getTablePart().getViewer().getInput()));
    }

    @Override
    public boolean isValid(ILaunchConfiguration configuration) {
        return this.validateInputList();
    }

    private boolean validateInputList() {
        List<IReferencedProjectItem> list = this.getInputList();
        boolean valid = true;
        for (IReferencedProjectItem item : list) {
            Map invalid = item.getBooleanProperty("enabled") ? ReferencedProjectItemValidator.validate((IReferencedProjectItem)item) : null;
            item.setProperty(PROPERTY_VALIDATION_RESULT, (Object)invalid);
            if (!valid || invalid == null) continue;
            valid = false;
            this.setMessage((String)invalid.get(invalid.keySet().toArray()[0]), 3);
        }
        return valid;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.ReferencedProjectsSection_title);
        section.setDescription(Messages.ReferencedProjectsSection_description);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(272, 0x1000000, true, true));
        }
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        client.setBackground(section.getBackground());
        section.setClient((Control)client);
        this.createPartControl((Composite)section.getClient(), 68356, 2, toolkit);
        this.setIsUpdating(false);
    }

    protected TableViewer createTableViewer(Composite parent, int style) {
        return new CheckboxTableViewer(new Table(parent, style | 0x20));
    }

    protected void configureTableViewer(TableViewer viewer) {
        super.configureTableViewer(viewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        final Table table = viewer.getTable();
        if (viewer instanceof CheckboxTableViewer) {
            ((CheckboxTableViewer)viewer).setCheckStateProvider((ICheckStateProvider)new RefProjectsCheckStateProvider());
            ((CheckboxTableViewer)viewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getElement() instanceof IReferencedProjectItem) {
                        IReferencedProjectItem item = (IReferencedProjectItem)event.getElement();
                        item.setProperty("enabled", event.getChecked());
                        RefProjectsSection.this.getManagedForm().dirtyStateChanged();
                    }
                }
            });
        }
        TableViewerColumn tvEnableCol = new TableViewerColumn(viewer, 0);
        final TableColumn colEnable = tvEnableCol.getColumn();
        colEnable.setResizable(false);
        tvEnableCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        TableViewerColumn tvProjectCol = new TableViewerColumn(viewer, 0);
        final TableColumn colProject = tvProjectCol.getColumn();
        colProject.setText(Messages.ReferencedProjectsSection_name_column);
        colProject.setResizable(true);
        tvProjectCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof IReferencedProjectItem) {
                    IReferencedProjectItem item = (IReferencedProjectItem)element;
                    Map invalid = (Map)item.getProperty(RefProjectsSection.PROPERTY_VALIDATION_RESULT);
                    if (invalid != null && invalid.containsKey("project_name")) {
                        return (String)invalid.get("project_name");
                    }
                    return item.getStringProperty("project_name");
                }
                return super.getText(element);
            }

            public String getText(Object element) {
                if (element instanceof IReferencedProjectItem) {
                    IReferencedProjectItem item = (IReferencedProjectItem)element;
                    return item.getStringProperty("project_name");
                }
                return super.getText(element);
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(200, true));
        table.setLayout((Layout)tableLayout);
        GridData data = new GridData(1810);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int width = table.getSize().x - 4 - colEnable.getWidth();
                colProject.setWidth(Math.max(width, 100));
            }
        });
        AbstractDecorationCellPaintListener cpl = new AbstractDecorationCellPaintListener((Widget)table, new int[]{1}){

            protected int getDecorationState(Object data, int columnIndex) {
                Map invalid;
                IReferencedProjectItem item;
                if (data instanceof IReferencedProjectItem && (item = (IReferencedProjectItem)data).getBooleanProperty("enabled") && (invalid = (Map)item.getProperty(RefProjectsSection.PROPERTY_VALIDATION_RESULT)) != null) {
                    switch (columnIndex) {
                        case 1: {
                            if (!invalid.containsKey("project_name")) break;
                            return 3;
                        }
                    }
                }
                return 0;
            }
        };
        viewer.setContentProvider((IContentProvider)new RefProjectsContentProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RefProjectsSection.this.initializeButtonsEnablement();
            }
        });
        this.doCreateControlDecoration((Control)table);
        this.configureControlDecoration(this.getControlDecoration());
    }

    public ControlDecoration doCreateControlDecoration(Control control) {
        Assert.isNotNull((Object)control);
        this.controlDecoration = new ControlDecoration(control, 16512);
        return this.controlDecoration;
    }

    public final ControlDecoration getControlDecoration() {
        return this.controlDecoration;
    }

    protected void configureControlDecoration(ControlDecoration decoration) {
        Assert.isNotNull((Object)decoration);
        decoration.setShowOnlyOnFocus(false);
    }

    public void updateControlDecoration(String message, int messageType) {
        if (this.getControlDecoration() != null) {
            this.getControlDecoration().setDescriptionText(message);
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            String decorationId = "DEC_INFORMATION";
            if (messageType == 3) {
                decorationId = "DEC_ERROR";
            } else if (messageType == 2) {
                decorationId = "DEC_WARNING";
            }
            FieldDecoration fieldDeco = registry.getFieldDecoration(decorationId);
            if (fieldDeco != null) {
                this.getControlDecoration().setImage(fieldDeco.getImage());
            }
            if (message == null || messageType == 0) {
                this.getControlDecoration().hide();
            } else {
                this.getControlDecoration().show();
            }
        }
    }

    private List<IReferencedProjectItem> getInputList() {
        return new ArrayList<IReferencedProjectItem>(Arrays.asList((IReferencedProjectItem[])this.getTablePart().getViewer().getInput()));
    }

    private void setInputList(List<IReferencedProjectItem> list) {
        this.getTablePart().getViewer().setInput((Object)list.toArray(new IReferencedProjectItem[list.size()]));
    }

    protected void onButtonSelected(Button button) {
        int selIndex = ((TableViewer)this.getTablePart().getViewer()).getTable().getSelectionIndex();
        List<IReferencedProjectItem> list = this.getInputList();
        switch ((Integer)button.getData()) {
            case 0: {
                this.onButtonAddClick();
                break;
            }
            case 1: {
                list.remove(selIndex);
                this.setInputList(list);
                if (list.isEmpty()) break;
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)list.get(selIndex < list.size() ? selIndex : list.size() - 1)), true);
                break;
            }
            case 3: {
                list.add(selIndex - 1, list.remove(selIndex));
                this.setInputList(list);
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)list.get(selIndex - 1)), true);
                break;
            }
            case 4: {
                list.add(selIndex + 1, list.remove(selIndex));
                this.setInputList(list);
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)list.get(selIndex + 1)), true);
            }
        }
        this.validateInputList();
        this.getManagedForm().dirtyStateChanged();
    }

    private boolean contains(List<IReferencedProjectItem> list, IProject project) {
        for (IReferencedProjectItem item : list) {
            if (!item.isProperty("project_name", (Object)project.getName())) continue;
            return true;
        }
        return false;
    }

    private void onButtonAddClick() {
        Object[] result;
        int selIndex = ((TableViewer)this.getTablePart().getViewer()).getTable().getSelectionIndex();
        List<IReferencedProjectItem> list = this.getInputList();
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> unreferencedProjects = new ArrayList<String>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && !this.contains(list, project)) {
                unreferencedProjects.add(project.getName());
            }
            ++n2;
        }
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        };
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        };
        ListSelectionDialog dialog = new ListSelectionDialog(this.getSection().getShell(), (Object)unreferencedProjects.toArray(), contentProvider, (ILabelProvider)labelProvider, Messages.ReferencedProjectsSection_addDialog_message);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            ReferencedProjectItem first = null;
            Object[] objectArray = result;
            int n3 = result.length;
            int n4 = 0;
            while (n4 < n3) {
                Object name = objectArray[n4];
                IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject((String)name);
                if (prj != null && prj.isOpen()) {
                    ReferencedProjectItem item = new ReferencedProjectItem();
                    item.setProperty("enabled", true);
                    item.setProperty("project_name", (Object)prj.getName());
                    list.add(selIndex != -1 ? selIndex++ : 0, (IReferencedProjectItem)item);
                    if (first == null) {
                        first = item;
                    }
                }
                ++n4;
            }
            this.setInputList(list);
            if (first != null) {
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection(first), true);
            }
        }
    }

    protected void initializeButtonsEnablement() {
        ISelection selection = ((TableViewer)this.getTablePart().getViewer()).getSelection();
        boolean singleSelection = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1;
        int selIndex = ((TableViewer)this.getTablePart().getViewer()).getTable().getSelectionIndex();
        int count = ((TableViewer)this.getTablePart().getViewer()).getTable().getItemCount();
        this.getTablePart().getButton(0).setEnabled(this.getTablePart().isEnabled());
        this.getTablePart().getButton(1).setEnabled(this.getTablePart().isEnabled() && singleSelection);
        this.getTablePart().getButton(3).setEnabled(this.getTablePart().isEnabled() && singleSelection && selIndex > 0);
        this.getTablePart().getButton(4).setEnabled(this.getTablePart().isEnabled() && singleSelection && selIndex < count - 1);
    }
}

