/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.sdk.browser;

import java.net.URI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.sdk.browser.EditableOAuthParameters;

public class OAuthClientDetailsDialog
extends TrayDialog {
    private EditableOAuthParameters parameters;
    private Text authorizationURIText;
    private Text clientIdText;
    private Text clientSecretText;
    private Text scopesText;
    private Text expectedCallbackURIText;

    public OAuthClientDetailsDialog(Shell parentShell, EditableOAuthParameters parameters) {
        super(parentShell);
        this.parameters = parameters;
    }

    public void create() {
        super.create();
        this.validate();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblAuthorizationURI = new Label(container, 0);
        lblAuthorizationURI.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAuthorizationURI.setText("Authorization URI:");
        this.authorizationURIText = new Text(container, 2048);
        this.authorizationURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.authorizationURIText.setText(this.parameters.getService().toString());
        Label lblClientId = new Label(container, 0);
        lblClientId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblClientId.setText("Client ID:");
        this.clientIdText = new Text(container, 2048);
        this.clientIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.parameters.getClientId() != null) {
            this.clientIdText.setText(this.parameters.getClientId());
        }
        this.clientIdText.setMessage("not shown: using compile-time value");
        Label lblClientSecret = new Label(container, 0);
        lblClientSecret.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblClientSecret.setText("Client Secret:");
        this.clientSecretText = new Text(container, 2048);
        this.clientSecretText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        if (this.parameters.getClientSecret() != null) {
            this.clientSecretText.setText(this.parameters.getClientSecret());
        }
        this.clientSecretText.setMessage("not shown: using compile-time value");
        Label lblScopes = new Label(container, 0);
        lblScopes.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblScopes.setToolTipText("Space or comma-separated");
        lblScopes.setText("Scopes:");
        this.scopesText = new Text(container, 2048);
        this.scopesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.scopesText.setText(StringUtil.join((String)", ", (String[])this.parameters.getScopes()));
        Label lblCallback = new Label(container, 0);
        lblCallback.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCallback.setText("Callback URI:");
        this.expectedCallbackURIText = new Text(container, 2048);
        this.expectedCallbackURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.expectedCallbackURIText.setText(this.parameters.getExpectedCallback().toString());
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OAuthClientDetailsDialog.this.validate();
            }
        };
        this.authorizationURIText.addModifyListener(modifyListener);
        this.clientIdText.addModifyListener(modifyListener);
        this.clientSecretText.addModifyListener(modifyListener);
        this.scopesText.addModifyListener(modifyListener);
        this.expectedCallbackURIText.addModifyListener(modifyListener);
        return container;
    }

    private void validate() {
        this.getButton(0).setEnabled(this.isValid());
    }

    private boolean isValid() {
        try {
            this.parameters.setService(URI.create(this.authorizationURIText.getText()));
            this.parameters.setExpectedCallback(URI.create(this.expectedCallbackURIText.getText()));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        String newClientId = this.clientIdText.getText().trim();
        String newClientSecret = this.clientSecretText.getText().trim();
        if (newClientId.matches("\\w+") ^ newClientSecret.matches("\\w+")) {
            return false;
        }
        this.parameters.setClientId(newClientId);
        this.parameters.setClientSecret(newClientSecret);
        String scopesString = this.scopesText.getText().trim();
        if (!scopesString.matches("(\\w+,?\\s*)+")) {
            return false;
        }
        this.parameters.setScopes(this.scopesText.getText().trim().split("[,\\s]\\s*"));
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }
}

