/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.builder;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.OutputConfiguration;

public class EclipseResourceSupport {
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileSystemAccessProvider;
    @Inject
    private EclipseOutputConfigurationProvider outputConfigurationProvider;

    public EclipseResourceFileSystemAccess2 createProjectFileSystemAccess(IProject targetProject) {
        EclipseResourceFileSystemAccess2 fsa = (EclipseResourceFileSystemAccess2)this.fileSystemAccessProvider.get();
        fsa.setProject(targetProject);
        fsa.setMonitor((IProgressMonitor)new NullProgressMonitor());
        HashMap<String, OutputConfiguration> outputs = new HashMap<String, OutputConfiguration>();
        for (OutputConfiguration conf : this.outputConfigurationProvider.getOutputConfigurations(targetProject)) {
            outputs.put(conf.getName(), conf);
        }
        fsa.setOutputConfigurations(outputs);
        fsa.setPostProcessor((EclipseResourceFileSystemAccess2.IFileCallback)new EclipseResourceFileCallback());
        return fsa;
    }

    private static final class EclipseResourceFileCallback
    implements EclipseResourceFileSystemAccess2.IFileCallback {
        private EclipseResourceFileCallback() {
        }

        public boolean beforeFileDeletion(IFile file) {
            return true;
        }

        public void afterFileUpdate(IFile file) {
            this.handleFileAccess(file);
        }

        public void afterFileCreation(IFile file) {
            this.handleFileAccess(file);
        }

        protected void handleFileAccess(IFile file) {
        }
    }
}

