/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgent;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgentListener;
import org.eclipse.viatra.transformation.debug.model.TransformationStackFrame;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;
import org.eclipse.viatra.transformation.debug.ui.activator.TransformationDebugUIActivator;
import org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser.ConflictSetContentProvider;
import org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser.ConflictSetLabelProvider;
import org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser.RuleBrowserContentProvider;
import org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser.RuleBrowserLabelProvider;
import org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser.TransformationViewConfiguration;

public class TransformationBrowserView
extends ViewPart
implements IDebuggerHostAgentListener {
    private static final String DEBUG_VIEW = "org.eclipse.debug.ui.DebugView";
    public static final String ID = "org.eclipse.viatra.transformation.debug.ui.AdaptableTransformationBrowser";
    private TransformationThread currentThread;
    private Multimap<Class<?>, Object> expandedElementsMap = ArrayListMultimap.create();
    private TreeViewer treeViewer;
    private Object selection;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        ISelectionService sService = this.getSite().getWorkbenchWindow().getSelectionService();
        composite.setLayout((Layout)new FillLayout(256));
        this.treeViewer = new TreeViewer(composite, 2048);
        this.treeViewer.setContentProvider((IContentProvider)new RuleBrowserContentProvider(this));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RuleBrowserLabelProvider(this));
        this.treeViewer.addSelectionChangedListener(event -> {
            if (event.getSelection() instanceof IStructuredSelection) {
                this.selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        ISelectionListener listener = (part, currentSelection) -> {
            if (!currentSelection.isEmpty() && currentSelection instanceof StructuredSelection) {
                Object firstElement = ((StructuredSelection)currentSelection).getFirstElement();
                try {
                    if (firstElement instanceof TransformationThread) {
                        this.currentThread = (TransformationThread)firstElement;
                        Object[] expandedElements1 = this.treeViewer.getExpandedElements();
                        if (!this.currentThread.isTerminated()) {
                            this.treeViewer.setInput((Object)this.currentThread);
                            this.treeViewer.setExpandedElements(expandedElements1);
                            this.currentThread.getHostAgent().registerDebuggerHostAgentListener((IDebuggerHostAgentListener)this);
                        } else {
                            this.treeViewer.setInput((Object)new Object[0]);
                            this.currentThread = null;
                        }
                    } else if (firstElement instanceof TransformationStackFrame) {
                        TransformationThread thread;
                        this.currentThread = thread = (TransformationThread)((TransformationStackFrame)firstElement).getThread();
                        Object[] expandedElements2 = this.treeViewer.getExpandedElements();
                        if (!this.currentThread.isTerminated()) {
                            this.treeViewer.setInput((Object)this.currentThread);
                            this.treeViewer.setExpandedElements(expandedElements2);
                            this.currentThread.getHostAgent().registerDebuggerHostAgentListener((IDebuggerHostAgentListener)this);
                        } else {
                            this.treeViewer.setInput((Object)new Object[0]);
                            this.currentThread = null;
                        }
                    }
                }
                catch (Exception e) {
                    TransformationDebugUIActivator.getDefault().logException(e.getMessage(), e);
                    ErrorDialog.openError((Shell)composite.getShell(), (String)"An error has occured", (String)e.getMessage(), (IStatus)new Status(4, "org.eclipse.viatra.transformation.tooling.debug.ui", e.getMessage()));
                }
            }
        };
        sService.addSelectionListener(DEBUG_VIEW, listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    public void dispose() {
        super.dispose();
        this.expandedElementsMap.clear();
        if (this.currentThread != null) {
            this.currentThread.getHostAgent().unRegisterDebuggerHostAgentListener((IDebuggerHostAgentListener)this);
        }
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setViewConfiguration(TransformationViewConfiguration config) {
        this.treeViewer.getControl().getDisplay().syncExec((Runnable)new ConfigurationApplication(config, this));
    }

    public void transformationStateChanged(TransformationState state) {
        if (this.currentThread.getTransformationState().equals(state)) {
            this.treeViewer.getControl().getDisplay().asyncExec(() -> {
                Object[] expandedElements = this.treeViewer.getExpandedElements();
                this.treeViewer.setInput((Object)this.currentThread);
                this.treeViewer.setExpandedElements(expandedElements);
            });
        }
    }

    public void terminated(IDebuggerHostAgent agent) {
        if (this.currentThread.getHostAgent().equals(agent)) {
            this.treeViewer.getControl().getDisplay().asyncExec(() -> {
                this.treeViewer.setInput((Object)new Object[0]);
                this.currentThread = null;
            });
        }
    }

    private final class ConfigurationApplication
    implements Runnable {
        private final TransformationViewConfiguration config;
        private final TransformationBrowserView view;

        private ConfigurationApplication(TransformationViewConfiguration config, TransformationBrowserView view) {
            this.config = config;
            this.view = view;
        }

        @Override
        public void run() {
            switch (this.config) {
                case RULE_BROWSER: {
                    this.saveExpandedElements();
                    TransformationBrowserView.this.treeViewer.setContentProvider((IContentProvider)new RuleBrowserContentProvider(this.view));
                    TransformationBrowserView.this.treeViewer.setLabelProvider((IBaseLabelProvider)new RuleBrowserLabelProvider(this.view));
                    TransformationBrowserView.this.treeViewer.refresh();
                    TransformationBrowserView.this.treeViewer.setExpandedElements(this.loadExpandedElements());
                    break;
                }
                case CONFLICTSET_BROWSER: {
                    this.saveExpandedElements();
                    TransformationBrowserView.this.treeViewer.setContentProvider((IContentProvider)new ConflictSetContentProvider(this.view));
                    TransformationBrowserView.this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConflictSetLabelProvider(this.view));
                    TransformationBrowserView.this.treeViewer.refresh();
                    TransformationBrowserView.this.treeViewer.setExpandedElements(this.loadExpandedElements());
                    break;
                }
            }
        }

        private void saveExpandedElements() {
            Object[] expandedElements = TransformationBrowserView.this.treeViewer.getExpandedElements();
            IContentProvider contentProvider = TransformationBrowserView.this.treeViewer.getContentProvider();
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                TransformationBrowserView.this.expandedElementsMap.put(contentProvider.getClass(), element);
                ++n2;
            }
        }

        private Object[] loadExpandedElements() {
            IContentProvider contentProvider = TransformationBrowserView.this.treeViewer.getContentProvider();
            Collection elements = TransformationBrowserView.this.expandedElementsMap.get(contentProvider.getClass());
            return elements.toArray(new Object[elements.size()]);
        }
    }
}

