/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.TopBoundsSupport;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.ComponentClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IThisMethodParameterEvaluator;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGenerator;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.model.variable.EmptyInvocationVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.ImageImageDescriptor;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.property.TabOrderProperty;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ScrollableInfo;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;
import org.eclipse.wb.internal.swt.support.CoordinateUtils;
import org.osgi.framework.Bundle;

public class CompositeInfo
extends ScrollableInfo
implements ICompositeInfo,
IThisMethodParameterEvaluator {
    private final CompositeInfo m_this = this;
    private final TabOrderProperty m_tabOrderProperty;
    private static final String KEY_LAYOUT_HAS = "layout.has";
    private static final String KEY_LAYOUT_ALREADY_PROCESSED = "default/parent layout already processed";
    public static final String KEY_DONT_INHERIT_LAYOUT = "default/disable parent layout inheritance";
    public static final String KEY_DONT_SET_IMPLICIT_LAYOUT = "KEY_DONT_SET_IMPLICIT_LAYOUT";
    private Insets m_clientAreaInsets2;

    public CompositeInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.addBroacastListeners();
        this.m_tabOrderProperty = new TabOrderProperty(this);
        this.dontAllowDouble_setLayout();
    }

    private void addBroacastListeners() throws Exception {
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                CompositeInfo.this.initialize_createAbsoluteLayout();
            }
        });
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (object == CompositeInfo.this.m_this) {
                    CompositeInfo.this.fillContextMenu(manager);
                }
            }
        });
        this.addBroadcastListener(new JavaEventListener(){

            public void clipboardCopy(JavaInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
                if (javaInfo == CompositeInfo.this.m_this) {
                    CompositeInfo.this.clipboardCopy_addCommands(commands);
                }
            }
        });
    }

    @Override
    public void createExposedChildren() throws Exception {
        super.createExposedChildren();
        this.initialize_createImplicitLayout();
    }

    private void dontAllowDouble_setLayout() {
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                CompositeInfo.this.removeBroadcastListener(this);
            }
        });
        this.addBroadcastListener(new ObjectInfoChildAddBefore(){

            public void invoke(ObjectInfo parent, ObjectInfo child, ObjectInfo[] nextChild) throws Exception {
                LayoutInfo existingLayout;
                List layouts;
                if (parent == CompositeInfo.this.m_this && child instanceof LayoutInfo && !(layouts = CompositeInfo.this.getChildren(LayoutInfo.class)).isEmpty() && !((existingLayout = (LayoutInfo)layouts.get(0)).getCreationSupport() instanceof ImplicitLayoutCreationSupport)) {
                    throw new DesignerException(2004, new String[]{CompositeInfo.this.m_this.toString(), existingLayout.toString(), child.toString()});
                }
            }
        });
    }

    protected void fillContextMenu(IMenuManager manager) throws Exception {
        this.contextMenu_setLayout(manager);
        this.contextMenu_setMinimalSize(manager);
    }

    private void contextMenu_setLayout(IMenuManager manager) throws Exception {
        if (!this.hasLayout()) {
            return;
        }
        MenuManager layoutsManager = new MenuManager(ModelMessages.CompositeInfo_setLayoutManager);
        manager.appendToGroup("org.eclipse.wb.popup.group.layout", (IContributionItem)layoutsManager);
        this.fillLayoutsManager((IMenuManager)layoutsManager);
    }

    public void fillLayoutsManager(IMenuManager layoutsManager) throws Exception {
        ObjectInfoAction action = new ObjectInfoAction((ObjectInfo)this){

            protected void runEx() throws Exception {
                AbsoluteLayoutInfo layout = AbsoluteLayoutInfo.createExplicit(CompositeInfo.this.m_this);
                CompositeInfo.this.setLayout(layout);
            }
        };
        action.setText(ModelMessages.CompositeInfo_setLayoutAbsolute);
        action.setImageDescriptor(Activator.getImageDescriptor("info/layout/absolute/layout.gif"));
        layoutsManager.add((IAction)action);
        final AstEditor editor = this.getEditor();
        ClassLoader editorLoader = EditorState.get((AstEditor)editor).getEditorLoader();
        List descriptions = LayoutDescriptionHelper.get((ToolkitDescription)this.getDescription().getToolkit());
        for (final LayoutDescription description : descriptions) {
            final Class<?> layoutClass = editorLoader.loadClass(description.getLayoutClassName());
            final String creationId = description.getCreationId();
            ComponentDescription layoutComponentDescription = ComponentDescriptionHelper.getDescription((AstEditor)editor, layoutClass);
            ObjectInfoAction action2 = new ObjectInfoAction((ObjectInfo)this){

                protected void runEx() throws Exception {
                    description.ensureLibraries(editor.getJavaProject());
                    LayoutInfo layout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)CompositeInfo.this.getEditor(), (Class)layoutClass, (CreationSupport)new ConstructorCreationSupport(creationId, true));
                    CompositeInfo.this.setLayout(layout);
                }
            };
            action2.setText(description.getName());
            action2.setImageDescriptor((ImageDescriptor)new ImageImageDescriptor(layoutComponentDescription.getIcon()));
            layoutsManager.add((IAction)action2);
        }
    }

    private void contextMenu_setMinimalSize(IMenuManager manager) throws Exception {
        if (this.isRoot() || JavaInfoUtils.hasTrueParameter((JavaInfo)this, (String)"SWT.isRoot")) {
            ObjectInfoAction action = new ObjectInfoAction((ObjectInfo)this){

                protected void runEx() throws Exception {
                    Dimension preferredSize = CompositeInfo.this.getPreferredSize();
                    CompositeInfo.this.getTopBoundsSupport().setSize(preferredSize.width, preferredSize.height);
                }
            };
            action.setText(ModelMessages.CompositeInfo_setMinimalSize);
            manager.appendToGroup("org.eclipse.wb.popup.group.layout", (IAction)action);
        }
    }

    public Object evaluateParameter(EvaluationContext context, MethodDeclaration methodDeclaration, String methodSignature, SingleVariableDeclaration parameter, int index) throws Exception {
        if (ObjectUtils.equals((Object)parameter.getName().getIdentifier(), (Object)"style")) {
            return 0;
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    @Override
    public void refresh_dispose() throws Exception {
        this.processInitialLayout();
        super.refresh_dispose();
    }

    @Override
    protected void refresh_fetch() throws Exception {
        this.m_clientAreaInsets2 = CoordinateUtils.getClientAreaInsets2(this.getObject());
        super.refresh_fetch();
    }

    @Override
    protected List<Property> getPropertyList() throws Exception {
        List<Property> properties = super.getPropertyList();
        if (this.hasLayout()) {
            properties.add((Property)this.m_tabOrderProperty);
        }
        return properties;
    }

    protected TopBoundsSupport createTopBoundsSupport() {
        return (TopBoundsSupport)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<TopBoundsSupport>(){

            public TopBoundsSupport runObject() throws Exception {
                Bundle bundle = CompositeInfo.this.getDescription().getToolkit().getBundle();
                String implClassName = String.valueOf(bundle.getSymbolicName()) + ".model.widgets.CompositeTopBoundsSupport";
                implClassName = StringUtils.replace((String)implClassName, (String)".wb.", (String)".wb.internal.");
                Class implClass = bundle.loadClass(implClassName);
                Constructor constructor = implClass.getConstructor(CompositeInfo.class);
                return (TopBoundsSupport)constructor.newInstance(CompositeInfo.this.m_this);
            }
        });
    }

    public final void markNoLayout() throws Exception {
        this.putArbitraryValue(KEY_LAYOUT_HAS, Boolean.FALSE);
        for (LayoutInfo layout : this.getChildren(LayoutInfo.class)) {
            Assert.instanceOf(ImplicitLayoutCreationSupport.class, (Object)layout.getCreationSupport());
            this.removeChild((ObjectInfo)layout);
        }
    }

    public final boolean hasLayout() {
        if (this.isPlaceholder()) {
            return false;
        }
        Boolean hasLayout = (Boolean)this.getArbitraryValue(KEY_LAYOUT_HAS);
        if (hasLayout != null) {
            return hasLayout;
        }
        return JavaInfoUtils.hasTrueParameter((JavaInfo)this, (String)KEY_LAYOUT_HAS);
    }

    private void initialize_createImplicitLayout() throws Exception {
        if (this.hasLayout()) {
            LayoutInfo implicitLayout;
            if (this.initialize_hasExplicitLayout()) {
                return;
            }
            AstEditor editor = this.getEditor();
            Object layout = ContainerSupport.getLayout(this.getObject());
            if (this.initialize_removeImplicitLayout(layout)) {
                return;
            }
            ImplicitLayoutCreationSupport creationSupport = new ImplicitLayoutCreationSupport(this);
            if (layout == null) {
                ToolkitDescriptionJava toolkit = this.getDescription().getToolkit();
                implicitLayout = new AbsoluteLayoutInfo(editor, (ToolkitDescription)toolkit, (CreationSupport)creationSupport);
            } else {
                Class<?> layoutClass = layout.getClass();
                implicitLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)editor, layoutClass, (CreationSupport)creationSupport);
            }
            ImplicitLayoutVariableSupport variableSupport = new ImplicitLayoutVariableSupport(implicitLayout);
            implicitLayout.setVariableSupport((VariableSupport)variableSupport);
            implicitLayout.setAssociation((Association)new ImplicitObjectAssociation((JavaInfo)this));
            this.addChildFirst((ObjectInfo)implicitLayout);
        }
    }

    private boolean initialize_hasExplicitLayout() {
        List layouts = this.getChildren(LayoutInfo.class);
        return !layouts.isEmpty() && !(((LayoutInfo)layouts.get(0)).getCreationSupport() instanceof ImplicitLayoutCreationSupport);
    }

    private boolean initialize_removeImplicitLayout(Object layoutObject) throws Exception {
        for (JavaInfo child : this.getChildrenJava()) {
            if (!(child.getCreationSupport() instanceof ImplicitLayoutCreationSupport)) continue;
            if (child.getObject() != layoutObject) {
                return true;
            }
            ImplicitLayoutCreationSupport creationSupport = (ImplicitLayoutCreationSupport)child.getCreationSupport();
            creationSupport.removeForever();
            break;
        }
        return false;
    }

    private void initialize_createAbsoluteLayout() throws Exception {
        MethodInvocation setLayoutInvocation;
        if (this.hasLayout() && (setLayoutInvocation = this.getMethodInvocation("setLayout(org.eclipse.swt.widgets.Layout)")) != null && setLayoutInvocation.arguments().get(0) instanceof NullLiteral) {
            AstEditor editor = this.getEditor();
            ToolkitDescriptionJava toolkit = this.getDescription().getToolkit();
            NullLiteral nullLiteral = (NullLiteral)setLayoutInvocation.arguments().get(0);
            AbsoluteLayoutCreationSupport creationSupport = new AbsoluteLayoutCreationSupport((Expression)nullLiteral);
            AbsoluteLayoutInfo absoluteLayout = new AbsoluteLayoutInfo(editor, (ToolkitDescription)toolkit, (CreationSupport)creationSupport);
            absoluteLayout.setAssociation((Association)new InvocationChildAssociation(setLayoutInvocation));
            absoluteLayout.setObject(null);
            this.addChild((ObjectInfo)absoluteLayout);
        }
    }

    public final LayoutInfo getLayout() {
        Assert.isTrueException((boolean)this.hasLayout(), (int)2001, (Object[])new Object[]{this});
        for (ObjectInfo child : this.getChildren()) {
            if (!(child instanceof LayoutInfo)) continue;
            return (LayoutInfo)child;
        }
        throw new IllegalStateException(ModelMessages.CompositeInfo_shouldAlwaysHaveLayout);
    }

    public final void setLayout(LayoutInfo newLayout) throws Exception {
        this.putArbitraryValue(KEY_DONT_SET_IMPLICIT_LAYOUT, Boolean.TRUE);
        this.startEdit();
        try {
            LayoutInfo oldLayout = this.getLayout();
            oldLayout.delete();
            Object statementGenerator = JavaInfoUtils.hasTrueParameter((JavaInfo)newLayout, (String)"layout.setInBlock") ? BlockStatementGenerator.INSTANCE : PureFlatStatementGenerator.INSTANCE;
            EmptyInvocationVariableSupport variableSupport = new EmptyInvocationVariableSupport((JavaInfo)newLayout, "%parent%.setLayout(%child%)", 0);
            JavaInfoUtils.add((JavaInfo)newLayout, (VariableSupport)variableSupport, (StatementGenerator)statementGenerator, (AssociationObject)AssociationObjects.invocationChildNull(), (JavaInfo)this, null);
            newLayout.onSet();
        }
        finally {
            this.endEdit();
            this.putArbitraryValue(KEY_DONT_SET_IMPLICIT_LAYOUT, Boolean.FALSE);
        }
    }

    private void processInitialLayout() throws Exception {
        boolean shouldBeProcessed;
        IPreferenceStore preferences = this.getDescription().getToolkit().getPreferences();
        boolean bl = shouldBeProcessed = this.hasLayout() && this.getArbitraryValue("manuallyCreatedComponent") == Boolean.TRUE && this.getArbitraryValue(KEY_LAYOUT_ALREADY_PROCESSED) == null && this.getArbitraryValue(KEY_DONT_INHERIT_LAYOUT) == null;
        if (!shouldBeProcessed) {
            return;
        }
        this.putArbitraryValue(KEY_LAYOUT_ALREADY_PROCESSED, Boolean.TRUE);
        if (preferences.getBoolean("layout.inheritLayoutOfParent") && this.getParent() instanceof CompositeInfo) {
            CompositeInfo parentComposite = (CompositeInfo)this.getParent();
            if (!parentComposite.hasLayout()) {
                return;
            }
            LayoutInfo parentLayout = parentComposite.getLayout();
            if (parentLayout.getCreationSupport() instanceof IImplicitCreationSupport) {
                return;
            }
            Class layoutClass = parentLayout.getDescription().getComponentClass();
            final LayoutInfo thisLayout = layoutClass == null ? AbsoluteLayoutInfo.createExplicit(this) : (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.getEditor(), (Class)layoutClass, (CreationSupport)new ConstructorCreationSupport());
            ExecutionUtils.runLater((ObjectInfo)this, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    CompositeInfo.this.setLayout(thisLayout);
                }
            });
            return;
        }
        String layoutId = preferences.getString("layout.default");
        LayoutDescription layoutDescription = LayoutDescriptionHelper.get((ToolkitDescription)this.getDescription().getToolkit(), (String)layoutId);
        if (layoutDescription != null) {
            String layoutClassName = layoutDescription.getLayoutClassName();
            ClassLoader editorLoader = EditorState.get((AstEditor)this.getEditor()).getEditorLoader();
            Class<?> layoutClass = editorLoader.loadClass(layoutClassName);
            final LayoutInfo thisLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.getEditor(), layoutClass, (CreationSupport)new ConstructorCreationSupport());
            ExecutionUtils.runLater((ObjectInfo)this, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    CompositeInfo.this.setLayout(thisLayout);
                }
            });
        }
    }

    public boolean shouldDrawDotsBorder() throws Exception {
        if (ControlSupport.isStyle(this.getObject(), 2048)) {
            return false;
        }
        String script = JavaInfoUtils.getParameter((JavaInfo)this, (String)"shouldDrawBorder");
        if (StringUtils.isEmpty((String)script)) {
            return false;
        }
        return (Boolean)JavaInfoUtils.executeScript((JavaInfo)this, (String)script);
    }

    public boolean canBeRoot() {
        return true;
    }

    public final List<ControlInfo> getChildrenControls() {
        return this.getChildren(ControlInfo.class);
    }

    @Override
    public final Insets getClientAreaInsets2() {
        return this.m_clientAreaInsets2;
    }

    public final boolean isRTL() {
        return ContainerSupport.isRTL(this.getObject());
    }

    protected void clipboardCopy_addCommands(List<ClipboardCommand> commands) throws Exception {
        LayoutInfo layout;
        if (this.hasLayout() && !((layout = this.getLayout()).getCreationSupport() instanceof IImplicitCreationSupport)) {
            if (layout instanceof AbsoluteLayoutInfo) {
                commands.add((ClipboardCommand)new ComponentClipboardCommand<CompositeInfo>(){
                    private static final long serialVersionUID = 0L;

                    public void execute(CompositeInfo composite) throws Exception {
                        composite.addMethodInvocation("setLayout(org.eclipse.swt.widgets.Layout)", "null");
                    }
                });
            } else {
                final JavaInfoMemento layoutMemento = JavaInfoMemento.createMemento((JavaInfo)layout);
                commands.add((ClipboardCommand)new ComponentClipboardCommand<CompositeInfo>(){
                    private static final long serialVersionUID = 0L;

                    public void execute(CompositeInfo composite) throws Exception {
                        LayoutInfo newLayout = (LayoutInfo)layoutMemento.create((JavaInfo)composite);
                        composite.setLayout(newLayout);
                        layoutMemento.apply();
                    }
                });
            }
        }
    }
}

