"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const yamlParser07_1 = require("../parser/yamlParser07");
const jsonLinks_1 = require("vscode-json-languageservice/lib/umd/services/jsonLinks");
function findLinks(document) {
    const doc = yamlParser07_1.parse(document.getText());
    // Find links across all YAML Documents then report them back once finished
    const linkPromises = [];
    for (const yamlDoc of doc.documents) {
        linkPromises.push(jsonLinks_1.findLinks(document, yamlDoc));
    }
    // Wait for all the promises to return and then flatten them into one DocumentLink array
    return Promise.all(linkPromises).then((yamlLinkArray) => [].concat(...yamlLinkArray));
}
exports.findLinks = findLinks;
//# sourceMappingURL=yamlLinks.js.map