/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.ColumnIdentifier;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public class SortSpecification {
    public static final int ORDERING_ASC = 0;
    public static final int ORDERING_DESC = 1;
    public static final int NULL_ORDERING_NONE = 0;
    public static final int NULL_ORDERING_FIRST = 1;
    public static final int NULL_ORDERING_LAST = 2;
    private static final int SORT_MODE_UNDEFINED = -1;
    private int m_sortMode;
    private List<SortKey> m_sortKeys;
    private static final String LOG_NEWLINE_CHAR = "\n ";
    private static final String sm_className = SortSpecification.class.getName();

    protected SortSpecification() {
        this(-1);
    }

    protected SortSpecification(int sortMode) {
        if (sortMode != 0 && sortMode != 1 && sortMode != 2 && sortMode != 3 && sortMode != -1) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sortSpec_INVALID_SORT_MODE_SPECIFIED, (Object)sortMode));
        }
        this.m_sortMode = sortMode;
        this.m_sortKeys = new ArrayList<SortKey>();
    }

    public void addSortKey(ColumnIdentifier column, int sortDirection) {
        this.addSortKey(column, sortDirection, 0);
    }

    public void addSortKey(ColumnIdentifier column, int sortDirection, int nullOrdering) {
        SortKey sortKey;
        if (column == null) {
            throw new NullPointerException(Messages.sortSpec_NULL_COLUMN_NAME_SPECIFIED);
        }
        if (!column.isValid()) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sortSpec_INVALID_COLUMN_NAME_SPECIFIED, (Object)column));
        }
        if (sortDirection != 0 && sortDirection != 1) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sortSpec_INVALID_SORT_ORDER_SPECIFIED, (Object)sortDirection));
        }
        if (nullOrdering < 0 || nullOrdering > 2) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.sortSpec_INVALID_NULL_ORDERING, (Object)nullOrdering));
        }
        if (this.m_sortMode == 0) {
            throw new IllegalStateException(Messages.sortSpec_NO_DYNAMIC_SORT_KEY_FOR_SORTMODENONE);
        }
        if (this.m_sortMode == 3 && this.getSortKeyCountImpl() > 0) {
            throw new IllegalStateException(Messages.sortSpec_ONE_SORTCOLUMN_FOR_SINGLE_COLUMN_MODE);
        }
        if (this.m_sortMode == 1 && this.getSortKeyCountImpl() > 0 && (sortKey = this.m_sortKeys.get(0)).getSortDirection() != sortDirection) {
            throw new IllegalStateException(Messages.sortSpec_ONE_SORTORDER_FOR_SINGLE_ORDER_MODE);
        }
        sortKey = new SortKey(column, sortDirection, nullOrdering);
        this.m_sortKeys.add(sortKey);
    }

    public int getSortMode() {
        if (this.m_sortMode != -1) {
            return this.m_sortMode;
        }
        int numSortKeys = this.getSortKeyCount();
        if (numSortKeys == 0) {
            return 0;
        }
        if (numSortKeys == 1) {
            return 3;
        }
        int firstKeySortDirection = this.getSortDirection(1);
        int i = 2;
        while (i <= numSortKeys) {
            if (firstKeySortDirection != this.getSortDirection(i)) {
                return 2;
            }
            ++i;
        }
        return 1;
    }

    public int getSortKeyCount() {
        return this.getSortKeyCountImpl();
    }

    protected int getSortKeyCountImpl() {
        return this.m_sortKeys.size();
    }

    public ColumnIdentifier getSortColumn(int pos) {
        ColumnIdentifier column = this.getSortKey(pos).getColumn();
        return column != null && column.isValid() ? column : null;
    }

    public int getSortDirection(int pos) {
        return this.getSortKey(pos).getSortDirection();
    }

    public int getNullOrdering(int pos) {
        return this.getSortKey(pos).getNullOrdering();
    }

    protected SortKey getSortKey(int pos) throws IndexOutOfBoundsException {
        this.validatePosition(pos);
        return this.m_sortKeys.get(pos - 1);
    }

    protected void validatePosition(int pos) {
        int count = this.getSortKeyCountImpl();
        if (pos < 1 || pos > count) {
            throw new IndexOutOfBoundsException(Messages.bind((String)Messages.sortSpec_INDEX_OUT_OF_BOUND, (Object)pos, (Object)count));
        }
    }

    public ColumnIdentifier[] getSortColumns() {
        int size = this.getSortKeyCountImpl();
        ColumnIdentifier[] sortColumns = new ColumnIdentifier[size];
        int i = 0;
        while (i < size) {
            ColumnIdentifier column;
            SortKey sortKey = this.m_sortKeys.get(i);
            sortColumns[i] = column = sortKey.getColumn();
            ++i;
        }
        return sortColumns;
    }

    public int getSortDirection() {
        if (this.getSortMode() != 1) {
            throw new IllegalStateException(Messages.sortSpec_ONLY_IN_SINGLE_ORDER_MODE);
        }
        if (this.getSortKeyCountImpl() == 0) {
            return 0;
        }
        SortKey sortKey = this.m_sortKeys.get(0);
        return sortKey.getSortDirection();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(SortSpecification.class.getSimpleName()) + " [");
        buffer.append("Sort Mode: " + SortSpecification.getSortModeLiteral(this.getSortMode()));
        buffer.append("\nSort Keys: ");
        if (this.m_sortKeys != null) {
            for (SortKey sortKey : this.m_sortKeys) {
                buffer.append(LOG_NEWLINE_CHAR + sortKey);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    private static String getSortDirectionLiteral(int sortOrder) {
        switch (sortOrder) {
            case 0: {
                return "Ascending";
            }
            case 1: {
                return "Descending";
            }
        }
        return "";
    }

    private static String getNullOrderingLiteral(int nullOrdering) {
        switch (nullOrdering) {
            case 1: {
                return "Nulls_First";
            }
            case 2: {
                return "Nulls_Last";
            }
        }
        return "No_Null_Ordering";
    }

    private static String getSortModeLiteral(int sortMode) {
        switch (sortMode) {
            case 0: {
                return "sortModeNone";
            }
            case 1: {
                return "sortModeSingleOrder";
            }
            case 2: {
                return "sortModeColumnOrder";
            }
            case 3: {
                return "sortModeSingleColumn";
            }
            case -1: {
                return "sortModeUndefined";
            }
        }
        return "";
    }

    public void validate(ValidationContext context) throws OdaException {
        try {
            if (context != null && context.getValidator() != null) {
                context.getValidator().validate(this, context);
            }
        }
        catch (OdaException ex) {
            QuerySpecificationHelper.logValidationException(sm_className, ex);
            throw ex;
        }
    }

    private static final class SortKey {
        private ColumnIdentifier m_column;
        private int m_sortDirection;
        private int m_nullOrdering;

        private SortKey(ColumnIdentifier column, int sortDirection, int nullOrdering) {
            this.m_column = column;
            this.m_sortDirection = sortDirection;
            this.m_nullOrdering = nullOrdering;
        }

        private ColumnIdentifier getColumn() {
            return this.m_column;
        }

        private int getSortDirection() {
            return this.m_sortDirection;
        }

        private int getNullOrdering() {
            return this.m_nullOrdering;
        }

        public String toString() {
            return "{" + this.m_column + ", " + SortSpecification.getSortDirectionLiteral(this.m_sortDirection) + ", " + SortSpecification.getNullOrderingLiteral(this.m_nullOrdering) + "}";
        }
    }
}

