/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SOAPRequestPage
extends DataSetWizardPage {
    private SOAPParameter[] parameters;
    private static String DEFAULT_MESSAGE = Messages.getString("soapRequestPage.message.defaultTitle");
    private boolean saved = false;
    protected final String COLUMN_NAME = Messages.getString("parameterInputDialog.column.name");
    protected final String COLUMN_DATATYPE = Messages.getString("parameterInputDialog.column.type");
    protected final String COLUMN_DEFAULTVALUE = Messages.getString("parameterInputDialog.column.defaultValue");
    private Button paramBtn;
    private SOAPRequest soapRequest;
    private SourceViewer templateSourceViewer;
    private StyledText templateText;

    public SOAPRequestPage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        WSUIUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_WS_SOAP_REQUEST_ID");
    }

    private Control createPageControl(Composite parent) {
        ScrolledComposite sComposite = new ScrolledComposite(parent, 768);
        sComposite.setLayout((Layout)new GridLayout());
        sComposite.setLayoutData((Object)new GridData(1808));
        sComposite.setMinWidth(600);
        sComposite.setExpandHorizontal(true);
        Composite composite = new Composite((Composite)sComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        Label prompt = new Label(composite, 0);
        prompt.setText(Messages.getString("soapRequestPage.label.prompt"));
        GridData labelGd = new GridData();
        labelGd.horizontalSpan = 2;
        prompt.setLayoutData((Object)labelGd);
        this.setupTemplateTextArea(composite);
        this.setupButtonComposite(composite);
        Point size = composite.computeSize(-1, -1);
        composite.setSize(size.x, size.y);
        sComposite.setContent((Control)composite);
        this.setControl((Control)sComposite);
        return sComposite;
    }

    private void setupTemplateTextArea(Composite parent) {
        this.templateSourceViewer = new SourceViewer(parent, null, 0x2000B02);
        this.templateSourceViewer.configure(new SourceViewerConfiguration());
        this.templateText = this.templateSourceViewer.getTextWidget();
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 400;
        this.templateText.setLayoutData((Object)layoutData);
        this.templateText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.templateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SOAPRequestPage.this.validatePageStatus();
            }
        });
        this.templateSourceViewer.setDocument((IDocument)new Document());
        TextViewerUndoManager undoManager = new TextViewerUndoManager(10);
        undoManager.connect((ITextViewer)this.templateSourceViewer);
        this.templateSourceViewer.setUndoManager((IUndoManager)undoManager);
        this.templateText.addKeyListener((KeyListener)new KeyAdapter(){

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    SOAPRequestPage.this.templateSourceViewer.doOperation(1);
                    SOAPRequestPage.this.validatePageStatus();
                } else if (this.isRedoKeyPress(e)) {
                    SOAPRequestPage.this.templateSourceViewer.doOperation(2);
                    SOAPRequestPage.this.validatePageStatus();
                }
            }
        });
    }

    private void setupButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        Button templateBtn = new Button(composite, 0);
        templateBtn.setText(Messages.getString("soapRequestPage.button.regenerateTemplate"));
        layoutData = new GridData();
        templateBtn.setLayoutData((Object)layoutData);
        templateBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm(null, (String)Messages.getString("soapRequestPage.title.regenerateTemplate"), (String)Messages.getString("soapRequestPage.message.regenerateTemplate"))) {
                    try {
                        SOAPRequestPage.this.regenerateTemplate();
                    }
                    catch (OdaException e1) {
                        SOAPRequestPage.this.setErrorMessage(e1.getMessage());
                    }
                }
            }
        });
        int width = this.getMaxWidth(templateBtn, 60);
        this.paramBtn = new Button(composite, 0);
        this.paramBtn.setText(Messages.getString("soapRequestPage.button.insertParameter"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        this.paramBtn.setLayoutData((Object)layoutData);
        this.paramBtn.setEnabled(this.parameters != null && this.parameters.length > 0);
        this.paramBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterInputDialog dlg = new ParameterInputDialog();
                if (dlg.open() == 0) {
                    SOAPRequestPage.this.parameters = SOAPRequestPage.this.updateSOAPParameters();
                }
            }
        });
        width = this.getMaxWidth(this.paramBtn, width);
        Button clearBtn = new Button(composite, 0);
        clearBtn.setText(Messages.getString("soapRequestPage.button.clear"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        clearBtn.setLayoutData((Object)layoutData);
        clearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPRequestPage.this.templateText.setText("");
                SOAPRequestPage.this.validatePageStatus();
                SOAPRequestPage.this.templateText.setFocus();
            }
        });
        width = this.getMaxWidth(clearBtn, width);
        GridData gd = new GridData();
        gd.widthHint = width;
        templateBtn.setLayoutData((Object)gd);
        this.paramBtn.setLayoutData((Object)gd);
        clearBtn.setLayoutData((Object)gd);
    }

    private int getMaxWidth(Button button, int width) {
        int length = button.computeSize((int)-1, (int)-1).x;
        return length > width ? length : width;
    }

    private void regenerateTemplate() throws OdaException {
        this.templateText.setText(WSConsole.getInstance().getTemplate());
        this.parameters = WSConsole.getInstance().getParameters();
        this.saved = false;
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
        this.initParameters();
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        String wsQueryText = WSConsole.getInstance().getPropertyValue("wsQueryText");
        if (wsQueryText != null) {
            this.templateText.setText(wsQueryText);
        }
        this.parameters = WSConsole.getInstance().getParameters();
        this.initParameters();
        this.saved = false;
    }

    private void initParameters() {
        this.soapRequest = new SOAPRequest(this.templateText.getText());
        this.mergeParameters();
        SOAPParameter[] params = this.soapRequest.getParameters();
        this.paramBtn.setEnabled(params != null && params.length > 0);
    }

    private void mergeParameters() {
        SOAPParameter[] soapParameters = this.soapRequest.getParameters();
        int i = 0;
        while (this.parameters != null && i < this.parameters.length) {
            if (!WSUtil.isNull((Object)this.parameters[i])) {
                int pos = -1;
                int j = 0;
                while (soapParameters != null && j < soapParameters.length) {
                    if (!WSUtil.isNull((Object)soapParameters[j].getName()) && soapParameters[j].getName().equals(this.parameters[i].getName())) {
                        pos = j;
                        break;
                    }
                    ++j;
                }
                if (pos != -1) {
                    soapParameters[pos].setDefaultValue(this.parameters[i].getDefaultValue());
                }
            }
            ++i;
        }
    }

    SOAPParameter[] updateSOAPParameters() {
        return this.soapRequest.getParameters();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        WSUIUtil.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) {
        if (!WSConsole.getInstance().isSessionOK()) {
            return;
        }
        if (this.isControlCreated() && !this.saved) {
            this.saveToModel();
        }
        dataSetDesign.setQueryText(WSConsole.getInstance().getPropertyValue("wsQueryText"));
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        this.initFromModel();
    }

    void refresh() throws OdaException {
        String value = WSConsole.getInstance().manipulateTemplate();
        if (value != null) {
            this.templateText.setText(value);
        }
        this.parameters = WSConsole.getInstance().getParameters();
        this.initParameters();
        this.saved = false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        this.saveToModel();
        return super.getNextPage();
    }

    protected boolean canLeave() {
        this.saveToModel();
        return super.canLeave();
    }

    private void saveToModel() {
        if (this.templateText == null) {
            return;
        }
        String templateContent = this.templateText.getText() == null ? "" : this.templateText.getText();
        WSConsole.getInstance().setPropertyValue("wsQueryText", templateContent);
        WSConsole.getInstance().updateParameters(this.parameters);
        this.saved = true;
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }

    private void validatePageStatus() {
        boolean valid = true;
        if (this.templateText.getText().trim().length() == 0) {
            valid = false;
        }
        this.setPageComplete(valid);
    }

    class ParameterEditDialog
    extends TrayDialog {
        private static final String COLON = ":";
        private static final String EMPTY_STRING = "";
        private String DEFAULT_TITLE;
        private String defaultValue;
        private Text defualtValueText;
        private SOAPParameter soapParameter;

        protected ParameterEditDialog(SOAPParameter soapParameter) {
            super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            this.DEFAULT_TITLE = Messages.getString("soapRequestPage.paramEditDialog.title");
            this.soapParameter = soapParameter;
            this.defaultValue = soapParameter.getDefaultValue() == null || soapParameter.getDefaultValue().trim().length() == 0 ? EMPTY_STRING : soapParameter.getDefaultValue();
        }

        public void create() {
            super.create();
            Point pt = this.getShell().computeSize(-1, -1);
            pt.x = Math.max(pt.x, 300);
            pt.y = Math.max(pt.y, 200);
            this.getShell().setSize(pt);
            this.getShell().setText(this.getTitle());
        }

        protected String getTitle() {
            return this.DEFAULT_TITLE;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginTop = 15;
            layout.marginRight = 10;
            layout.marginLeft = 10;
            layout.marginBottom = 20;
            layout.numColumns = 2;
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            this.createCustomControls(composite);
            WSUIUtil.setSystemHelp((Control)composite, "org.eclipse.datatools.oda.cshelp.Dialog_SOAP_Request_Parameter_Properties_ID");
            return composite;
        }

        protected void createCustomControls(Composite parent) {
            Label columnName = new Label(parent, 0);
            columnName.setText(String.valueOf(SOAPRequestPage.this.COLUMN_NAME) + COLON);
            GridData textGd = new GridData(768);
            textGd.widthHint = 180;
            Text columnNameText = new Text(parent, 2048);
            columnNameText.setText(this.soapParameter.getName());
            columnNameText.setLayoutData((Object)textGd);
            columnNameText.setEnabled(false);
            Label columnType = new Label(parent, 0);
            columnType.setText(String.valueOf(SOAPRequestPage.this.COLUMN_DATATYPE) + COLON);
            Text columnTypeText = new Text(parent, 2048);
            columnTypeText.setText(EMPTY_STRING);
            columnTypeText.setLayoutData((Object)textGd);
            columnTypeText.setEnabled(false);
            Label defualtValue = new Label(parent, 0);
            defualtValue.setText(String.valueOf(SOAPRequestPage.this.COLUMN_DEFAULTVALUE) + COLON);
            this.defualtValueText = new Text(parent, 2048);
            if (this.defaultValue != null) {
                this.defualtValueText.setText(this.defaultValue);
            }
            this.defualtValueText.setLayoutData((Object)textGd);
            this.defualtValueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.defaultValue = ParameterEditDialog.this.defualtValueText.getText();
                }
            });
            int maxWidth = this.getMaxWidth((Control)columnName, 100);
            maxWidth = this.getMaxWidth((Control)columnType, maxWidth);
            maxWidth = this.getMaxWidth((Control)defualtValue, maxWidth);
            GridData labelGd = new GridData();
            labelGd.widthHint = maxWidth;
            columnName.setLayoutData((Object)labelGd);
            columnType.setLayoutData((Object)labelGd);
            defualtValue.setLayoutData((Object)labelGd);
        }

        private int getMaxWidth(Control control, int size) {
            int width = control.computeSize((int)-1, (int)-1).x;
            return width > size ? width : size;
        }

        protected SOAPParameter getModifiedSOAPParameter() {
            this.soapParameter.setDefaultValue(this.defaultValue);
            return this.soapParameter;
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }

        protected Status getOKStatus() {
            return this.getMiscStatus(0, EMPTY_STRING);
        }

        protected Status getMiscStatus(int severity, String message) {
            return new Status(severity, "org.eclipse.ui", 0, message, null);
        }
    }

    class ParameterInputDialog
    extends StatusDialog {
        private TableViewer viewer;
        private Button editBtn;

        public ParameterInputDialog() {
            super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }

        public void create() {
            super.create();
            Point pt = this.getShell().computeSize(-1, -1);
            pt.x = Math.max(pt.x, 400);
            pt.y = Math.max(pt.y, 200);
            this.getShell().setSize(pt);
            this.getShell().setText(SOAPRequestPage.this.getTitle());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayout((Layout)layout);
            this.createCustomControls(composite);
            this.viewer.setInput((Object)SOAPRequestPage.this.soapRequest.getParameters());
            WSUIUtil.setSystemHelp((Control)composite, "org.eclipse.datatools.oda.cshelp.Dialog_SOAP_Request_Parameters_ID");
            return composite;
        }

        private void createCustomControls(Composite parent) {
            this.createTableViewer(parent);
            this.createBtnComposite(parent);
        }

        private void createBtnComposite(Composite parent) {
            this.editBtn = new Button(parent, 0);
            this.editBtn.setText(Messages.getString("parameterInputDialog.button.edit"));
            GridData btnData = new GridData(4);
            btnData.horizontalIndent = 5;
            this.editBtn.setLayoutData((Object)btnData);
            this.editBtn.setEnabled(this.viewer.getTable().getSelectionCount() == 1);
            this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterInputDialog.this.doEdit();
                }
            });
        }

        private void createTableViewer(Composite parent) {
            Table table = new Table(parent, 67584);
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            GridData layouData = new GridData(1808);
            table.setLayoutData((Object)layouData);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableColumn column0 = new TableColumn(table, 0);
            column0.setText(SOAPRequestPage.this.COLUMN_NAME);
            column0.setWidth(150);
            TableColumn column1 = new TableColumn(table, 0);
            column1.setText(SOAPRequestPage.this.COLUMN_DATATYPE);
            column1.setWidth(100);
            TableColumn column2 = new TableColumn(table, 0);
            column2.setText(SOAPRequestPage.this.COLUMN_DEFAULTVALUE);
            column2.setWidth(150);
            this.viewer = new TableViewer(table);
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    if (inputElement == null || !(inputElement instanceof SOAPParameter[])) {
                        return new Object[0];
                    }
                    return (SOAPParameter[])inputElement;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    SOAPParameter param = (SOAPParameter)element;
                    String value = "";
                    switch (columnIndex) {
                        case 0: {
                            value = param.getName();
                            break;
                        }
                        case 1: {
                            value = "";
                            break;
                        }
                        case 2: {
                            value = param.getDefaultValue();
                        }
                    }
                    return value;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.setupEditors();
        }

        private void setupEditors() {
            CellEditor[] editors = new CellEditor[3];
            int i = 0;
            while (i < editors.length) {
                editors[i] = new TextCellEditor((Composite)this.viewer.getTable(), 0);
                ++i;
            }
            this.viewer.setCellEditors(editors);
            this.viewer.setColumnProperties(new String[]{SOAPRequestPage.this.COLUMN_NAME, SOAPRequestPage.this.COLUMN_DATATYPE, SOAPRequestPage.this.COLUMN_DEFAULTVALUE});
            this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterInputDialog.this.editBtn.setEnabled(ParameterInputDialog.this.viewer.getTable().getSelectionCount() == 1);
                }
            });
            this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    ParameterInputDialog.this.doEdit();
                }
            });
        }

        private void doEdit() {
            SOAPParameter soapParameter;
            ParameterEditDialog dialog;
            int index = this.viewer.getTable().getSelectionIndex();
            if (index == -1) {
                return;
            }
            Object data = this.viewer.getTable().getItem(index).getData();
            if (data instanceof SOAPParameter && (dialog = new ParameterEditDialog(soapParameter = (SOAPParameter)data)).open() == 0) {
                soapParameter = dialog.getModifiedSOAPParameter();
                this.viewer.refresh();
            }
            this.viewer.getTable().setSelection(-1);
            this.editBtn.setEnabled(false);
        }
    }
}

