package org.eclipse.gef.dot.internal.ide.language.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.gef.dot.internal.language.services.DotSplineTypeGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotSplineTypeParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ExclamationMark", "Comma", "Semicolon", "E", "S", "RULE_DOUBLE", "RULE_WS"
    };
    public static final int E=7;
    public static final int RULE_WS=10;
    public static final int Semicolon=6;
    public static final int Comma=5;
    public static final int S=8;
    public static final int RULE_DOUBLE=9;
    public static final int EOF=-1;
    public static final int ExclamationMark=4;

    // delegates
    // delegators


        public InternalDotSplineTypeParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalDotSplineTypeParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalDotSplineTypeParser.tokenNames; }
    public String getGrammarFileName() { return "InternalDotSplineTypeParser.g"; }


    	private DotSplineTypeGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("ExclamationMark", "'!'");
    		tokenNameToValue.put("Comma", "','");
    		tokenNameToValue.put("Semicolon", "';'");
    		tokenNameToValue.put("E", "'e'");
    		tokenNameToValue.put("S", "'s'");
    	}

    	public void setGrammarAccess(DotSplineTypeGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}



    // $ANTLR start "entryRuleSplineType"
    // InternalDotSplineTypeParser.g:60:1: entryRuleSplineType : ruleSplineType EOF ;
    public final void entryRuleSplineType() throws RecognitionException {
        try {
            // InternalDotSplineTypeParser.g:61:1: ( ruleSplineType EOF )
            // InternalDotSplineTypeParser.g:62:1: ruleSplineType EOF
            {
             before(grammarAccess.getSplineTypeRule()); 
            pushFollow(FOLLOW_1);
            ruleSplineType();

            state._fsp--;

             after(grammarAccess.getSplineTypeRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleSplineType"


    // $ANTLR start "ruleSplineType"
    // InternalDotSplineTypeParser.g:69:1: ruleSplineType : ( ( rule__SplineType__Group__0 ) ) ;
    public final void ruleSplineType() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:73:2: ( ( ( rule__SplineType__Group__0 ) ) )
            // InternalDotSplineTypeParser.g:74:2: ( ( rule__SplineType__Group__0 ) )
            {
            // InternalDotSplineTypeParser.g:74:2: ( ( rule__SplineType__Group__0 ) )
            // InternalDotSplineTypeParser.g:75:3: ( rule__SplineType__Group__0 )
            {
             before(grammarAccess.getSplineTypeAccess().getGroup()); 
            // InternalDotSplineTypeParser.g:76:3: ( rule__SplineType__Group__0 )
            // InternalDotSplineTypeParser.g:76:4: rule__SplineType__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__SplineType__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getSplineTypeAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleSplineType"


    // $ANTLR start "entryRuleSpline"
    // InternalDotSplineTypeParser.g:85:1: entryRuleSpline : ruleSpline EOF ;
    public final void entryRuleSpline() throws RecognitionException {
        try {
            // InternalDotSplineTypeParser.g:86:1: ( ruleSpline EOF )
            // InternalDotSplineTypeParser.g:87:1: ruleSpline EOF
            {
             before(grammarAccess.getSplineRule()); 
            pushFollow(FOLLOW_1);
            ruleSpline();

            state._fsp--;

             after(grammarAccess.getSplineRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleSpline"


    // $ANTLR start "ruleSpline"
    // InternalDotSplineTypeParser.g:94:1: ruleSpline : ( ( rule__Spline__Group__0 ) ) ;
    public final void ruleSpline() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:98:2: ( ( ( rule__Spline__Group__0 ) ) )
            // InternalDotSplineTypeParser.g:99:2: ( ( rule__Spline__Group__0 ) )
            {
            // InternalDotSplineTypeParser.g:99:2: ( ( rule__Spline__Group__0 ) )
            // InternalDotSplineTypeParser.g:100:3: ( rule__Spline__Group__0 )
            {
             before(grammarAccess.getSplineAccess().getGroup()); 
            // InternalDotSplineTypeParser.g:101:3: ( rule__Spline__Group__0 )
            // InternalDotSplineTypeParser.g:101:4: rule__Spline__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Spline__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleSpline"


    // $ANTLR start "entryRulePoint"
    // InternalDotSplineTypeParser.g:110:1: entryRulePoint : rulePoint EOF ;
    public final void entryRulePoint() throws RecognitionException {
        try {
            // InternalDotSplineTypeParser.g:111:1: ( rulePoint EOF )
            // InternalDotSplineTypeParser.g:112:1: rulePoint EOF
            {
             before(grammarAccess.getPointRule()); 
            pushFollow(FOLLOW_1);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getPointRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRulePoint"


    // $ANTLR start "rulePoint"
    // InternalDotSplineTypeParser.g:119:1: rulePoint : ( ( rule__Point__Group__0 ) ) ;
    public final void rulePoint() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:123:2: ( ( ( rule__Point__Group__0 ) ) )
            // InternalDotSplineTypeParser.g:124:2: ( ( rule__Point__Group__0 ) )
            {
            // InternalDotSplineTypeParser.g:124:2: ( ( rule__Point__Group__0 ) )
            // InternalDotSplineTypeParser.g:125:3: ( rule__Point__Group__0 )
            {
             before(grammarAccess.getPointAccess().getGroup()); 
            // InternalDotSplineTypeParser.g:126:3: ( rule__Point__Group__0 )
            // InternalDotSplineTypeParser.g:126:4: rule__Point__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Point__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rulePoint"


    // $ANTLR start "rule__SplineType__Group__0"
    // InternalDotSplineTypeParser.g:134:1: rule__SplineType__Group__0 : rule__SplineType__Group__0__Impl rule__SplineType__Group__1 ;
    public final void rule__SplineType__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:138:1: ( rule__SplineType__Group__0__Impl rule__SplineType__Group__1 )
            // InternalDotSplineTypeParser.g:139:2: rule__SplineType__Group__0__Impl rule__SplineType__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__SplineType__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__SplineType__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group__0"


    // $ANTLR start "rule__SplineType__Group__0__Impl"
    // InternalDotSplineTypeParser.g:146:1: rule__SplineType__Group__0__Impl : ( ( rule__SplineType__SplinesAssignment_0 ) ) ;
    public final void rule__SplineType__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:150:1: ( ( ( rule__SplineType__SplinesAssignment_0 ) ) )
            // InternalDotSplineTypeParser.g:151:1: ( ( rule__SplineType__SplinesAssignment_0 ) )
            {
            // InternalDotSplineTypeParser.g:151:1: ( ( rule__SplineType__SplinesAssignment_0 ) )
            // InternalDotSplineTypeParser.g:152:2: ( rule__SplineType__SplinesAssignment_0 )
            {
             before(grammarAccess.getSplineTypeAccess().getSplinesAssignment_0()); 
            // InternalDotSplineTypeParser.g:153:2: ( rule__SplineType__SplinesAssignment_0 )
            // InternalDotSplineTypeParser.g:153:3: rule__SplineType__SplinesAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__SplineType__SplinesAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getSplineTypeAccess().getSplinesAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group__0__Impl"


    // $ANTLR start "rule__SplineType__Group__1"
    // InternalDotSplineTypeParser.g:161:1: rule__SplineType__Group__1 : rule__SplineType__Group__1__Impl ;
    public final void rule__SplineType__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:165:1: ( rule__SplineType__Group__1__Impl )
            // InternalDotSplineTypeParser.g:166:2: rule__SplineType__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__SplineType__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group__1"


    // $ANTLR start "rule__SplineType__Group__1__Impl"
    // InternalDotSplineTypeParser.g:172:1: rule__SplineType__Group__1__Impl : ( ( rule__SplineType__Group_1__0 )* ) ;
    public final void rule__SplineType__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:176:1: ( ( ( rule__SplineType__Group_1__0 )* ) )
            // InternalDotSplineTypeParser.g:177:1: ( ( rule__SplineType__Group_1__0 )* )
            {
            // InternalDotSplineTypeParser.g:177:1: ( ( rule__SplineType__Group_1__0 )* )
            // InternalDotSplineTypeParser.g:178:2: ( rule__SplineType__Group_1__0 )*
            {
             before(grammarAccess.getSplineTypeAccess().getGroup_1()); 
            // InternalDotSplineTypeParser.g:179:2: ( rule__SplineType__Group_1__0 )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==Semicolon) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // InternalDotSplineTypeParser.g:179:3: rule__SplineType__Group_1__0
            	    {
            	    pushFollow(FOLLOW_4);
            	    rule__SplineType__Group_1__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

             after(grammarAccess.getSplineTypeAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group__1__Impl"


    // $ANTLR start "rule__SplineType__Group_1__0"
    // InternalDotSplineTypeParser.g:188:1: rule__SplineType__Group_1__0 : rule__SplineType__Group_1__0__Impl rule__SplineType__Group_1__1 ;
    public final void rule__SplineType__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:192:1: ( rule__SplineType__Group_1__0__Impl rule__SplineType__Group_1__1 )
            // InternalDotSplineTypeParser.g:193:2: rule__SplineType__Group_1__0__Impl rule__SplineType__Group_1__1
            {
            pushFollow(FOLLOW_5);
            rule__SplineType__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__SplineType__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group_1__0"


    // $ANTLR start "rule__SplineType__Group_1__0__Impl"
    // InternalDotSplineTypeParser.g:200:1: rule__SplineType__Group_1__0__Impl : ( Semicolon ) ;
    public final void rule__SplineType__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:204:1: ( ( Semicolon ) )
            // InternalDotSplineTypeParser.g:205:1: ( Semicolon )
            {
            // InternalDotSplineTypeParser.g:205:1: ( Semicolon )
            // InternalDotSplineTypeParser.g:206:2: Semicolon
            {
             before(grammarAccess.getSplineTypeAccess().getSemicolonKeyword_1_0()); 
            match(input,Semicolon,FOLLOW_2); 
             after(grammarAccess.getSplineTypeAccess().getSemicolonKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group_1__0__Impl"


    // $ANTLR start "rule__SplineType__Group_1__1"
    // InternalDotSplineTypeParser.g:215:1: rule__SplineType__Group_1__1 : rule__SplineType__Group_1__1__Impl ;
    public final void rule__SplineType__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:219:1: ( rule__SplineType__Group_1__1__Impl )
            // InternalDotSplineTypeParser.g:220:2: rule__SplineType__Group_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__SplineType__Group_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group_1__1"


    // $ANTLR start "rule__SplineType__Group_1__1__Impl"
    // InternalDotSplineTypeParser.g:226:1: rule__SplineType__Group_1__1__Impl : ( ( rule__SplineType__SplinesAssignment_1_1 ) ) ;
    public final void rule__SplineType__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:230:1: ( ( ( rule__SplineType__SplinesAssignment_1_1 ) ) )
            // InternalDotSplineTypeParser.g:231:1: ( ( rule__SplineType__SplinesAssignment_1_1 ) )
            {
            // InternalDotSplineTypeParser.g:231:1: ( ( rule__SplineType__SplinesAssignment_1_1 ) )
            // InternalDotSplineTypeParser.g:232:2: ( rule__SplineType__SplinesAssignment_1_1 )
            {
             before(grammarAccess.getSplineTypeAccess().getSplinesAssignment_1_1()); 
            // InternalDotSplineTypeParser.g:233:2: ( rule__SplineType__SplinesAssignment_1_1 )
            // InternalDotSplineTypeParser.g:233:3: rule__SplineType__SplinesAssignment_1_1
            {
            pushFollow(FOLLOW_2);
            rule__SplineType__SplinesAssignment_1_1();

            state._fsp--;


            }

             after(grammarAccess.getSplineTypeAccess().getSplinesAssignment_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__Group_1__1__Impl"


    // $ANTLR start "rule__Spline__Group__0"
    // InternalDotSplineTypeParser.g:242:1: rule__Spline__Group__0 : rule__Spline__Group__0__Impl rule__Spline__Group__1 ;
    public final void rule__Spline__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:246:1: ( rule__Spline__Group__0__Impl rule__Spline__Group__1 )
            // InternalDotSplineTypeParser.g:247:2: rule__Spline__Group__0__Impl rule__Spline__Group__1
            {
            pushFollow(FOLLOW_5);
            rule__Spline__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__0"


    // $ANTLR start "rule__Spline__Group__0__Impl"
    // InternalDotSplineTypeParser.g:254:1: rule__Spline__Group__0__Impl : ( ( rule__Spline__Group_0__0 )? ) ;
    public final void rule__Spline__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:258:1: ( ( ( rule__Spline__Group_0__0 )? ) )
            // InternalDotSplineTypeParser.g:259:1: ( ( rule__Spline__Group_0__0 )? )
            {
            // InternalDotSplineTypeParser.g:259:1: ( ( rule__Spline__Group_0__0 )? )
            // InternalDotSplineTypeParser.g:260:2: ( rule__Spline__Group_0__0 )?
            {
             before(grammarAccess.getSplineAccess().getGroup_0()); 
            // InternalDotSplineTypeParser.g:261:2: ( rule__Spline__Group_0__0 )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==S) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // InternalDotSplineTypeParser.g:261:3: rule__Spline__Group_0__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Spline__Group_0__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getSplineAccess().getGroup_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__0__Impl"


    // $ANTLR start "rule__Spline__Group__1"
    // InternalDotSplineTypeParser.g:269:1: rule__Spline__Group__1 : rule__Spline__Group__1__Impl rule__Spline__Group__2 ;
    public final void rule__Spline__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:273:1: ( rule__Spline__Group__1__Impl rule__Spline__Group__2 )
            // InternalDotSplineTypeParser.g:274:2: rule__Spline__Group__1__Impl rule__Spline__Group__2
            {
            pushFollow(FOLLOW_5);
            rule__Spline__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__1"


    // $ANTLR start "rule__Spline__Group__1__Impl"
    // InternalDotSplineTypeParser.g:281:1: rule__Spline__Group__1__Impl : ( ( rule__Spline__Group_1__0 )? ) ;
    public final void rule__Spline__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:285:1: ( ( ( rule__Spline__Group_1__0 )? ) )
            // InternalDotSplineTypeParser.g:286:1: ( ( rule__Spline__Group_1__0 )? )
            {
            // InternalDotSplineTypeParser.g:286:1: ( ( rule__Spline__Group_1__0 )? )
            // InternalDotSplineTypeParser.g:287:2: ( rule__Spline__Group_1__0 )?
            {
             before(grammarAccess.getSplineAccess().getGroup_1()); 
            // InternalDotSplineTypeParser.g:288:2: ( rule__Spline__Group_1__0 )?
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==E) ) {
                alt3=1;
            }
            switch (alt3) {
                case 1 :
                    // InternalDotSplineTypeParser.g:288:3: rule__Spline__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Spline__Group_1__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getSplineAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__1__Impl"


    // $ANTLR start "rule__Spline__Group__2"
    // InternalDotSplineTypeParser.g:296:1: rule__Spline__Group__2 : rule__Spline__Group__2__Impl rule__Spline__Group__3 ;
    public final void rule__Spline__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:300:1: ( rule__Spline__Group__2__Impl rule__Spline__Group__3 )
            // InternalDotSplineTypeParser.g:301:2: rule__Spline__Group__2__Impl rule__Spline__Group__3
            {
            pushFollow(FOLLOW_5);
            rule__Spline__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__2"


    // $ANTLR start "rule__Spline__Group__2__Impl"
    // InternalDotSplineTypeParser.g:308:1: rule__Spline__Group__2__Impl : ( ( rule__Spline__ControlPointsAssignment_2 ) ) ;
    public final void rule__Spline__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:312:1: ( ( ( rule__Spline__ControlPointsAssignment_2 ) ) )
            // InternalDotSplineTypeParser.g:313:1: ( ( rule__Spline__ControlPointsAssignment_2 ) )
            {
            // InternalDotSplineTypeParser.g:313:1: ( ( rule__Spline__ControlPointsAssignment_2 ) )
            // InternalDotSplineTypeParser.g:314:2: ( rule__Spline__ControlPointsAssignment_2 )
            {
             before(grammarAccess.getSplineAccess().getControlPointsAssignment_2()); 
            // InternalDotSplineTypeParser.g:315:2: ( rule__Spline__ControlPointsAssignment_2 )
            // InternalDotSplineTypeParser.g:315:3: rule__Spline__ControlPointsAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__Spline__ControlPointsAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getControlPointsAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__2__Impl"


    // $ANTLR start "rule__Spline__Group__3"
    // InternalDotSplineTypeParser.g:323:1: rule__Spline__Group__3 : rule__Spline__Group__3__Impl ;
    public final void rule__Spline__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:327:1: ( rule__Spline__Group__3__Impl )
            // InternalDotSplineTypeParser.g:328:2: rule__Spline__Group__3__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Spline__Group__3__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__3"


    // $ANTLR start "rule__Spline__Group__3__Impl"
    // InternalDotSplineTypeParser.g:334:1: rule__Spline__Group__3__Impl : ( ( ( rule__Spline__Group_3__0 ) ) ( ( rule__Spline__Group_3__0 )* ) ) ;
    public final void rule__Spline__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:338:1: ( ( ( ( rule__Spline__Group_3__0 ) ) ( ( rule__Spline__Group_3__0 )* ) ) )
            // InternalDotSplineTypeParser.g:339:1: ( ( ( rule__Spline__Group_3__0 ) ) ( ( rule__Spline__Group_3__0 )* ) )
            {
            // InternalDotSplineTypeParser.g:339:1: ( ( ( rule__Spline__Group_3__0 ) ) ( ( rule__Spline__Group_3__0 )* ) )
            // InternalDotSplineTypeParser.g:340:2: ( ( rule__Spline__Group_3__0 ) ) ( ( rule__Spline__Group_3__0 )* )
            {
            // InternalDotSplineTypeParser.g:340:2: ( ( rule__Spline__Group_3__0 ) )
            // InternalDotSplineTypeParser.g:341:3: ( rule__Spline__Group_3__0 )
            {
             before(grammarAccess.getSplineAccess().getGroup_3()); 
            // InternalDotSplineTypeParser.g:342:3: ( rule__Spline__Group_3__0 )
            // InternalDotSplineTypeParser.g:342:4: rule__Spline__Group_3__0
            {
            pushFollow(FOLLOW_6);
            rule__Spline__Group_3__0();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getGroup_3()); 

            }

            // InternalDotSplineTypeParser.g:345:2: ( ( rule__Spline__Group_3__0 )* )
            // InternalDotSplineTypeParser.g:346:3: ( rule__Spline__Group_3__0 )*
            {
             before(grammarAccess.getSplineAccess().getGroup_3()); 
            // InternalDotSplineTypeParser.g:347:3: ( rule__Spline__Group_3__0 )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0==RULE_DOUBLE) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // InternalDotSplineTypeParser.g:347:4: rule__Spline__Group_3__0
            	    {
            	    pushFollow(FOLLOW_6);
            	    rule__Spline__Group_3__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

             after(grammarAccess.getSplineAccess().getGroup_3()); 

            }


            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group__3__Impl"


    // $ANTLR start "rule__Spline__Group_0__0"
    // InternalDotSplineTypeParser.g:357:1: rule__Spline__Group_0__0 : rule__Spline__Group_0__0__Impl rule__Spline__Group_0__1 ;
    public final void rule__Spline__Group_0__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:361:1: ( rule__Spline__Group_0__0__Impl rule__Spline__Group_0__1 )
            // InternalDotSplineTypeParser.g:362:2: rule__Spline__Group_0__0__Impl rule__Spline__Group_0__1
            {
            pushFollow(FOLLOW_7);
            rule__Spline__Group_0__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group_0__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_0__0"


    // $ANTLR start "rule__Spline__Group_0__0__Impl"
    // InternalDotSplineTypeParser.g:369:1: rule__Spline__Group_0__0__Impl : ( S ) ;
    public final void rule__Spline__Group_0__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:373:1: ( ( S ) )
            // InternalDotSplineTypeParser.g:374:1: ( S )
            {
            // InternalDotSplineTypeParser.g:374:1: ( S )
            // InternalDotSplineTypeParser.g:375:2: S
            {
             before(grammarAccess.getSplineAccess().getSKeyword_0_0()); 
            match(input,S,FOLLOW_2); 
             after(grammarAccess.getSplineAccess().getSKeyword_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_0__0__Impl"


    // $ANTLR start "rule__Spline__Group_0__1"
    // InternalDotSplineTypeParser.g:384:1: rule__Spline__Group_0__1 : rule__Spline__Group_0__1__Impl rule__Spline__Group_0__2 ;
    public final void rule__Spline__Group_0__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:388:1: ( rule__Spline__Group_0__1__Impl rule__Spline__Group_0__2 )
            // InternalDotSplineTypeParser.g:389:2: rule__Spline__Group_0__1__Impl rule__Spline__Group_0__2
            {
            pushFollow(FOLLOW_5);
            rule__Spline__Group_0__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group_0__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_0__1"


    // $ANTLR start "rule__Spline__Group_0__1__Impl"
    // InternalDotSplineTypeParser.g:396:1: rule__Spline__Group_0__1__Impl : ( Comma ) ;
    public final void rule__Spline__Group_0__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:400:1: ( ( Comma ) )
            // InternalDotSplineTypeParser.g:401:1: ( Comma )
            {
            // InternalDotSplineTypeParser.g:401:1: ( Comma )
            // InternalDotSplineTypeParser.g:402:2: Comma
            {
             before(grammarAccess.getSplineAccess().getCommaKeyword_0_1()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getSplineAccess().getCommaKeyword_0_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_0__1__Impl"


    // $ANTLR start "rule__Spline__Group_0__2"
    // InternalDotSplineTypeParser.g:411:1: rule__Spline__Group_0__2 : rule__Spline__Group_0__2__Impl ;
    public final void rule__Spline__Group_0__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:415:1: ( rule__Spline__Group_0__2__Impl )
            // InternalDotSplineTypeParser.g:416:2: rule__Spline__Group_0__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Spline__Group_0__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_0__2"


    // $ANTLR start "rule__Spline__Group_0__2__Impl"
    // InternalDotSplineTypeParser.g:422:1: rule__Spline__Group_0__2__Impl : ( ( rule__Spline__StartpAssignment_0_2 ) ) ;
    public final void rule__Spline__Group_0__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:426:1: ( ( ( rule__Spline__StartpAssignment_0_2 ) ) )
            // InternalDotSplineTypeParser.g:427:1: ( ( rule__Spline__StartpAssignment_0_2 ) )
            {
            // InternalDotSplineTypeParser.g:427:1: ( ( rule__Spline__StartpAssignment_0_2 ) )
            // InternalDotSplineTypeParser.g:428:2: ( rule__Spline__StartpAssignment_0_2 )
            {
             before(grammarAccess.getSplineAccess().getStartpAssignment_0_2()); 
            // InternalDotSplineTypeParser.g:429:2: ( rule__Spline__StartpAssignment_0_2 )
            // InternalDotSplineTypeParser.g:429:3: rule__Spline__StartpAssignment_0_2
            {
            pushFollow(FOLLOW_2);
            rule__Spline__StartpAssignment_0_2();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getStartpAssignment_0_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_0__2__Impl"


    // $ANTLR start "rule__Spline__Group_1__0"
    // InternalDotSplineTypeParser.g:438:1: rule__Spline__Group_1__0 : rule__Spline__Group_1__0__Impl rule__Spline__Group_1__1 ;
    public final void rule__Spline__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:442:1: ( rule__Spline__Group_1__0__Impl rule__Spline__Group_1__1 )
            // InternalDotSplineTypeParser.g:443:2: rule__Spline__Group_1__0__Impl rule__Spline__Group_1__1
            {
            pushFollow(FOLLOW_7);
            rule__Spline__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_1__0"


    // $ANTLR start "rule__Spline__Group_1__0__Impl"
    // InternalDotSplineTypeParser.g:450:1: rule__Spline__Group_1__0__Impl : ( E ) ;
    public final void rule__Spline__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:454:1: ( ( E ) )
            // InternalDotSplineTypeParser.g:455:1: ( E )
            {
            // InternalDotSplineTypeParser.g:455:1: ( E )
            // InternalDotSplineTypeParser.g:456:2: E
            {
             before(grammarAccess.getSplineAccess().getEKeyword_1_0()); 
            match(input,E,FOLLOW_2); 
             after(grammarAccess.getSplineAccess().getEKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_1__0__Impl"


    // $ANTLR start "rule__Spline__Group_1__1"
    // InternalDotSplineTypeParser.g:465:1: rule__Spline__Group_1__1 : rule__Spline__Group_1__1__Impl rule__Spline__Group_1__2 ;
    public final void rule__Spline__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:469:1: ( rule__Spline__Group_1__1__Impl rule__Spline__Group_1__2 )
            // InternalDotSplineTypeParser.g:470:2: rule__Spline__Group_1__1__Impl rule__Spline__Group_1__2
            {
            pushFollow(FOLLOW_5);
            rule__Spline__Group_1__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group_1__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_1__1"


    // $ANTLR start "rule__Spline__Group_1__1__Impl"
    // InternalDotSplineTypeParser.g:477:1: rule__Spline__Group_1__1__Impl : ( Comma ) ;
    public final void rule__Spline__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:481:1: ( ( Comma ) )
            // InternalDotSplineTypeParser.g:482:1: ( Comma )
            {
            // InternalDotSplineTypeParser.g:482:1: ( Comma )
            // InternalDotSplineTypeParser.g:483:2: Comma
            {
             before(grammarAccess.getSplineAccess().getCommaKeyword_1_1()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getSplineAccess().getCommaKeyword_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_1__1__Impl"


    // $ANTLR start "rule__Spline__Group_1__2"
    // InternalDotSplineTypeParser.g:492:1: rule__Spline__Group_1__2 : rule__Spline__Group_1__2__Impl ;
    public final void rule__Spline__Group_1__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:496:1: ( rule__Spline__Group_1__2__Impl )
            // InternalDotSplineTypeParser.g:497:2: rule__Spline__Group_1__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Spline__Group_1__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_1__2"


    // $ANTLR start "rule__Spline__Group_1__2__Impl"
    // InternalDotSplineTypeParser.g:503:1: rule__Spline__Group_1__2__Impl : ( ( rule__Spline__EndpAssignment_1_2 ) ) ;
    public final void rule__Spline__Group_1__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:507:1: ( ( ( rule__Spline__EndpAssignment_1_2 ) ) )
            // InternalDotSplineTypeParser.g:508:1: ( ( rule__Spline__EndpAssignment_1_2 ) )
            {
            // InternalDotSplineTypeParser.g:508:1: ( ( rule__Spline__EndpAssignment_1_2 ) )
            // InternalDotSplineTypeParser.g:509:2: ( rule__Spline__EndpAssignment_1_2 )
            {
             before(grammarAccess.getSplineAccess().getEndpAssignment_1_2()); 
            // InternalDotSplineTypeParser.g:510:2: ( rule__Spline__EndpAssignment_1_2 )
            // InternalDotSplineTypeParser.g:510:3: rule__Spline__EndpAssignment_1_2
            {
            pushFollow(FOLLOW_2);
            rule__Spline__EndpAssignment_1_2();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getEndpAssignment_1_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_1__2__Impl"


    // $ANTLR start "rule__Spline__Group_3__0"
    // InternalDotSplineTypeParser.g:519:1: rule__Spline__Group_3__0 : rule__Spline__Group_3__0__Impl rule__Spline__Group_3__1 ;
    public final void rule__Spline__Group_3__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:523:1: ( rule__Spline__Group_3__0__Impl rule__Spline__Group_3__1 )
            // InternalDotSplineTypeParser.g:524:2: rule__Spline__Group_3__0__Impl rule__Spline__Group_3__1
            {
            pushFollow(FOLLOW_5);
            rule__Spline__Group_3__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group_3__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_3__0"


    // $ANTLR start "rule__Spline__Group_3__0__Impl"
    // InternalDotSplineTypeParser.g:531:1: rule__Spline__Group_3__0__Impl : ( ( rule__Spline__ControlPointsAssignment_3_0 ) ) ;
    public final void rule__Spline__Group_3__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:535:1: ( ( ( rule__Spline__ControlPointsAssignment_3_0 ) ) )
            // InternalDotSplineTypeParser.g:536:1: ( ( rule__Spline__ControlPointsAssignment_3_0 ) )
            {
            // InternalDotSplineTypeParser.g:536:1: ( ( rule__Spline__ControlPointsAssignment_3_0 ) )
            // InternalDotSplineTypeParser.g:537:2: ( rule__Spline__ControlPointsAssignment_3_0 )
            {
             before(grammarAccess.getSplineAccess().getControlPointsAssignment_3_0()); 
            // InternalDotSplineTypeParser.g:538:2: ( rule__Spline__ControlPointsAssignment_3_0 )
            // InternalDotSplineTypeParser.g:538:3: rule__Spline__ControlPointsAssignment_3_0
            {
            pushFollow(FOLLOW_2);
            rule__Spline__ControlPointsAssignment_3_0();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getControlPointsAssignment_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_3__0__Impl"


    // $ANTLR start "rule__Spline__Group_3__1"
    // InternalDotSplineTypeParser.g:546:1: rule__Spline__Group_3__1 : rule__Spline__Group_3__1__Impl rule__Spline__Group_3__2 ;
    public final void rule__Spline__Group_3__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:550:1: ( rule__Spline__Group_3__1__Impl rule__Spline__Group_3__2 )
            // InternalDotSplineTypeParser.g:551:2: rule__Spline__Group_3__1__Impl rule__Spline__Group_3__2
            {
            pushFollow(FOLLOW_5);
            rule__Spline__Group_3__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Spline__Group_3__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_3__1"


    // $ANTLR start "rule__Spline__Group_3__1__Impl"
    // InternalDotSplineTypeParser.g:558:1: rule__Spline__Group_3__1__Impl : ( ( rule__Spline__ControlPointsAssignment_3_1 ) ) ;
    public final void rule__Spline__Group_3__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:562:1: ( ( ( rule__Spline__ControlPointsAssignment_3_1 ) ) )
            // InternalDotSplineTypeParser.g:563:1: ( ( rule__Spline__ControlPointsAssignment_3_1 ) )
            {
            // InternalDotSplineTypeParser.g:563:1: ( ( rule__Spline__ControlPointsAssignment_3_1 ) )
            // InternalDotSplineTypeParser.g:564:2: ( rule__Spline__ControlPointsAssignment_3_1 )
            {
             before(grammarAccess.getSplineAccess().getControlPointsAssignment_3_1()); 
            // InternalDotSplineTypeParser.g:565:2: ( rule__Spline__ControlPointsAssignment_3_1 )
            // InternalDotSplineTypeParser.g:565:3: rule__Spline__ControlPointsAssignment_3_1
            {
            pushFollow(FOLLOW_2);
            rule__Spline__ControlPointsAssignment_3_1();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getControlPointsAssignment_3_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_3__1__Impl"


    // $ANTLR start "rule__Spline__Group_3__2"
    // InternalDotSplineTypeParser.g:573:1: rule__Spline__Group_3__2 : rule__Spline__Group_3__2__Impl ;
    public final void rule__Spline__Group_3__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:577:1: ( rule__Spline__Group_3__2__Impl )
            // InternalDotSplineTypeParser.g:578:2: rule__Spline__Group_3__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Spline__Group_3__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_3__2"


    // $ANTLR start "rule__Spline__Group_3__2__Impl"
    // InternalDotSplineTypeParser.g:584:1: rule__Spline__Group_3__2__Impl : ( ( rule__Spline__ControlPointsAssignment_3_2 ) ) ;
    public final void rule__Spline__Group_3__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:588:1: ( ( ( rule__Spline__ControlPointsAssignment_3_2 ) ) )
            // InternalDotSplineTypeParser.g:589:1: ( ( rule__Spline__ControlPointsAssignment_3_2 ) )
            {
            // InternalDotSplineTypeParser.g:589:1: ( ( rule__Spline__ControlPointsAssignment_3_2 ) )
            // InternalDotSplineTypeParser.g:590:2: ( rule__Spline__ControlPointsAssignment_3_2 )
            {
             before(grammarAccess.getSplineAccess().getControlPointsAssignment_3_2()); 
            // InternalDotSplineTypeParser.g:591:2: ( rule__Spline__ControlPointsAssignment_3_2 )
            // InternalDotSplineTypeParser.g:591:3: rule__Spline__ControlPointsAssignment_3_2
            {
            pushFollow(FOLLOW_2);
            rule__Spline__ControlPointsAssignment_3_2();

            state._fsp--;


            }

             after(grammarAccess.getSplineAccess().getControlPointsAssignment_3_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__Group_3__2__Impl"


    // $ANTLR start "rule__Point__Group__0"
    // InternalDotSplineTypeParser.g:600:1: rule__Point__Group__0 : rule__Point__Group__0__Impl rule__Point__Group__1 ;
    public final void rule__Point__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:604:1: ( rule__Point__Group__0__Impl rule__Point__Group__1 )
            // InternalDotSplineTypeParser.g:605:2: rule__Point__Group__0__Impl rule__Point__Group__1
            {
            pushFollow(FOLLOW_7);
            rule__Point__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__0"


    // $ANTLR start "rule__Point__Group__0__Impl"
    // InternalDotSplineTypeParser.g:612:1: rule__Point__Group__0__Impl : ( ( rule__Point__XAssignment_0 ) ) ;
    public final void rule__Point__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:616:1: ( ( ( rule__Point__XAssignment_0 ) ) )
            // InternalDotSplineTypeParser.g:617:1: ( ( rule__Point__XAssignment_0 ) )
            {
            // InternalDotSplineTypeParser.g:617:1: ( ( rule__Point__XAssignment_0 ) )
            // InternalDotSplineTypeParser.g:618:2: ( rule__Point__XAssignment_0 )
            {
             before(grammarAccess.getPointAccess().getXAssignment_0()); 
            // InternalDotSplineTypeParser.g:619:2: ( rule__Point__XAssignment_0 )
            // InternalDotSplineTypeParser.g:619:3: rule__Point__XAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__Point__XAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getXAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__0__Impl"


    // $ANTLR start "rule__Point__Group__1"
    // InternalDotSplineTypeParser.g:627:1: rule__Point__Group__1 : rule__Point__Group__1__Impl rule__Point__Group__2 ;
    public final void rule__Point__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:631:1: ( rule__Point__Group__1__Impl rule__Point__Group__2 )
            // InternalDotSplineTypeParser.g:632:2: rule__Point__Group__1__Impl rule__Point__Group__2
            {
            pushFollow(FOLLOW_8);
            rule__Point__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__1"


    // $ANTLR start "rule__Point__Group__1__Impl"
    // InternalDotSplineTypeParser.g:639:1: rule__Point__Group__1__Impl : ( Comma ) ;
    public final void rule__Point__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:643:1: ( ( Comma ) )
            // InternalDotSplineTypeParser.g:644:1: ( Comma )
            {
            // InternalDotSplineTypeParser.g:644:1: ( Comma )
            // InternalDotSplineTypeParser.g:645:2: Comma
            {
             before(grammarAccess.getPointAccess().getCommaKeyword_1()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getCommaKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__1__Impl"


    // $ANTLR start "rule__Point__Group__2"
    // InternalDotSplineTypeParser.g:654:1: rule__Point__Group__2 : rule__Point__Group__2__Impl rule__Point__Group__3 ;
    public final void rule__Point__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:658:1: ( rule__Point__Group__2__Impl rule__Point__Group__3 )
            // InternalDotSplineTypeParser.g:659:2: rule__Point__Group__2__Impl rule__Point__Group__3
            {
            pushFollow(FOLLOW_9);
            rule__Point__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__2"


    // $ANTLR start "rule__Point__Group__2__Impl"
    // InternalDotSplineTypeParser.g:666:1: rule__Point__Group__2__Impl : ( ( rule__Point__YAssignment_2 ) ) ;
    public final void rule__Point__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:670:1: ( ( ( rule__Point__YAssignment_2 ) ) )
            // InternalDotSplineTypeParser.g:671:1: ( ( rule__Point__YAssignment_2 ) )
            {
            // InternalDotSplineTypeParser.g:671:1: ( ( rule__Point__YAssignment_2 ) )
            // InternalDotSplineTypeParser.g:672:2: ( rule__Point__YAssignment_2 )
            {
             before(grammarAccess.getPointAccess().getYAssignment_2()); 
            // InternalDotSplineTypeParser.g:673:2: ( rule__Point__YAssignment_2 )
            // InternalDotSplineTypeParser.g:673:3: rule__Point__YAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__Point__YAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getYAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__2__Impl"


    // $ANTLR start "rule__Point__Group__3"
    // InternalDotSplineTypeParser.g:681:1: rule__Point__Group__3 : rule__Point__Group__3__Impl rule__Point__Group__4 ;
    public final void rule__Point__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:685:1: ( rule__Point__Group__3__Impl rule__Point__Group__4 )
            // InternalDotSplineTypeParser.g:686:2: rule__Point__Group__3__Impl rule__Point__Group__4
            {
            pushFollow(FOLLOW_9);
            rule__Point__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__3"


    // $ANTLR start "rule__Point__Group__3__Impl"
    // InternalDotSplineTypeParser.g:693:1: rule__Point__Group__3__Impl : ( ( rule__Point__Group_3__0 )? ) ;
    public final void rule__Point__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:697:1: ( ( ( rule__Point__Group_3__0 )? ) )
            // InternalDotSplineTypeParser.g:698:1: ( ( rule__Point__Group_3__0 )? )
            {
            // InternalDotSplineTypeParser.g:698:1: ( ( rule__Point__Group_3__0 )? )
            // InternalDotSplineTypeParser.g:699:2: ( rule__Point__Group_3__0 )?
            {
             before(grammarAccess.getPointAccess().getGroup_3()); 
            // InternalDotSplineTypeParser.g:700:2: ( rule__Point__Group_3__0 )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==Comma) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // InternalDotSplineTypeParser.g:700:3: rule__Point__Group_3__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Point__Group_3__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getPointAccess().getGroup_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__3__Impl"


    // $ANTLR start "rule__Point__Group__4"
    // InternalDotSplineTypeParser.g:708:1: rule__Point__Group__4 : rule__Point__Group__4__Impl ;
    public final void rule__Point__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:712:1: ( rule__Point__Group__4__Impl )
            // InternalDotSplineTypeParser.g:713:2: rule__Point__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Point__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__4"


    // $ANTLR start "rule__Point__Group__4__Impl"
    // InternalDotSplineTypeParser.g:719:1: rule__Point__Group__4__Impl : ( ( rule__Point__InputOnlyAssignment_4 )? ) ;
    public final void rule__Point__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:723:1: ( ( ( rule__Point__InputOnlyAssignment_4 )? ) )
            // InternalDotSplineTypeParser.g:724:1: ( ( rule__Point__InputOnlyAssignment_4 )? )
            {
            // InternalDotSplineTypeParser.g:724:1: ( ( rule__Point__InputOnlyAssignment_4 )? )
            // InternalDotSplineTypeParser.g:725:2: ( rule__Point__InputOnlyAssignment_4 )?
            {
             before(grammarAccess.getPointAccess().getInputOnlyAssignment_4()); 
            // InternalDotSplineTypeParser.g:726:2: ( rule__Point__InputOnlyAssignment_4 )?
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==ExclamationMark) ) {
                alt6=1;
            }
            switch (alt6) {
                case 1 :
                    // InternalDotSplineTypeParser.g:726:3: rule__Point__InputOnlyAssignment_4
                    {
                    pushFollow(FOLLOW_2);
                    rule__Point__InputOnlyAssignment_4();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getPointAccess().getInputOnlyAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__4__Impl"


    // $ANTLR start "rule__Point__Group_3__0"
    // InternalDotSplineTypeParser.g:735:1: rule__Point__Group_3__0 : rule__Point__Group_3__0__Impl rule__Point__Group_3__1 ;
    public final void rule__Point__Group_3__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:739:1: ( rule__Point__Group_3__0__Impl rule__Point__Group_3__1 )
            // InternalDotSplineTypeParser.g:740:2: rule__Point__Group_3__0__Impl rule__Point__Group_3__1
            {
            pushFollow(FOLLOW_8);
            rule__Point__Group_3__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group_3__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__0"


    // $ANTLR start "rule__Point__Group_3__0__Impl"
    // InternalDotSplineTypeParser.g:747:1: rule__Point__Group_3__0__Impl : ( Comma ) ;
    public final void rule__Point__Group_3__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:751:1: ( ( Comma ) )
            // InternalDotSplineTypeParser.g:752:1: ( Comma )
            {
            // InternalDotSplineTypeParser.g:752:1: ( Comma )
            // InternalDotSplineTypeParser.g:753:2: Comma
            {
             before(grammarAccess.getPointAccess().getCommaKeyword_3_0()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getCommaKeyword_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__0__Impl"


    // $ANTLR start "rule__Point__Group_3__1"
    // InternalDotSplineTypeParser.g:762:1: rule__Point__Group_3__1 : rule__Point__Group_3__1__Impl ;
    public final void rule__Point__Group_3__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:766:1: ( rule__Point__Group_3__1__Impl )
            // InternalDotSplineTypeParser.g:767:2: rule__Point__Group_3__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Point__Group_3__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__1"


    // $ANTLR start "rule__Point__Group_3__1__Impl"
    // InternalDotSplineTypeParser.g:773:1: rule__Point__Group_3__1__Impl : ( ( rule__Point__ZAssignment_3_1 ) ) ;
    public final void rule__Point__Group_3__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:777:1: ( ( ( rule__Point__ZAssignment_3_1 ) ) )
            // InternalDotSplineTypeParser.g:778:1: ( ( rule__Point__ZAssignment_3_1 ) )
            {
            // InternalDotSplineTypeParser.g:778:1: ( ( rule__Point__ZAssignment_3_1 ) )
            // InternalDotSplineTypeParser.g:779:2: ( rule__Point__ZAssignment_3_1 )
            {
             before(grammarAccess.getPointAccess().getZAssignment_3_1()); 
            // InternalDotSplineTypeParser.g:780:2: ( rule__Point__ZAssignment_3_1 )
            // InternalDotSplineTypeParser.g:780:3: rule__Point__ZAssignment_3_1
            {
            pushFollow(FOLLOW_2);
            rule__Point__ZAssignment_3_1();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getZAssignment_3_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__1__Impl"


    // $ANTLR start "rule__SplineType__SplinesAssignment_0"
    // InternalDotSplineTypeParser.g:789:1: rule__SplineType__SplinesAssignment_0 : ( ruleSpline ) ;
    public final void rule__SplineType__SplinesAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:793:1: ( ( ruleSpline ) )
            // InternalDotSplineTypeParser.g:794:2: ( ruleSpline )
            {
            // InternalDotSplineTypeParser.g:794:2: ( ruleSpline )
            // InternalDotSplineTypeParser.g:795:3: ruleSpline
            {
             before(grammarAccess.getSplineTypeAccess().getSplinesSplineParserRuleCall_0_0()); 
            pushFollow(FOLLOW_2);
            ruleSpline();

            state._fsp--;

             after(grammarAccess.getSplineTypeAccess().getSplinesSplineParserRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__SplinesAssignment_0"


    // $ANTLR start "rule__SplineType__SplinesAssignment_1_1"
    // InternalDotSplineTypeParser.g:804:1: rule__SplineType__SplinesAssignment_1_1 : ( ruleSpline ) ;
    public final void rule__SplineType__SplinesAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:808:1: ( ( ruleSpline ) )
            // InternalDotSplineTypeParser.g:809:2: ( ruleSpline )
            {
            // InternalDotSplineTypeParser.g:809:2: ( ruleSpline )
            // InternalDotSplineTypeParser.g:810:3: ruleSpline
            {
             before(grammarAccess.getSplineTypeAccess().getSplinesSplineParserRuleCall_1_1_0()); 
            pushFollow(FOLLOW_2);
            ruleSpline();

            state._fsp--;

             after(grammarAccess.getSplineTypeAccess().getSplinesSplineParserRuleCall_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SplineType__SplinesAssignment_1_1"


    // $ANTLR start "rule__Spline__StartpAssignment_0_2"
    // InternalDotSplineTypeParser.g:819:1: rule__Spline__StartpAssignment_0_2 : ( rulePoint ) ;
    public final void rule__Spline__StartpAssignment_0_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:823:1: ( ( rulePoint ) )
            // InternalDotSplineTypeParser.g:824:2: ( rulePoint )
            {
            // InternalDotSplineTypeParser.g:824:2: ( rulePoint )
            // InternalDotSplineTypeParser.g:825:3: rulePoint
            {
             before(grammarAccess.getSplineAccess().getStartpPointParserRuleCall_0_2_0()); 
            pushFollow(FOLLOW_2);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getSplineAccess().getStartpPointParserRuleCall_0_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__StartpAssignment_0_2"


    // $ANTLR start "rule__Spline__EndpAssignment_1_2"
    // InternalDotSplineTypeParser.g:834:1: rule__Spline__EndpAssignment_1_2 : ( rulePoint ) ;
    public final void rule__Spline__EndpAssignment_1_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:838:1: ( ( rulePoint ) )
            // InternalDotSplineTypeParser.g:839:2: ( rulePoint )
            {
            // InternalDotSplineTypeParser.g:839:2: ( rulePoint )
            // InternalDotSplineTypeParser.g:840:3: rulePoint
            {
             before(grammarAccess.getSplineAccess().getEndpPointParserRuleCall_1_2_0()); 
            pushFollow(FOLLOW_2);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getSplineAccess().getEndpPointParserRuleCall_1_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__EndpAssignment_1_2"


    // $ANTLR start "rule__Spline__ControlPointsAssignment_2"
    // InternalDotSplineTypeParser.g:849:1: rule__Spline__ControlPointsAssignment_2 : ( rulePoint ) ;
    public final void rule__Spline__ControlPointsAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:853:1: ( ( rulePoint ) )
            // InternalDotSplineTypeParser.g:854:2: ( rulePoint )
            {
            // InternalDotSplineTypeParser.g:854:2: ( rulePoint )
            // InternalDotSplineTypeParser.g:855:3: rulePoint
            {
             before(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_2_0()); 
            pushFollow(FOLLOW_2);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__ControlPointsAssignment_2"


    // $ANTLR start "rule__Spline__ControlPointsAssignment_3_0"
    // InternalDotSplineTypeParser.g:864:1: rule__Spline__ControlPointsAssignment_3_0 : ( rulePoint ) ;
    public final void rule__Spline__ControlPointsAssignment_3_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:868:1: ( ( rulePoint ) )
            // InternalDotSplineTypeParser.g:869:2: ( rulePoint )
            {
            // InternalDotSplineTypeParser.g:869:2: ( rulePoint )
            // InternalDotSplineTypeParser.g:870:3: rulePoint
            {
             before(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_3_0_0()); 
            pushFollow(FOLLOW_2);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_3_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__ControlPointsAssignment_3_0"


    // $ANTLR start "rule__Spline__ControlPointsAssignment_3_1"
    // InternalDotSplineTypeParser.g:879:1: rule__Spline__ControlPointsAssignment_3_1 : ( rulePoint ) ;
    public final void rule__Spline__ControlPointsAssignment_3_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:883:1: ( ( rulePoint ) )
            // InternalDotSplineTypeParser.g:884:2: ( rulePoint )
            {
            // InternalDotSplineTypeParser.g:884:2: ( rulePoint )
            // InternalDotSplineTypeParser.g:885:3: rulePoint
            {
             before(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_3_1_0()); 
            pushFollow(FOLLOW_2);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_3_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__ControlPointsAssignment_3_1"


    // $ANTLR start "rule__Spline__ControlPointsAssignment_3_2"
    // InternalDotSplineTypeParser.g:894:1: rule__Spline__ControlPointsAssignment_3_2 : ( rulePoint ) ;
    public final void rule__Spline__ControlPointsAssignment_3_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:898:1: ( ( rulePoint ) )
            // InternalDotSplineTypeParser.g:899:2: ( rulePoint )
            {
            // InternalDotSplineTypeParser.g:899:2: ( rulePoint )
            // InternalDotSplineTypeParser.g:900:3: rulePoint
            {
             before(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_3_2_0()); 
            pushFollow(FOLLOW_2);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getSplineAccess().getControlPointsPointParserRuleCall_3_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Spline__ControlPointsAssignment_3_2"


    // $ANTLR start "rule__Point__XAssignment_0"
    // InternalDotSplineTypeParser.g:909:1: rule__Point__XAssignment_0 : ( RULE_DOUBLE ) ;
    public final void rule__Point__XAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:913:1: ( ( RULE_DOUBLE ) )
            // InternalDotSplineTypeParser.g:914:2: ( RULE_DOUBLE )
            {
            // InternalDotSplineTypeParser.g:914:2: ( RULE_DOUBLE )
            // InternalDotSplineTypeParser.g:915:3: RULE_DOUBLE
            {
             before(grammarAccess.getPointAccess().getXDOUBLETerminalRuleCall_0_0()); 
            match(input,RULE_DOUBLE,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getXDOUBLETerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__XAssignment_0"


    // $ANTLR start "rule__Point__YAssignment_2"
    // InternalDotSplineTypeParser.g:924:1: rule__Point__YAssignment_2 : ( RULE_DOUBLE ) ;
    public final void rule__Point__YAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:928:1: ( ( RULE_DOUBLE ) )
            // InternalDotSplineTypeParser.g:929:2: ( RULE_DOUBLE )
            {
            // InternalDotSplineTypeParser.g:929:2: ( RULE_DOUBLE )
            // InternalDotSplineTypeParser.g:930:3: RULE_DOUBLE
            {
             before(grammarAccess.getPointAccess().getYDOUBLETerminalRuleCall_2_0()); 
            match(input,RULE_DOUBLE,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getYDOUBLETerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__YAssignment_2"


    // $ANTLR start "rule__Point__ZAssignment_3_1"
    // InternalDotSplineTypeParser.g:939:1: rule__Point__ZAssignment_3_1 : ( RULE_DOUBLE ) ;
    public final void rule__Point__ZAssignment_3_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:943:1: ( ( RULE_DOUBLE ) )
            // InternalDotSplineTypeParser.g:944:2: ( RULE_DOUBLE )
            {
            // InternalDotSplineTypeParser.g:944:2: ( RULE_DOUBLE )
            // InternalDotSplineTypeParser.g:945:3: RULE_DOUBLE
            {
             before(grammarAccess.getPointAccess().getZDOUBLETerminalRuleCall_3_1_0()); 
            match(input,RULE_DOUBLE,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getZDOUBLETerminalRuleCall_3_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__ZAssignment_3_1"


    // $ANTLR start "rule__Point__InputOnlyAssignment_4"
    // InternalDotSplineTypeParser.g:954:1: rule__Point__InputOnlyAssignment_4 : ( ( ExclamationMark ) ) ;
    public final void rule__Point__InputOnlyAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotSplineTypeParser.g:958:1: ( ( ( ExclamationMark ) ) )
            // InternalDotSplineTypeParser.g:959:2: ( ( ExclamationMark ) )
            {
            // InternalDotSplineTypeParser.g:959:2: ( ( ExclamationMark ) )
            // InternalDotSplineTypeParser.g:960:3: ( ExclamationMark )
            {
             before(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 
            // InternalDotSplineTypeParser.g:961:3: ( ExclamationMark )
            // InternalDotSplineTypeParser.g:962:4: ExclamationMark
            {
             before(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 
            match(input,ExclamationMark,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 

            }

             after(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__InputOnlyAssignment_4"

    // Delegated rules


 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x0000000000000042L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000000000380L});
    public static final BitSet FOLLOW_6 = new BitSet(new long[]{0x0000000000000382L});
    public static final BitSet FOLLOW_7 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_8 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_9 = new BitSet(new long[]{0x0000000000000030L});

}