/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot.inspections;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.BytesFormat;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Menu;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;
import org.eclipse.mat.util.VoidProgressListener;

@Icon(value="/META-INF/icons/compare.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/comparingdata.html")
@Menu(value={@Menu.Entry(options="-setop ALL"), @Menu.Entry(options="-mode DIFF_TO_PREVIOUS -prefix -mask \"\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$\" -x java.util.HashMap$Node:key java.util.Hashtable$Entry:key java.util.WeakHashMap$Entry:referent java.util.concurrent.ConcurrentHashMap$Node:key;"), @Menu.Entry(options="-mode DIFF_TO_PREVIOUS -prefix -mask \"\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$|(?<=\\p{javaJavaIdentifierPart}\\[)\\d+(?=\\])\" -x java.util.HashMap$Node:key java.util.Hashtable$Entry:key java.util.WeakHashMap$Entry:referent java.util.concurrent.ConcurrentHashMap$Node:key;"), @Menu.Entry(options="-mode DIFF_TO_PREVIOUS -prefix -mask \"\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$|(?<=\\p{javaJavaIdentifierPart}\\[)\\d+(?=\\])\" -x java.util.HashMap$Node:key java.util.Hashtable$Entry:key java.util.WeakHashMap$Entry:referent java.util.concurrent.ConcurrentHashMap$Node:key; -setop ALL")})
public class CompareTablesQuery
implements IQuery {
    @Argument
    public IStructuredResult[] tables;
    @Argument
    public IQueryContext queryContext;
    @Argument(isMandatory=false)
    public ISnapshot[] snapshots;
    @Argument(isMandatory=false)
    public Mode mode = Mode.ABSOLUTE;
    @Argument(isMandatory=false)
    public Operation setOp = Operation.NONE;
    @Argument(isMandatory=false)
    public int keyColumn = 1;
    @Argument(isMandatory=false)
    public Pattern mask;
    @Argument(isMandatory=false)
    public String replace;
    @Argument(isMandatory=false)
    public boolean prefix;
    @Argument(isMandatory=false)
    public boolean suffix;
    public boolean addrefs = true;
    @Argument(isMandatory=false, flag="x")
    public String[] extraReferences;
    @Argument(isMandatory=false, flag="xfile")
    public File extraReferencesListFile;
    private boolean[] sameSnapshot;
    static final String addressPattern = "\\s@ 0x[0-9a-f]+";
    static final String arrayPattern = "^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$";
    static final String arraySizePattern = "(?<=\\p{javaJavaIdentifierPart}\\[)\\d+(?=\\])";
    static final String simplePattern = "\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$";
    static final String complexPattern = "\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$|(?<=\\p{javaJavaIdentifierPart}\\[)\\d+(?=\\])";

    static {
        Pattern.compile(simplePattern);
        Pattern.compile(complexPattern);
    }

    public IResult execute(IProgressListener listener) throws Exception {
        if (this.tables == null) {
            return null;
        }
        int i = 0;
        while (i < this.tables.length) {
            if (this.tables[i] == null || this.keyColumn > this.tables[i].getColumns().length || this.keyColumn < 1) {
                throw new IllegalArgumentException(MessageUtil.format((String)Messages.CompareTablesQuery_MissingKeyColumn, (Object[])new Object[]{this.keyColumn, i + 1}));
            }
            ++i;
        }
        IStructuredResult base = this.tables[0];
        Column[] baseColumns = base.getColumns();
        Column key = baseColumns[this.keyColumn - 1];
        this.sameSnapshot = new boolean[this.tables.length];
        ISnapshot sn = (ISnapshot)this.queryContext.get(ISnapshot.class, null);
        boolean foundTree = false;
        int i2 = 0;
        while (i2 < this.tables.length) {
            boolean bl = this.sameSnapshot[i2] = this.snapshots[i2] == null || sn.equals(this.snapshots[i2]);
            if (this.tables[i2] instanceof IResultTree) {
                foundTree = true;
            }
            ++i2;
        }
        ArrayList<ComparedColumn> attributes = new ArrayList<ComparedColumn>();
        int i3 = 0;
        while (i3 < baseColumns.length) {
            if (i3 != this.keyColumn - 1) {
                int prevDuplicateCol = -1;
                int k = 0;
                while (k < i3 - 1) {
                    if (baseColumns[i3].getLabel().equals(baseColumns[k].getLabel())) {
                        prevDuplicateCol = k > this.keyColumn - 1 ? k - 1 : k;
                    }
                    ++k;
                }
                int[] indexes = new int[this.tables.length];
                int j = 0;
                while (j < indexes.length) {
                    if (prevDuplicateCol >= 0) {
                        int pc = ((ComparedColumn)attributes.get(prevDuplicateCol)).getColumnIndexes()[j];
                        int ci = this.getColumnIndex(baseColumns[i3].getLabel(), this.tables[j], pc + 1);
                        if (ci == -1) {
                            ci = pc;
                        }
                        indexes[j] = ci;
                    } else {
                        indexes[j] = this.getColumnIndex(baseColumns[i3].getLabel(), this.tables[j], 0);
                    }
                    ++j;
                }
                attributes.add(new ComparedColumn(baseColumns[i3], indexes, true));
            }
            ++i3;
        }
        this.collectExtraRefs();
        return foundTree ? new ComparisonResultTree(this.mergeKeys(null, listener), key, attributes, this.mode, this.setOp) : new ComparisonResultTable(this.mergeKeys(null, listener), key, attributes, this.mode, this.setOp);
    }

    private int getColumnIndex(String name, IStructuredResult table, int colstart) {
        Column[] columns = table.getColumns();
        int i = colstart;
        while (i < columns.length) {
            if (columns[i].getLabel().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String extraKey(int table, Object row) {
        IClass cls;
        String noextra = null;
        if (this.extraReferences == null || this.extraReferences.length == 0) {
            return noextra;
        }
        if (this.snapshots[table] == null) {
            return noextra;
        }
        IContextObject ctx = this.tables[table].getContext(row);
        if (ctx == null) {
            return noextra;
        }
        int objId = ctx.getObjectId();
        if (objId == -1) {
            return noextra;
        }
        IObject obj = null;
        try {
            cls = this.snapshots[table].getClassOf(objId);
        }
        catch (SnapshotException e) {
            return noextra;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.extraReferences;
        int n = this.extraReferences.length;
        int n2 = 0;
        while (n2 < n) {
            block20: {
                String s = stringArray[n2];
                String[] p1 = s.split(":", 2);
                if (p1.length >= 1) {
                    try {
                        if (!cls.doesExtend(p1[0])) break block20;
                        if (obj == null) {
                            obj = this.snapshots[table].getObject(objId);
                        }
                        if (p1.length < 2) {
                            String val = obj.getClassSpecificName();
                            if (val != null) {
                                if (sb.length() > 0) {
                                    sb.append(' ');
                                }
                                sb.append(val);
                            }
                            break block20;
                        }
                        String[] stringArray2 = p1[1].split(",");
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            block21: {
                                Object o;
                                String field = stringArray2[n4];
                                try {
                                    o = obj.resolveValue(field);
                                }
                                catch (SnapshotException e) {
                                    break block21;
                                }
                                String val = o instanceof IObject ? ((IObject)o).getClassSpecificName() : (o != null ? o.toString() : null);
                                if (val != null) {
                                    if (sb.length() > 0) {
                                        sb.append(' ');
                                    }
                                    sb.append(val);
                                }
                            }
                            ++n4;
                        }
                    }
                    catch (SnapshotException snapshotException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return noextra;
    }

    String extraPrefix(int table, Object row) {
        int SMALL_ARRAY_SIZE = 512;
        String noextra = null;
        if (!this.addrefs) {
            return noextra;
        }
        if (this.snapshots[table] == null) {
            return noextra;
        }
        IContextObject ctx = this.tables[table].getContext(row);
        if (ctx == null) {
            return noextra;
        }
        int objId = ctx.getObjectId();
        if (objId == -1) {
            return noextra;
        }
        StringBuilder sb = new StringBuilder();
        try {
            int immdom = this.snapshots[table].getImmediateDominatorId(objId);
            if (immdom >= 0) {
                if (!this.snapshots[table].isArray(immdom)) {
                    IObject immobj = this.snapshots[table].getObject(immdom);
                    for (NamedReference ref : immobj.getOutboundReferences()) {
                        if (ref.getObjectId() != objId) continue;
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(ref.getName());
                    }
                } else {
                    if (this.snapshots[table].getClassOf(immdom).getObjectId() == objId) {
                        sb.append("<class>");
                    }
                    if (this.snapshots[table].getHeapSize(immdom) < 512L) {
                        long objAddress = this.snapshots[table].mapIdToAddress(objId);
                        IObject immobj = this.snapshots[table].getObject(immdom);
                        if (immobj instanceof IObjectArray) {
                            boolean big;
                            IObjectArray heapArray = (IObjectArray)immobj;
                            int length = heapArray.getLength();
                            int step = 65536;
                            int maxarray = 0x100000;
                            int maxattribute = 150;
                            boolean bl = big = length > maxarray;
                            if (big) {
                                length = maxarray;
                            }
                            int i = 0;
                            while (i < length) {
                                long[] l = heapArray.getReferenceArray(i, Math.min(step, length - i));
                                int j = 0;
                                while (j < l.length) {
                                    if (l[j] == objAddress) {
                                        if (sb.length() > 0) {
                                            sb.append(", ");
                                        }
                                        int sl = sb.length();
                                        sb.append('[');
                                        sb.append(i + j);
                                        sb.append(']');
                                        if (sb.length() > maxattribute) {
                                            if (sl > 0) {
                                                --sl;
                                            }
                                            sb.delete(sl, sb.length());
                                            sb.append("...");
                                            big = false;
                                            i = length;
                                            break;
                                        }
                                    }
                                    ++j;
                                }
                                i += step;
                            }
                            if (big && sb.length() > 0) {
                                sb.append(",...");
                            }
                        }
                    }
                }
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return noextra;
    }

    void collectExtraRefs() throws IOException {
        String[] fromFile = this.getLinesFromFile();
        if (fromFile != null && fromFile.length > 0) {
            if (this.extraReferences != null) {
                String[] tmp = new String[fromFile.length + this.extraReferences.length];
                System.arraycopy(fromFile, 0, tmp, 0, fromFile.length);
                System.arraycopy(this.extraReferences, 0, tmp, fromFile.length, this.extraReferences.length);
                this.extraReferences = tmp;
            } else {
                this.extraReferences = fromFile;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getLinesFromFile() throws IOException {
        Charset cs;
        if (this.extraReferencesListFile == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            String encoding = ResourcesPlugin.getEncoding();
            cs = encoding != null ? Charset.forName(encoding) : StandardCharsets.UTF_8;
        }
        catch (UnsupportedCharsetException e) {
            cs = StandardCharsets.UTF_8;
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            FileInputStream fis = new FileInputStream(this.extraReferencesListFile);
            try {
                block22: {
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, cs);
                    try {
                        try (BufferedReader in = new BufferedReader(isr);){
                            String line = null;
                            while ((line = in.readLine()) != null) {
                                result.add(line);
                            }
                        }
                        if (isr == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (isr == null) throw throwable;
                        isr.close();
                        throw throwable;
                    }
                    isr.close();
                }
                if (fis == null) return result.toArray(new String[result.size()]);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return result.toArray(new String[result.size()]);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<ComparedRow> mergeKeys(ComparedRow parent, IProgressListener listener) {
        void var10_13;
        SimpleMonitor sm = new SimpleMonitor(Messages.CompareTablesQuery_Comparing, listener, new int[]{60, 30, 10});
        LinkedHashMap<Object, Object[]> map = new LinkedHashMap<Object, Object[]>();
        int[] sizes = new int[this.tables.length];
        List[] elements = new List[this.tables.length];
        int totalsize = 0;
        int i = 0;
        while (i < this.tables.length) {
            int n;
            IStructuredResult table = this.tables[i];
            if (table instanceof IResultTable) {
                n = parent == null ? ((IResultTable)table).getRowCount() : 0;
            } else if (table instanceof IResultTree) {
                if (parent == null) {
                    elements[i] = ((IResultTree)table).getElements();
                    n = elements[i].size();
                } else {
                    Object treerow = parent.getRows()[i];
                    if (treerow != null && ((IResultTree)table).hasChildren(treerow)) {
                        elements[i] = ((IResultTree)table).getChildren(treerow);
                        n = elements[i].size();
                    } else {
                        n = 0;
                    }
                }
            } else {
                n = 0;
            }
            sizes[i] = n;
            if ((totalsize += n) < 0) {
                totalsize = Integer.MAX_VALUE;
            }
            ++i;
        }
        listener = sm.nextMonitor();
        listener.beginTask(Messages.CompareTablesQuery_Initial, totalsize);
        long sortwork = 0L;
        boolean bl = false;
        while (var10_13 < this.tables.length) {
            listener.subTask(MessageUtil.format((String)Messages.CompareTablesQuery_InitialComparisonForTable, (Object[])new Object[]{(int)(var10_13 + true)}));
            IStructuredResult table = this.tables[var10_13];
            int size = sizes[var10_13];
            List treeRows = table instanceof IResultTree ? elements[var10_13] : null;
            Column c = this.tables[var10_13].getColumns()[this.keyColumn - 1];
            IDecorator id = c.getDecorator();
            HashMap<Object, Integer> lastcache = new HashMap<Object, Integer>();
            int j = 0;
            while (j < size) {
                Object row = table instanceof IResultTable ? ((IResultTable)table).getRow(j) : (table instanceof IResultTree ? treeRows.get(j) : null);
                Object key = table.getColumnValue(row, this.keyColumn - 1);
                Object[] rows = (Object[])map.get(key = this.modifyKey((int)var10_13, id, row, key));
                if (rows == null) {
                    rows = new Object[this.tables.length];
                    map.put(key, rows);
                }
                int ii = 0;
                if (lastcache.containsKey(key)) {
                    ii = (Integer)lastcache.get(key);
                }
                while (rows[ii + var10_13] != null) {
                    if ((ii += this.tables.length) < rows.length) continue;
                    sortwork -= (long)(rows.length * rows.length);
                    int spare = rows.length / this.tables.length / 2;
                    rows = Arrays.copyOf(rows, rows.length + (spare + 1) * this.tables.length);
                    map.put(key, rows);
                    sortwork += (long)(rows.length * rows.length);
                }
                rows[ii + var10_13] = row;
                if (ii > 0) {
                    lastcache.put(key, ii);
                    map.put(new PlaceHolder(key, ii), new Object[0]);
                }
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                listener.worked(1);
                ++j;
            }
            ++var10_13;
        }
        listener.done();
        listener = sm.nextMonitor();
        listener.beginTask(Messages.CompareTablesQuery_Initial, totalsize);
        for (Map.Entry entry : map.entrySet()) {
            Object[] rows = (Object[])entry.getValue();
            if (rows.length > this.tables.length) {
                listener.subTask(MessageUtil.format((String)Messages.CompareTablesQuery_ResolvingDuplicateKey, (Object[])new Object[]{entry.getKey()}));
                if (!this.sortRows(rows, listener)) {
                    int tn = this.tables.length;
                    int total = 0;
                    int maxTableTotal = 0;
                    int maxTable = 0;
                    int i3 = 0;
                    while (i3 < tn) {
                        int t = 0;
                        int j = i3;
                        while (j < rows.length) {
                            if (rows[j] != null) {
                                ++t;
                            }
                            j += tn;
                        }
                        if (t > maxTableTotal) {
                            maxTableTotal = t;
                            maxTable = i3 + 1;
                        }
                        total += t;
                        ++i3;
                    }
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.CompareTablesQuery_IncompleteSorting, (Object[])new Object[]{entry.getKey(), maxTableTotal, maxTable, total}), null);
                }
                listener.worked((int)((long)totalsize * (long)rows.length * (long)rows.length / sortwork));
            }
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        listener.done();
        listener = sm.nextMonitor();
        listener.beginTask(Messages.CompareTablesQuery_BuildingResult, totalsize);
        ArrayList<ComparedRow> arrayList = new ArrayList<ComparedRow>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object[] rows = (Object[])entry.getValue();
            if (key instanceof PlaceHolder) {
                PlaceHolder ph = (PlaceHolder)key;
                rows = (Object[])map.get(ph.key);
                Object[] rows1 = Arrays.copyOfRange(rows, ph.pos, ph.pos + this.tables.length);
                arrayList.add(new ComparedRow(ph.key, rows1));
            } else if (rows.length <= this.tables.length) {
                arrayList.add(new ComparedRow(entry.getKey(), (Object[])entry.getValue()));
            } else {
                Object[] rows1 = Arrays.copyOfRange(rows, 0, this.tables.length);
                arrayList.add(new ComparedRow(entry.getKey(), rows1));
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
        }
        listener.done();
        return arrayList;
    }

    private Object modifyKey(int i, IDecorator id, Object row, Object key) {
        String keystr2;
        String keystr;
        String extrakey = this.extraKey(i, row);
        if (extrakey != null) {
            key = key + " " + extrakey;
        }
        if (this.mask != null && key != null && !(keystr = key.toString()).equals(keystr2 = this.mask.matcher(keystr).replaceAll(this.replace == null ? "" : this.replace))) {
            key = keystr2;
        }
        if (this.prefix || this.suffix) {
            String sfx;
            String pfx;
            if (this.prefix) {
                if (id != null) {
                    pfx = id.prefix(row);
                    if (pfx == null) {
                        pfx = this.extraPrefix(i, row);
                    }
                } else {
                    pfx = this.extraPrefix(i, row);
                }
            } else {
                pfx = null;
            }
            String string = sfx = this.suffix && id != null ? id.suffix(row) : null;
            if (this.mask != null && pfx != null && (pfx = this.mask.matcher(pfx).replaceAll(this.replace == null ? "" : this.replace)).length() == 0) {
                pfx = null;
            }
            if (this.mask != null && sfx != null && (sfx = this.mask.matcher(sfx).replaceAll(this.replace == null ? "" : this.replace)).length() == 0) {
                sfx = null;
            }
            if (pfx != null || sfx != null) {
                key = new ComparedRow(pfx, key, sfx, null);
            }
        }
        return key;
    }

    boolean rowMatches(int table1, Object row1, int table2, Object row2, int matchType) {
        block22: {
            IClass cls1;
            int objectId2;
            int objectId1;
            block23: {
                block21: {
                    block20: {
                        block19: {
                            IContextObject ctx1 = this.tables[table1].getContext(row1);
                            IContextObject ctx2 = this.tables[table2].getContext(row2);
                            if (ctx1 == null && ctx2 == null) {
                                return true;
                            }
                            if (ctx1 == null || ctx2 == null) {
                                return false;
                            }
                            objectId1 = ctx1.getObjectId();
                            objectId2 = ctx2.getObjectId();
                            if (this.sameSnapshot[table1] && this.sameSnapshot[table2] || this.snapshots[table1].equals(this.snapshots[table2])) {
                                return objectId1 == objectId2;
                            }
                            if (objectId1 == -1 && objectId2 == -1) {
                                return true;
                            }
                            if (objectId1 == -1 || objectId2 == -1) {
                                return false;
                            }
                            try {
                                cls1 = this.snapshots[table1].getClassOf(objectId1);
                                IClass cls2 = this.snapshots[table2].getClassOf(objectId2);
                                if (cls1.getName().equals(cls2.getName())) break block19;
                                return false;
                            }
                            catch (SnapshotException e) {
                                return false;
                            }
                        }
                        long addr1 = this.snapshots[table1].mapIdToAddress(objectId1);
                        long addr2 = this.snapshots[table2].mapIdToAddress(objectId2);
                        if (addr1 != addr2) break block20;
                        return true;
                    }
                    boolean skip = false;
                    if (cls1.isArrayType()) {
                        if (cls1 instanceof IPrimitiveArray) {
                            IPrimitiveArray pa = (IPrimitiveArray)((Object)cls1);
                            int type = pa.getType();
                            switch (type) {
                                case 4: 
                                case 6: 
                                case 7: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    skip = true;
                                    break;
                                }
                            }
                        } else if (cls1 instanceof IObjectArray) {
                            skip = true;
                        }
                    }
                    if (matchType < 1 || skip) break block21;
                    String val1 = this.snapshots[table1].getObject(objectId1).getClassSpecificName();
                    String val2 = this.snapshots[table2].getObject(objectId2).getClassSpecificName();
                    if (val1 != null) {
                        return val1.equals(val2);
                    }
                    if (val2 == null) break block21;
                    return false;
                }
                if (matchType < 2) break block22;
                if (this.snapshots[table1].getRetainedHeapSize(objectId1) <= this.snapshots[table1].getHeapSize(objectId1) || this.snapshots[table1].getRetainedHeapSize(objectId1) != this.snapshots[table2].getRetainedHeapSize(objectId2)) break block23;
                return true;
            }
            long MINARRAYMATCHSIZE = 400L;
            if (!(cls1 instanceof IPrimitiveArray) || this.snapshots[table1].getHeapSize(objectId1) != this.snapshots[table2].getHeapSize(objectId2) || this.snapshots[table1].getHeapSize(objectId1) < 400L) break block22;
            return true;
        }
        return false;
    }

    boolean sortRows(Object[] rows, IProgressListener listener) {
        int MAXWORK = 50000000;
        int passes = 3;
        int rn = rows.length;
        int tn = this.tables.length;
        int n = rn / tn;
        Object[] queue = new Object[n];
        boolean[] matched = new boolean[rows.length];
        int counter = 0;
        int i = 1;
        while (i < tn) {
            int q1 = 0;
            int q2 = 0;
            int l = 0;
            while (l < n) {
                Object o = rows[l * tn + i];
                if (o != null) {
                    queue[q2++] = o;
                    rows[l * tn + i] = null;
                }
                ++l;
            }
            int j = 0;
            while (j < n) {
                block29: {
                    if (counter > 50000000) break;
                    int pass = 0;
                    while (pass < passes) {
                        int k = 0;
                        while (k < i) {
                            Object rowPrev = rows[j * tn + k];
                            if (rowPrev != null) {
                                int l2 = q1;
                                while (l2 < q2) {
                                    if (++counter % 10000 == 0 && listener.isCanceled()) {
                                        throw new IProgressListener.OperationCanceledException();
                                    }
                                    Object rowThis = queue[l2];
                                    if (rowThis == null) {
                                        if (l2 == q1) {
                                            ++q1;
                                        }
                                    } else if (this.rowMatches(i, rowThis, k, rowPrev, pass)) {
                                        matched[j * tn + i] = true;
                                        matched[j * tn + k] = true;
                                        rows[j * tn + i] = rowThis;
                                        queue[l2] = null;
                                        if (l2 == q2 - 1) {
                                            --q2;
                                        }
                                        break block29;
                                    }
                                    ++l2;
                                }
                            }
                            ++k;
                        }
                        ++pass;
                    }
                    rows[j * tn + i] = null;
                }
                ++j;
            }
            l = 0;
            int lq = q1;
            while (l < n && lq < q2) {
                Object o = rows[l * tn + i];
                if (o == null) {
                    while (lq < q2) {
                        Object q;
                        if ((q = queue[lq++]) == null) continue;
                        rows[l * tn + i] = q;
                        break;
                    }
                }
                ++l;
            }
            ++i;
        }
        if (counter > 50000000) {
            return false;
        }
        i = 1;
        while (i < tn) {
            int j = 0;
            while (j < n) {
                if (counter > 50000000) {
                    return false;
                }
                int pass = 0;
                while (pass < passes) {
                    int k = 0;
                    while (k < i) {
                        Object rowPrev;
                        if (!matched[j * tn + k] && (rowPrev = rows[j * tn + k]) != null) {
                            int l = 0;
                            while (l < n) {
                                Object rowThis;
                                if (++counter % 10000 == 0 && listener.isCanceled()) {
                                    throw new IProgressListener.OperationCanceledException();
                                }
                                if (!matched[l * tn + i] && (rowThis = rows[l * tn + i]) != null && this.rowMatches(i, rowThis, k, rowPrev, 0)) {
                                    int m = 0;
                                    while (m < n) {
                                        if (!matched[m * tn + i] && !matched[m * tn + k]) {
                                            Object oldThis = rows[m * tn + i];
                                            rows[m * tn + i] = rowThis;
                                            rows[l * tn + i] = oldThis;
                                            matched[m * tn + i] = true;
                                            Object oldPrev = rows[m * tn + k];
                                            rows[m * tn + k] = rowPrev;
                                            rows[j * tn + i] = oldPrev;
                                            matched[m * tn + k] = true;
                                        }
                                        ++m;
                                    }
                                }
                                ++l;
                            }
                        }
                        ++k;
                    }
                    ++pass;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static class ComparedColumn {
        Column description;
        int[] columnIndexes;
        boolean displayed;

        public ComparedColumn(Column description, int[] columnIndexes, boolean displayed) {
            this.displayed = displayed;
            this.description = description;
            this.columnIndexes = columnIndexes;
        }

        public Column getDescription() {
            return this.description;
        }

        public void setDescription(Column description) {
            this.description = description;
        }

        public int[] getColumnIndexes() {
            return this.columnIndexes;
        }

        public void setColumnIndexes(int[] columnIndexes) {
            this.columnIndexes = columnIndexes;
        }

        public boolean isDisplayed() {
            return this.displayed;
        }

        public void setDisplayed(boolean displayed) {
            this.displayed = displayed;
        }
    }

    static class ComparedRow {
        Object key;
        private String prefix;
        private String suffix;
        Object[] rows;

        public ComparedRow(Object key, Object[] rows) {
            if (key instanceof ComparedRow) {
                ComparedRow cr = (ComparedRow)key;
                this.key = cr.key;
                this.prefix = cr.prefix;
                this.suffix = cr.suffix;
            } else {
                this.key = key;
            }
            this.rows = rows;
        }

        public ComparedRow(String prefix, Object key, String suffix, Object[] rows) {
            this.prefix = prefix;
            this.key = key;
            this.suffix = suffix;
            this.rows = rows;
        }

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object key) {
            this.key = key;
        }

        public Object[] getRows() {
            return this.rows;
        }

        public void setRows(Object[] rows) {
            this.rows = rows;
        }

        String getPrefix() {
            return this.prefix;
        }

        void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        String getSuffix() {
            return this.suffix;
        }

        void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComparedRow other = (ComparedRow)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
                return false;
            }
            return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
        }

        public String toString() {
            String p1 = this.prefix != null ? "(" + this.prefix + ") " : "";
            String s1 = this.suffix != null ? " (" + this.suffix + ")" : "";
            return String.valueOf(p1) + this.key + s1 + ":" + Arrays.toString(this.rows);
        }
    }

    public class ComparisonResultTable
    extends TableComparisonResult
    implements IResultTable {
        public ComparisonResultTable(List<ComparedRow> rows, Column key, List<ComparedColumn> comparedColumns, Mode mode, Operation setOp) {
            super(rows, key, comparedColumns, mode, setOp);
        }

        public Object getRow(int rowId) {
            return this.rows.get(rowId);
        }

        public int getRowCount() {
            return this.rows.size();
        }
    }

    public class ComparisonResultTree
    extends TableComparisonResult
    implements IResultTree {
        public ComparisonResultTree(List<ComparedRow> rows, Column key, List<ComparedColumn> comparedColumns, Mode mode, Operation setOp) {
            super(rows, key, comparedColumns, mode, setOp);
        }

        public List<?> getElements() {
            return this.rows;
        }

        public boolean hasChildren(Object element) {
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length) {
                Object treerow;
                IStructuredResult table = CompareTablesQuery.this.tables[i];
                if (table instanceof IResultTree && (treerow = ((ComparedRow)element).getRows()[i]) != null && ((IResultTree)table).hasChildren(treerow)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public List<?> getChildren(Object parent) {
            return CompareTablesQuery.this.mergeKeys((ComparedRow)parent, (IProgressListener)new VoidProgressListener());
        }
    }

    static enum DeltaEncoding {
        EXACT,
        GE,
        LE,
        APPROX;

    }

    private static class DeltaRetainedBytesFormat
    extends BytesFormat {
        private static final long serialVersionUID = 1L;
        private long SPECIAL = 1000000000000000L;
        private long SPECIAL2 = this.SPECIAL * 2L;
        final Filter.ValueConverter converter = new DeltaRetainedConverter();

        private long encodege(long l) {
            if (l >= this.SPECIAL) {
                return this.SPECIAL - 1L + this.SPECIAL2;
            }
            if (l < -this.SPECIAL) {
                return this.encodeun(l);
            }
            return l + this.SPECIAL2;
        }

        private long encodele(long l) {
            if (l >= this.SPECIAL) {
                return this.encodeun(l);
            }
            if (l < -this.SPECIAL) {
                return -this.SPECIAL - this.SPECIAL2;
            }
            return l - this.SPECIAL2;
        }

        private long encodeun(long l) {
            if (l >= 0L) {
                if (l >= Long.MAX_VALUE - this.SPECIAL - this.SPECIAL2) {
                    return Long.MAX_VALUE;
                }
                return l + this.SPECIAL2 + this.SPECIAL;
            }
            if (l <= Long.MIN_VALUE + this.SPECIAL + this.SPECIAL2) {
                return Long.MIN_VALUE;
            }
            return l - this.SPECIAL2 - this.SPECIAL;
        }

        public DeltaRetainedBytesFormat(Format encapsulatedNumberFormat, Format encapsulatedDecimalFormat) {
            super(encapsulatedNumberFormat, encapsulatedDecimalFormat);
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            Number v = obj instanceof Bytes ? (Number)((Bytes)obj).getValue() : (Number)((Number)obj);
            if (v.longValue() >= this.SPECIAL) {
                if (v.longValue() >= this.SPECIAL + this.SPECIAL2) {
                    String approx = Messages.CompareTablesQuery_APPROX;
                    toAppendTo.append(approx);
                    return super.format((Object)new Bytes(v.longValue() - this.SPECIAL - this.SPECIAL2), toAppendTo, pos);
                }
                String approx = Messages.CompareTablesQuery_GE;
                toAppendTo.append(approx);
                return super.format((Object)new Bytes(v.longValue() - this.SPECIAL2), toAppendTo, pos);
            }
            if (v.longValue() < -this.SPECIAL) {
                if (v.longValue() < -this.SPECIAL - this.SPECIAL2) {
                    String approx = Messages.CompareTablesQuery_APPROX;
                    toAppendTo.append(approx);
                    return super.format((Object)new Bytes(v.longValue() + this.SPECIAL + this.SPECIAL2), toAppendTo, pos);
                }
                String approx = Messages.CompareTablesQuery_LE;
                toAppendTo.append(approx);
                return super.format((Object)new Bytes(v.longValue() + this.SPECIAL2), toAppendTo, pos);
            }
            return super.format((Object)new Bytes(v.longValue()), toAppendTo, pos);
        }

        public Object parseObject(String source, ParsePosition pos) {
            String[] stringArray = new String[]{Messages.CompareTablesQuery_GE, Messages.CompareTablesQuery_LE, Messages.CompareTablesQuery_APPROX};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String match = stringArray[n2];
                if (source.regionMatches(pos.getIndex(), match, 0, match.length())) {
                    int pi = pos.getIndex();
                    pos.setIndex(pi + match.length());
                    Object ret = super.parseObject(source, pos);
                    if (ret != null) {
                        if (ret instanceof Bytes) {
                            long v = ((Bytes)ret).getValue();
                            if (match.equals(Messages.CompareTablesQuery_GE)) {
                                v = this.encodege(v);
                            } else if (match.equals(Messages.CompareTablesQuery_LE)) {
                                v = this.encodele(v);
                            } else if (match.equals(Messages.CompareTablesQuery_APPROX)) {
                                v = this.encodeun(v);
                            }
                            return new Bytes(v);
                        }
                        if (ret instanceof Number) {
                            long v = ((Number)ret).longValue();
                            if (match.equals(Messages.CompareTablesQuery_GE)) {
                                v = this.encodege(v);
                            } else if (match.equals(Messages.CompareTablesQuery_LE)) {
                                v = this.encodele(v);
                            } else if (match.equals(Messages.CompareTablesQuery_APPROX)) {
                                v = this.encodeun(v);
                            }
                            return new Bytes(v);
                        }
                    }
                    pos.setErrorIndex(pi + match.length());
                    pos.setIndex(pi);
                    ret = null;
                    return ret;
                }
                ++n2;
            }
            Object ret = super.parseObject(source, pos);
            return ret;
        }

        private class DeltaRetainedConverter
        implements Filter.ValueConverter,
        Serializable {
            private static final long serialVersionUID = 1L;

            private DeltaRetainedConverter() {
            }

            public double convert(double source) {
                if (source >= (double)(DeltaRetainedBytesFormat.this.SPECIAL + DeltaRetainedBytesFormat.this.SPECIAL2)) {
                    return source - (double)DeltaRetainedBytesFormat.this.SPECIAL - (double)DeltaRetainedBytesFormat.this.SPECIAL2;
                }
                if (source >= (double)DeltaRetainedBytesFormat.this.SPECIAL) {
                    return source - (double)DeltaRetainedBytesFormat.this.SPECIAL2;
                }
                if (source < (double)(-DeltaRetainedBytesFormat.this.SPECIAL - DeltaRetainedBytesFormat.this.SPECIAL2)) {
                    return source + (double)DeltaRetainedBytesFormat.this.SPECIAL + (double)DeltaRetainedBytesFormat.this.SPECIAL2;
                }
                if (source < (double)(-DeltaRetainedBytesFormat.this.SPECIAL)) {
                    return source + (double)DeltaRetainedBytesFormat.this.SPECIAL2;
                }
                return source;
            }
        }
    }

    public static enum Mode {
        ABSOLUTE("ABSOLUTE"),
        DIFF_TO_FIRST("DIFF_TO_FIRST"),
        DIFF_TO_PREVIOUS("DIFF_TO_PREVIOUS"),
        DIFF_RATIO_TO_FIRST("DIFF_RATIO_TO_FIRST"),
        DIFF_RATIO_TO_PREVIOUS("DIFF_RATIO_TO_PREVIOUS");

        String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum Operation {
        NONE,
        ALL,
        INTERSECTION,
        UNION,
        SYMMETRIC_DIFFERENCE,
        DIFFERENCE,
        REVERSE_DIFFERENCE;

    }

    static class PlaceHolder {
        Object key;
        int pos;

        PlaceHolder(Object key, int pos) {
            this.key = key;
            this.pos = pos;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + this.pos;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlaceHolder other = (PlaceHolder)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.pos == other.pos;
        }
    }

    public class TableComparisonResult
    implements IStructuredResult,
    IIconProvider {
        private Column key;
        protected List<ComparedRow> rows;
        private List<ComparedColumn> comparedColumns;
        private List<ComparedColumn> displayedColumns;
        private Column[] columns;
        private Mode mode;
        private Operation setOp;

        public TableComparisonResult(List<ComparedRow> rows, Column key, List<ComparedColumn> comparedColumns, Mode mode, Operation setOp) {
            this.key = key;
            this.mode = mode;
            this.rows = rows;
            this.comparedColumns = comparedColumns;
            this.updateColumns();
            this.setMode(mode);
            this.setOp = setOp;
        }

        public List<ComparedColumn> getComparedColumns() {
            return this.comparedColumns;
        }

        public void setComparedColumns(List<ComparedColumn> comparedColumns) {
            this.comparedColumns = comparedColumns;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            ComparedRow cr = (ComparedRow)row;
            if (columnIndex == 0) {
                return cr.getKey();
            }
            int subCols = this.mode == Mode.DIFF_RATIO_TO_FIRST || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS ? CompareTablesQuery.this.tables.length + CompareTablesQuery.this.tables.length - 1 : CompareTablesQuery.this.tables.length;
            int comparedColumnIdx = (columnIndex - 1) / subCols;
            int tableIdx = (columnIndex - 1) % subCols;
            if (tableIdx == 0) {
                return this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx);
            }
            switch (this.mode) {
                case ABSOLUTE: {
                    return this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx);
                }
                case DIFF_TO_FIRST: {
                    return this.getDiffToPrevious(cr, columnIndex, comparedColumnIdx, tableIdx, 0, false);
                }
                case DIFF_TO_PREVIOUS: {
                    return this.getDiffToPrevious(cr, columnIndex, comparedColumnIdx, tableIdx, tableIdx - 1, false);
                }
                case DIFF_RATIO_TO_FIRST: {
                    return this.getDiffToPrevious(cr, columnIndex, comparedColumnIdx, (tableIdx + 1) / 2, 0, tableIdx % 2 == 0);
                }
                case DIFF_RATIO_TO_PREVIOUS: {
                    return this.getDiffToPrevious(cr, columnIndex, comparedColumnIdx, (tableIdx + 1) / 2, (tableIdx + 1) / 2 - 1, tableIdx % 2 == 0);
                }
            }
            return null;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public IContextObject getContext(Object row) {
            IContextObject ret = null;
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length && ret == null) {
                ret = this.getContextFromTable(i, row);
                ++i;
            }
            return ret;
        }

        public ResultMetaData getResultMetaData() {
            ResultMetaData.Builder bb = new ResultMetaData.Builder();
            int previous = -1;
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length) {
                if (CompareTablesQuery.this.sameSnapshot[i]) {
                    if (this.setOp != Operation.NONE && previous >= 0) {
                        int op = 0;
                        while (op < 5) {
                            if (!(this.setOp == Operation.INTERSECTION && op != 0 || this.setOp == Operation.UNION && op != 1 || this.setOp == Operation.SYMMETRIC_DIFFERENCE && op != 2 || this.setOp == Operation.DIFFERENCE && op != 3 || this.setOp == Operation.REVERSE_DIFFERENCE && op != 4)) {
                                String title1;
                                final int op1 = op;
                                final LinkedList<Integer> toDo = new LinkedList<Integer>();
                                if (this.mode == Mode.ABSOLUTE) {
                                    toDo.add(previous);
                                    if (op == 4) {
                                        int k = previous + 1;
                                        while (k <= i) {
                                            if (CompareTablesQuery.this.sameSnapshot[k]) {
                                                toDo.addFirst(k);
                                            }
                                            ++k;
                                        }
                                    } else {
                                        int k = previous + 1;
                                        while (k <= i) {
                                            if (CompareTablesQuery.this.sameSnapshot[k]) {
                                                toDo.add(k);
                                            }
                                            ++k;
                                        }
                                    }
                                } else if (op == 4) {
                                    toDo.add(i);
                                    toDo.add(previous);
                                } else {
                                    toDo.add(previous);
                                    toDo.add(i);
                                }
                                if (toDo.size() == 2) {
                                    switch (op) {
                                        case 0: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 1: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_UnionOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 2: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        default: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                    }
                                } else {
                                    String soFar;
                                    switch (op) {
                                        case 0: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 1: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_UnionFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 2: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        default: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                        }
                                    }
                                    int t = 2;
                                    while (t < toDo.size() - 1) {
                                        switch (op) {
                                            case 0: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                                break;
                                            }
                                            case 1: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_UnionMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                                break;
                                            }
                                            case 2: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                                break;
                                            }
                                            default: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            }
                                        }
                                        ++t;
                                    }
                                    t = toDo.size() - 1;
                                    switch (op) {
                                        case 0: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            break;
                                        }
                                        case 1: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_UnionLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            break;
                                        }
                                        case 2: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            break;
                                        }
                                        default: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                        }
                                    }
                                }
                                ContextProvider prov2 = new ContextProvider(title1){
                                    private static final String EMPTY_QUERY = "SELECT * FROM OBJECTS 0 WHERE false";

                                    public URL getIcon() {
                                        switch (op1) {
                                            case 0: {
                                                return Icons.getURL("set_intersection.gif");
                                            }
                                            case 1: {
                                                return Icons.getURL("set_union.gif");
                                            }
                                            case 2: {
                                                return Icons.getURL("set_symmetric_difference.gif");
                                            }
                                            case 3: {
                                                return Icons.getURL("set_differenceA.gif");
                                            }
                                            case 4: {
                                                return Icons.getURL("set_differenceB.gif");
                                            }
                                        }
                                        return null;
                                    }

                                    public IContextObject getContext(final Object row) {
                                        int nullContexts = 0;
                                        int i = 0;
                                        while (i < toDo.size()) {
                                            if (TableComparisonResult.this.getContextFromTable(i, row) != null) break;
                                            ++nullContexts;
                                            ++i;
                                        }
                                        if (nullContexts == toDo.size()) {
                                            return null;
                                        }
                                        final IContextObject cb = TableComparisonResult.this.getContextFromTable(nullContexts, row);
                                        return new IContextObjectSet(){

                                            public int getObjectId() {
                                                return cb.getObjectId();
                                            }

                                            public String getOQL() {
                                                LinkedList toDo2 = new LinkedList(toDo);
                                                switch (op1) {
                                                    case 0: {
                                                        String resultOQL0 = null;
                                                        Iterator iterator = toDo2.iterator();
                                                        while (iterator.hasNext()) {
                                                            int j = (Integer)iterator.next();
                                                            IContextObject cb32 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb32 == null) {
                                                                return 1.EMPTY_QUERY;
                                                            }
                                                            String oql = this.getOQLfromContext(cb32);
                                                            if (oql != null) {
                                                                if (resultOQL0 == null) {
                                                                    resultOQL0 = oql;
                                                                    continue;
                                                                }
                                                                resultOQL0 = this.OQLintersection(resultOQL0, oql);
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        return resultOQL0;
                                                    }
                                                    case 1: {
                                                        StringBuilder resultOQL = new StringBuilder();
                                                        Iterator cb32 = toDo2.iterator();
                                                        while (cb32.hasNext()) {
                                                            int j = (Integer)cb32.next();
                                                            IContextObject cb2 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb2 == null) continue;
                                                            String oql = this.getOQLfromContext(cb2);
                                                            if (oql != null) {
                                                                OQL.union(resultOQL, oql);
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        return this.OQLdistinct(resultOQL.toString());
                                                    }
                                                    case 2: {
                                                        String resultOQL2 = null;
                                                        Iterator cb2 = toDo2.iterator();
                                                        while (cb2.hasNext()) {
                                                            int j = (Integer)cb2.next();
                                                            IContextObject cb4 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb4 == null) continue;
                                                            String oql = this.getOQLfromContext(cb4);
                                                            if (oql != null) {
                                                                if (resultOQL2 == null) {
                                                                    resultOQL2 = oql;
                                                                    continue;
                                                                }
                                                                StringBuilder sb = new StringBuilder();
                                                                sb.append(this.OQLexcept(resultOQL2, oql));
                                                                OQL.union(sb, this.OQLexcept(oql, resultOQL2));
                                                                resultOQL2 = sb.toString();
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        return resultOQL2;
                                                    }
                                                    case 3: 
                                                    case 4: {
                                                        String resultOQL3 = null;
                                                        Iterator iterator = toDo2.iterator();
                                                        while (iterator.hasNext()) {
                                                            int j = (Integer)iterator.next();
                                                            IContextObject cb5 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb5 == null) {
                                                                if (resultOQL3 != null) continue;
                                                                return 1.EMPTY_QUERY;
                                                            }
                                                            String oql = this.getOQLfromContext(cb5);
                                                            if (oql != null) {
                                                                if (resultOQL3 == null) {
                                                                    resultOQL3 = oql;
                                                                    continue;
                                                                }
                                                                resultOQL3 = this.OQLexcept(resultOQL3, oql);
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        return resultOQL3;
                                                    }
                                                }
                                                return null;
                                            }

                                            private String OQLexcept(String oql1, String oql2) {
                                                oql1 = this.OQLobjectQuery(oql1) ? "SELECT * FROM OBJECTS (" + oql1 + ")" + " WHERE @objectId in (" + oql2 + ") = false" : "SELECT s as \"\" FROM OBJECTS (" + oql1 + ") s" + " WHERE s in (" + oql2 + ") = false";
                                                return oql1;
                                            }

                                            private String OQLintersection(String oql1, String oql2) {
                                                oql1 = this.OQLobjectQuery(oql1) ? "SELECT * FROM OBJECTS (" + oql1 + ")" + " WHERE @objectId in (" + oql2 + ")" : "SELECT s as \"\" FROM OBJECTS (" + oql1 + ") s" + " WHERE s in (" + oql2 + ")";
                                                return oql1;
                                            }

                                            private String OQLdistinct(String oql) {
                                                if (this.OQLobjectQuery(oql)) {
                                                    return "SELECT DISTINCT OBJECTS @objectId FROM OBJECTS (" + oql + ")";
                                                }
                                                return "SELECT DISTINCT s as \"\" FROM OBJECTS (" + oql + ") s";
                                            }

                                            public boolean OQLobjectQuery(String oql) {
                                                return (oql = oql.toLowerCase(Locale.ENGLISH).replaceAll("\\s+", " ")).startsWith("select * ") || oql.startsWith("select distinct objects ") || oql.startsWith("select as retained set ");
                                            }

                                            public int[] getObjectIds() {
                                                ArrayInt bb;
                                                LinkedList toDo2 = new LinkedList(toDo);
                                                int j = (Integer)toDo2.remove();
                                                IContextObject cb2 = TableComparisonResult.this.getContextFromTable(j, row);
                                                int[] b = this.getObjectIdsFromContext(cb2);
                                                if (b == null) {
                                                    bb = new ArrayInt();
                                                } else {
                                                    bb = new ArrayInt(b);
                                                    bb.sort();
                                                }
                                                while (!toDo2.isEmpty()) {
                                                    ArrayInt aa;
                                                    j = (Integer)toDo2.remove();
                                                    IContextObject ca = TableComparisonResult.this.getContextFromTable(j, row);
                                                    int[] a = this.getObjectIdsFromContext(ca);
                                                    if (a == null) {
                                                        aa = new ArrayInt();
                                                    } else {
                                                        aa = new ArrayInt(a);
                                                        aa.sort();
                                                    }
                                                    switch (op1) {
                                                        case 0: {
                                                            bb = this.intersectionArray(aa, bb);
                                                            break;
                                                        }
                                                        case 1: {
                                                            bb = this.unionArray(aa, bb);
                                                            break;
                                                        }
                                                        case 2: {
                                                            bb = this.symdiffArray(aa, bb);
                                                            break;
                                                        }
                                                        case 3: 
                                                        case 4: {
                                                            bb = this.diffArray(aa, bb);
                                                        }
                                                    }
                                                }
                                                int[] res = bb.toArray();
                                                return res;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt unionArray(ArrayInt aa, ArrayInt bb) {
                                                if (aa.size() == 0) {
                                                    return bb;
                                                }
                                                if (bb.size() == 0) {
                                                    return aa;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl17
                                                {
                                                    cc.add(aa.get(j));
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        cc.add(bb.get(i));
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            ++j;
                                                        }
                                                        ++i;
lbl17:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                while (j < aa.size()) {
                                                    cc.add(aa.get(j));
                                                    ++j;
                                                }
                                                return cc;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt diffArray(ArrayInt aa, ArrayInt bb) {
                                                if (bb.size() == 0) {
                                                    return bb;
                                                }
                                                if (aa.size() == 0) {
                                                    return bb;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl17
                                                {
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            ++j;
                                                        } else {
                                                            cc.add(bb.get(i));
                                                        }
                                                        ++i;
lbl17:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                return cc;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt intersectionArray(ArrayInt aa, ArrayInt bb) {
                                                if (aa.size() == 0) {
                                                    return aa;
                                                }
                                                if (bb.size() == 0) {
                                                    return bb;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl16
                                                {
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            cc.add(bb.get(i));
                                                            ++j;
                                                        }
                                                        ++i;
lbl16:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                return cc;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt symdiffArray(ArrayInt aa, ArrayInt bb) {
                                                if (aa.size() == 0) {
                                                    return bb;
                                                }
                                                if (bb.size() == 0) {
                                                    return aa;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl18
                                                {
                                                    cc.add(aa.get(j));
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            ++j;
                                                        } else {
                                                            cc.add(bb.get(i));
                                                        }
                                                        ++i;
lbl18:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                while (j < aa.size()) {
                                                    cc.add(aa.get(j));
                                                    ++j;
                                                }
                                                return cc;
                                            }

                                            private int[] getObjectIdsFromContext(IContextObject b) {
                                                int id;
                                                Object bobjs = b instanceof IContextObjectSet ? ((IContextObjectSet)b).getObjectIds() : (Object)(b != null ? (Object)((id = b.getObjectId()) >= 0 ? new int[]{id} : null) : null);
                                                return bobjs;
                                            }

                                            private String getOQLfromContext(IContextObject b) {
                                                int id;
                                                String oql = b instanceof IContextObjectSet ? ((IContextObjectSet)b).getOQL() : (b != null ? ((id = b.getObjectId()) >= 0 ? OQL.forObjectId(id) : null) : null);
                                                return oql;
                                            }
                                        };
                                    }
                                };
                                bb.addContext(prov2);
                            }
                            ++op;
                        }
                    }
                    if (this.setOp == Operation.NONE || this.setOp == Operation.ALL) {
                        final int i2 = i;
                        String title = MessageUtil.format((String)Messages.CompareTablesQuery_Table, (Object[])new Object[]{i + 1});
                        ContextProvider prov = new ContextProvider(title){

                            public IContextObject getContext(Object row) {
                                return TableComparisonResult.this.getContextFromTable(i2, row);
                            }
                        };
                        bb.addContext(prov);
                    }
                    if (this.mode == Mode.DIFF_TO_PREVIOUS || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS || previous == -1) {
                        previous = i;
                    }
                }
                ++i;
            }
            return bb.build();
        }

        private Object getAbsoluteValue(ComparedRow cr, int comparedColumnIdx, int tableIdx) {
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            return CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
        }

        private Object percentDivide(Number d1, Number d2) {
            if (d1.doubleValue() == 0.0 && d2.doubleValue() == 0.0 && (d2 instanceof Integer || d2 instanceof Long || d2 instanceof Byte || d2 instanceof Short)) {
                return 0.0;
            }
            return d1.doubleValue() / d2.doubleValue();
        }

        private Object valueConvert(Object value, int tableIdx, int comparedColumnIdx) {
            if (value == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return value;
            }
            Filter.ValueConverter vc = (Filter.ValueConverter)CompareTablesQuery.this.tables[tableIdx].getColumns()[tableColumnIdx].getData(Filter.ValueConverter.class);
            if (vc != null) {
                double v0;
                double v;
                if (value instanceof Bytes) {
                    double v02 = ((Bytes)value).getValue();
                    double v2 = vc.convert(v02);
                    if (v2 != v02) {
                        value = new Bytes(Double.valueOf(v2).longValue());
                    }
                } else if (value instanceof Number && (v = vc.convert(v0 = ((Number)value).doubleValue())) != v0) {
                    long v1;
                    value = value instanceof Long ? (Number)((double)(v1 = (long)v) == v ? (Number)v1 : (Number)v) : (Number)(value instanceof Integer ? (Number)((double)(v1 = (int)v) == v ? (Number)v1 : (Number)v) : (Number)(value instanceof Short ? (Number)((double)(v1 = (short)v) == v ? (Number)v1 : (Number)v) : (Number)(value instanceof Byte ? (Number)((double)(v1 = (byte)v) == v ? (Number)v1 : (Number)v) : (Number)(value instanceof Double ? (Number)((v1 = v) == v ? Double.valueOf(v1) : Double.valueOf(v)) : (Number)(value instanceof Float ? (Number)((double)(v1 = (float)v) == v ? (Number)Float.valueOf(v1) : (Number)v) : (Number)v)))));
                }
            }
            return value;
        }

        private DeltaEncoding approxValue(Object value, Object value2, int tableIdx, int comparedColumnIdx) {
            if (value != null && !value.equals(value2)) {
                int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
                if (tableColumnIdx == -1) {
                    return DeltaEncoding.EXACT;
                }
                try {
                    String fv = CompareTablesQuery.this.tables[tableIdx].getColumns()[tableColumnIdx].getFormatter().format(value);
                    if (fv != null) {
                        if (fv.startsWith(Messages.RetainedSizeDerivedData_Approximate)) {
                            return DeltaEncoding.GE;
                        }
                        if (fv.startsWith(Messages.CompareTablesQuery_GE)) {
                            return DeltaEncoding.GE;
                        }
                        if (fv.startsWith("<= ")) {
                            return DeltaEncoding.LE;
                        }
                        if (fv.startsWith(Messages.CompareTablesQuery_LE)) {
                            return DeltaEncoding.LE;
                        }
                        if (fv.startsWith(Messages.CompareTablesQuery_APPROX)) {
                            return DeltaEncoding.APPROX;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return DeltaEncoding.EXACT;
        }

        private Object getDiffToPrevious(ComparedRow cr, int columnIdx, int comparedColumnIdx, int tableIdx, int prevTableIdx, boolean ratio) {
            boolean returnBytes;
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            Object value = CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
            Object previousTableValue = this.getAbsoluteValue(cr, comparedColumnIdx, prevTableIdx);
            Object value2 = this.valueConvert(value, tableIdx, comparedColumnIdx);
            DeltaEncoding approxValue = this.approxValue(value, value2, tableIdx, comparedColumnIdx);
            value = value2;
            value2 = this.valueConvert(previousTableValue, prevTableIdx, comparedColumnIdx);
            DeltaEncoding approxPreviousValue = this.approxValue(previousTableValue, value2, prevTableIdx, comparedColumnIdx);
            previousTableValue = value2;
            if (value == null && previousTableValue == null) {
                return null;
            }
            if (value == null && (previousTableValue instanceof Number || previousTableValue instanceof Bytes)) {
                return null;
            }
            if ((value instanceof Number || value instanceof Bytes) && previousTableValue == null) {
                if (ratio) {
                    return null;
                }
                if (approxValue != DeltaEncoding.EXACT) {
                    if (value instanceof Bytes) {
                        return this.encodeResult(((Bytes)value).getValue(), true, approxValue, approxPreviousValue, columnIdx);
                    }
                    return this.encodeResult(value, false, approxValue, approxPreviousValue, columnIdx);
                }
                return value;
            }
            boolean bl = returnBytes = value instanceof Bytes && previousTableValue instanceof Bytes;
            if (value instanceof Bytes) {
                value = ((Bytes)value).getValue();
            }
            if (previousTableValue instanceof Bytes) {
                previousTableValue = ((Bytes)previousTableValue).getValue();
            }
            if (value instanceof Number && previousTableValue instanceof Number) {
                Object ret = this.computeDiff((Number)previousTableValue, (Number)value);
                if (ratio && ret instanceof Number) {
                    return this.percentDivide((Number)ret, (Number)previousTableValue);
                }
                return this.encodeResult(ret, returnBytes, approxValue, approxPreviousValue, columnIdx);
            }
            if (ratio) {
                return null;
            }
            if (previousTableValue == null || !previousTableValue.equals(value)) {
                return value;
            }
            return null;
        }

        private Object encodeResult(Object ret, boolean returnBytes, DeltaEncoding approxValue, DeltaEncoding approxPreviousValue, int columnIdx) {
            if (returnBytes || ret instanceof Long) {
                long val = ((Number)ret).longValue();
                Format fmt = this.columns[columnIdx].getFormatter();
                if (fmt instanceof DeltaRetainedBytesFormat) {
                    DeltaRetainedBytesFormat dfmt = (DeltaRetainedBytesFormat)((Object)fmt);
                    if (approxValue != DeltaEncoding.EXACT || approxPreviousValue != DeltaEncoding.EXACT) {
                        if (!(approxValue != DeltaEncoding.GE && approxValue != DeltaEncoding.EXACT || approxPreviousValue != DeltaEncoding.EXACT && approxPreviousValue != DeltaEncoding.LE)) {
                            val = dfmt.encodege(val);
                        } else if (!(approxValue != DeltaEncoding.LE && approxValue != DeltaEncoding.EXACT || approxPreviousValue != DeltaEncoding.EXACT && approxPreviousValue != DeltaEncoding.GE)) {
                            val = dfmt.encodele(val);
                        } else if (approxValue != DeltaEncoding.EXACT || approxPreviousValue != DeltaEncoding.EXACT) {
                            val = dfmt.encodeun(val);
                        }
                    }
                }
                if (returnBytes) {
                    return new Bytes(val);
                }
                return val;
            }
            return ret;
        }

        private int type(Number o) {
            if (o instanceof Byte) {
                return 1;
            }
            if (o instanceof Short) {
                return 2;
            }
            if (o instanceof Integer) {
                return 3;
            }
            if (o instanceof Long) {
                return 4;
            }
            if (o instanceof Float) {
                return 5;
            }
            if (o instanceof Double) {
                return 6;
            }
            return 6;
        }

        private Object computeDiff(Number o1, Number o2) {
            if (o1 instanceof Long && o2 instanceof Long) {
                return o2.longValue() - o1.longValue();
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return o2.intValue() - o1.intValue();
            }
            if (o1 instanceof Short && o2 instanceof Short) {
                return o2.shortValue() - o1.shortValue();
            }
            if (o1 instanceof Byte && o2 instanceof Byte) {
                return o2.byteValue() - o1.byteValue();
            }
            if (o1 instanceof Float && o2 instanceof Float) {
                return Float.valueOf(o2.floatValue() - o1.floatValue());
            }
            if (o1 instanceof Double && o2 instanceof Double) {
                return o2.doubleValue() - o1.doubleValue();
            }
            int t1 = this.type(o1);
            int t2 = this.type(o2);
            int t = Math.max(t1, t2);
            switch (t) {
                case 1: {
                    return o2.byteValue() - o1.byteValue();
                }
                case 2: {
                    return o2.shortValue() - o1.shortValue();
                }
                case 3: {
                    return o2.intValue() - o1.intValue();
                }
                case 4: {
                    return o2.longValue() - o1.longValue();
                }
                case 5: {
                    return Float.valueOf(o2.floatValue() - o1.floatValue());
                }
                case 6: {
                    return o2.doubleValue() - o1.doubleValue();
                }
            }
            return null;
        }

        public URL getIcon(Object row) {
            URL ret = null;
            ComparedRow cr = (ComparedRow)row;
            boolean foundIcon = false;
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length) {
                block6: {
                    Object r = cr.getRows()[i];
                    if (r != null) {
                        URL tableIcon;
                        URL uRL = tableIcon = CompareTablesQuery.this.tables[i] instanceof IIconProvider ? ((IIconProvider)CompareTablesQuery.this.tables[i]).getIcon(r) : null;
                        if (foundIcon) {
                            try {
                                if (ret == null ? tableIcon != null : tableIcon == null || !ret.toURI().equals(tableIcon.toURI())) {
                                    ret = Icons.getURL("compare.gif");
                                }
                                break block6;
                            }
                            catch (URISyntaxException e) {
                                ret = Icons.getURL("compare.gif");
                            }
                            break;
                        }
                        ret = tableIcon;
                        foundIcon = true;
                    }
                }
                ++i;
            }
            return ret;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
            this.updateColumns();
        }

        public Operation getOperation() {
            return this.setOp;
        }

        public void setOperation(Operation op) {
            if (op != Operation.NONE) {
                int samec = 0;
                boolean[] blArray = CompareTablesQuery.this.sameSnapshot;
                int n = blArray.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean same = blArray[n2];
                    if (same) {
                        ++samec;
                    }
                    ++n2;
                }
                if (samec < 2) {
                    op = Operation.NONE;
                }
            }
            this.setOp = op;
        }

        private void addPositiveIndicator(Format formatter) {
            DecimalFormat pctFmt;
            if (formatter instanceof DecimalFormat && ((pctFmt = (DecimalFormat)formatter).getPositivePrefix().length() == 0 || pctFmt.getPositivePrefix().equals(pctFmt.getNegativePrefix())) && (pctFmt.getPositiveSuffix().length() == 0 || pctFmt.getPositiveSuffix().equals(pctFmt.getNegativeSuffix()))) {
                DecimalFormatSymbols sym = DecimalFormatSymbols.getInstance();
                String plus = Character.toString(sym.getPlusSign());
                if (pctFmt.getPositivePrefix().length() > 0 && pctFmt.getPositiveSuffix().length() == 0) {
                    pctFmt.setPositiveSuffix(plus);
                } else {
                    pctFmt.setPositivePrefix(plus);
                }
            }
        }

        private void setFormatter() {
            int i = 1;
            NumberFormat formatter = NumberFormat.getIntegerInstance();
            this.addPositiveIndicator((Format)formatter);
            NumberFormat formatterPercent = NumberFormat.getPercentInstance();
            this.addPositiveIndicator((Format)formatterPercent);
            String detailed1 = "+#,##0.00;-#,##0.00";
            DecimalFormat bcf = new DecimalFormat(detailed1);
            NumberFormat nf = NumberFormat.getNumberInstance();
            if (nf instanceof DecimalFormat) {
                DecimalFormat bcf2 = (DecimalFormat)nf;
                bcf2.setMinimumFractionDigits(bcf.getMinimumFractionDigits());
                bcf2.setMaximumFractionDigits(bcf.getMaximumFractionDigits());
                this.addPositiveIndicator((Format)bcf2);
                bcf = bcf2;
            }
            BytesFormat bfm = new BytesFormat((Format)formatter, (Format)bcf);
            DeltaRetainedBytesFormat drbfm = new DeltaRetainedBytesFormat((Format)formatter, (Format)bcf);
            for (ComparedColumn comparedColumn : this.displayedColumns) {
                Column c = comparedColumn.description;
                int j = 0;
                while (j < comparedColumn.getColumnIndexes().length) {
                    Object converter;
                    IDecorator decorator;
                    if (this.mode != Mode.ABSOLUTE && j > 0) {
                        if (!this.columns[i].getCalculateTotals() && c.getCalculateTotals()) {
                            decorator = this.columns[i].getDecorator();
                            this.columns[i] = new Column(this.columns[i].getLabel(), this.columns[i].getType(), this.columns[i].getAlign(), this.columns[i].getSortDirection(), this.columns[i].getFormatter(), this.columns[i].getComparator());
                            this.columns[i].decorator(decorator);
                        } else if (this.columns[i].getCalculateTotals() && !c.getCalculateTotals()) {
                            this.columns[i].noTotals();
                        }
                        converter = c.getData(Filter.ValueConverter.class);
                        if (converter != null || this.columns[i].getData(Filter.ValueConverter.class) != null) {
                            this.columns[i].setData(Filter.ValueConverter.class, converter);
                        }
                        if (c.getFormatter() instanceof DecimalFormat) {
                            DecimalFormat fm = (DecimalFormat)c.getFormatter().clone();
                            fm.setPositivePrefix("+");
                            this.columns[i].formatting((Format)fm);
                        } else if (c.getFormatter() instanceof BytesFormat) {
                            if (c.getFormatter().getClass() == BytesFormat.class) {
                                this.columns[i].formatting((Format)bfm);
                            } else {
                                this.columns[i].formatting((Format)((Object)drbfm));
                                this.columns[i].setData(Filter.ValueConverter.class, (Object)drbfm.converter);
                            }
                        } else {
                            this.columns[i].formatting((Format)formatter);
                        }
                    } else {
                        if (!this.columns[i].getCalculateTotals() && c.getCalculateTotals()) {
                            decorator = this.columns[i].getDecorator();
                            this.columns[i] = new Column(this.columns[i].getLabel(), this.columns[i].getType(), this.columns[i].getAlign(), this.columns[i].getSortDirection(), this.columns[i].getFormatter(), this.columns[i].getComparator());
                            this.columns[i].decorator(decorator);
                        } else if (this.columns[i].getCalculateTotals() && !c.getCalculateTotals()) {
                            this.columns[i].noTotals();
                        }
                        this.columns[i].formatting(c.getFormatter());
                        converter = c.getData(Filter.ValueConverter.class);
                        if (converter != null || this.columns[i].getData(Filter.ValueConverter.class) != null) {
                            this.columns[i].setData(Filter.ValueConverter.class, converter);
                        }
                    }
                    ++i;
                    if ((this.mode == Mode.DIFF_RATIO_TO_FIRST || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS) && j > 0) {
                        this.columns[i].formatting((Format)formatterPercent);
                        this.columns[i].noTotals();
                        ++i;
                    }
                    ++j;
                }
            }
        }

        public void updateColumns() {
            ArrayList<Column> result = new ArrayList<Column>();
            result.add(new Column(this.key.getLabel(), this.key.getType(), this.key.getAlign(), null, this.key.getFormatter(), null));
            ((Column)result.get(result.size() - 1)).decorator((IDecorator)new KeyDecorator());
            this.displayedColumns = new ArrayList<ComparedColumn>();
            for (ComparedColumn comparedColumn : this.comparedColumns) {
                Column c = comparedColumn.description;
                if (!comparedColumn.isDisplayed()) continue;
                this.displayedColumns.add(comparedColumn);
                int j = 0;
                while (j < comparedColumn.getColumnIndexes().length) {
                    Comparator<ComparedRow> comparator;
                    String label;
                    int prev;
                    int n = prev = this.mode == Mode.DIFF_TO_PREVIOUS || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS ? j - 1 : 0;
                    if (j == 0 || this.mode == Mode.ABSOLUTE) {
                        label = MessageUtil.format((String)Messages.CompareTablesQuery_ColumnAbsolute, (Object[])new Object[]{c.getLabel(), j + 1});
                        final Comparator cmp = c.getComparator();
                        if (cmp != null) {
                            final int tab = j;
                            comparator = new Comparator<ComparedRow>(){

                                @Override
                                public int compare(ComparedRow o1, ComparedRow o2) {
                                    Object row1 = o1.rows[tab];
                                    Object row2 = o2.rows[tab];
                                    if (row1 == null) {
                                        return row2 == null ? 0 : -1;
                                    }
                                    if (row2 == null) {
                                        return 1;
                                    }
                                    return cmp.compare(row1, row2);
                                }
                            };
                        } else {
                            comparator = null;
                        }
                    } else {
                        label = MessageUtil.format((String)Messages.CompareTablesQuery_ColumnDifference, (Object[])new Object[]{c.getLabel(), j + 1, prev + 1});
                        comparator = null;
                    }
                    result.add(new Column(label, c.getType(), c.getAlign(), c.getSortDirection(), c.getFormatter(), (Comparator)comparator));
                    if (c.getDecorator() != null) {
                        ((Column)result.get(result.size() - 1)).decorator((IDecorator)new Decorator(c.getDecorator(), j));
                    }
                    if (j > 0 && (this.mode == Mode.DIFF_RATIO_TO_FIRST || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS)) {
                        label = MessageUtil.format((String)Messages.CompareTablesQuery_ColumnPercentDifference, (Object[])new Object[]{c.getLabel(), j + 1, prev + 1});
                        result.add(new Column(label, c.getType(), c.getAlign(), c.getSortDirection(), c.getFormatter(), null));
                    }
                    ++j;
                }
            }
            this.columns = result.toArray(new Column[result.size()]);
            this.setFormatter();
        }

        IContextObject getContextFromTable(int i, Object row) {
            if (!CompareTablesQuery.this.sameSnapshot[i]) {
                return null;
            }
            ComparedRow cr = (ComparedRow)row;
            IContextObject ret = null;
            Object r = cr.getRows()[i];
            if (r != null) {
                ret = CompareTablesQuery.this.tables[i].getContext(r);
            }
            return ret;
        }

        void derivedops(ResultMetaData.Builder answer) {
            int found = 0;
            HashSet<ContextDerivedData.DerivedOperation> allops = new HashSet<ContextDerivedData.DerivedOperation>();
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length) {
                IStructuredResult rr = CompareTablesQuery.this.tables[i];
                ResultMetaData data = rr.getResultMetaData();
                if (data != null) {
                    ++found;
                    Collection ops = data.getDerivedOperations();
                    if (ops != null) {
                        for (ContextDerivedData.DerivedOperation op : data.getDerivedOperations()) {
                            allops.add(op);
                        }
                    }
                }
                ++i;
            }
            if (found == 0) {
                return;
            }
            if (allops.size() == 0) {
                return;
            }
            for (ContextDerivedData.DerivedOperation operation : allops) {
                answer.addDerivedData(operation);
            }
        }

        class Decorator
        implements IDecorator {
            int table;
            IDecorator dec;

            Decorator(IDecorator dec, int table) {
                this.table = table;
                this.dec = dec;
            }

            public String prefix(Object row) {
                ComparedRow cr = (ComparedRow)row;
                Object r = cr.getRows()[this.table];
                return r != null ? this.dec.prefix(r) : null;
            }

            public String suffix(Object row) {
                ComparedRow cr = (ComparedRow)row;
                Object r = cr.getRows()[this.table];
                return r != null ? this.dec.suffix(r) : null;
            }
        }

        class KeyDecorator
        implements IDecorator {
            KeyDecorator() {
            }

            public String prefix(Object row) {
                ComparedRow cr = (ComparedRow)row;
                return cr.prefix;
            }

            public String suffix(Object row) {
                ComparedRow cr = (ComparedRow)row;
                return cr.suffix;
            }
        }
    }
}

