/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.commons;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.nebula.widgets.opal.commons.HTMLStyledTextParser;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SWTGraphicUtil {
    private static final String OS = System.getProperty("os.name").toLowerCase();

    private SWTGraphicUtil() {
    }

    public static void addDisposer(Widget widget, Resource ... resources) {
        widget.addDisposeListener(e -> {
            if (resources == null) {
                return;
            }
            Resource[] resourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray2[n2];
                SWTGraphicUtil.safeDispose(resource);
                ++n2;
            }
        });
    }

    public static void safeDispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public static Color getColorSafely(int r, int g, int b) {
        Display display = Display.getCurrent();
        Color color = new Color((Device)display, r, g, b);
        display.addListener(12, e -> {
            if (!color.isDisposed()) {
                color.dispose();
            }
        });
        return color;
    }

    public static Image createImageFromFile(String fileName) {
        if (new File(fileName).exists()) {
            return new Image((Device)Display.getCurrent(), fileName);
        }
        return new Image((Device)Display.getCurrent(), SWTGraphicUtil.class.getResourceAsStream(fileName));
    }

    public static Image createReflectedImage(Image source) {
        if (source == null) {
            return null;
        }
        if (source.isDisposed()) {
            SWT.error((int)24);
        }
        Rectangle sourceBounds = source.getBounds();
        Image newImage = new Image(source.getDevice(), new Rectangle(0, 0, sourceBounds.width, (int)((double)sourceBounds.height * 1.5)));
        GC gc = new GC((Drawable)newImage);
        gc.setAdvanced(true);
        gc.drawImage(source, 0, 0);
        Transform t = new Transform(source.getDevice());
        t.setElements(1.0f, 0.0f, 0.0f, -0.5f, 0.0f, (float)(sourceBounds.height + sourceBounds.height / 2));
        gc.setTransform(t);
        gc.drawImage(source, 0, 0);
        t.dispose();
        gc.dispose();
        ImageData imgData = newImage.getImageData();
        int width = imgData.width;
        int height = imgData.height;
        byte[] alphaData = new byte[height * width];
        byte[] noAlpha = new byte[width];
        int x = 0;
        while (x < width) {
            noAlpha[x] = -1;
            ++x;
        }
        int y = 0;
        while (y < height) {
            byte[] alphaRow = new byte[width];
            if (y < sourceBounds.height) {
                System.arraycopy(noAlpha, 0, alphaData, y * width, width);
            } else {
                int x2 = 0;
                while (x2 < width) {
                    alphaRow[x2] = (byte)(255 - 255 * y / height);
                    ++x2;
                }
                System.arraycopy(alphaRow, 0, alphaData, y * width, width);
            }
            ++y;
        }
        imgData.alphaData = alphaData;
        newImage.dispose();
        return new Image(source.getDevice(), imgData);
    }

    public static Image resize(Image source, int newWidth, int newHeight) {
        if (source == null) {
            return null;
        }
        if (source.isDisposed()) {
            SWT.error((int)24);
        }
        Image scaledImage = new Image(source.getDevice(), newWidth, newHeight);
        GC gc = new GC((Drawable)scaledImage);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, newWidth, newHeight);
        gc.dispose();
        return scaledImage;
    }

    public static Image createReflectedResizedImage(Image source, int newWidth, int newHeight) {
        if (source == null) {
            return null;
        }
        if (source.isDisposed()) {
            SWT.error((int)24);
        }
        Image newImage = new Image(source.getDevice(), newWidth, (int)((double)newHeight * 1.5));
        GC gc = new GC((Drawable)newImage);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, newWidth, newHeight);
        Transform t = new Transform(source.getDevice());
        t.setElements(1.0f, 0.0f, 0.0f, -0.5f, 0.0f, (float)((double)newHeight * 1.5));
        gc.setTransform(t);
        gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, newWidth, newHeight);
        t.dispose();
        gc.dispose();
        ImageData imgData = newImage.getImageData();
        int width = imgData.width;
        int height = imgData.height;
        byte[] alphaData = new byte[height * width];
        byte[] noAlpha = new byte[width];
        int x = 0;
        while (x < width) {
            noAlpha[x] = -1;
            ++x;
        }
        int y = 0;
        while (y < height) {
            byte[] alphaRow = new byte[width];
            if (y < newHeight) {
                System.arraycopy(noAlpha, 0, alphaData, y * width, width);
            } else {
                int x2 = 0;
                while (x2 < width) {
                    alphaRow[x2] = (byte)(255 - 255 * y / height);
                    ++x2;
                }
                System.arraycopy(alphaRow, 0, alphaData, y * width, width);
            }
            ++y;
        }
        imgData.alphaData = alphaData;
        return new Image(source.getDevice(), imgData);
    }

    public static void centerShell(Shell shell) {
        Monitor[] monitors = shell.getDisplay().getMonitors();
        Monitor activeMonitor = null;
        Rectangle r = shell.getBounds();
        int i = 0;
        while (i < monitors.length) {
            if (monitors[i].getBounds().intersects(r)) {
                activeMonitor = monitors[i];
            }
            ++i;
        }
        Rectangle bounds = activeMonitor.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    public static Rectangle getBoundsOfMonitorOnWhichShellIsDisplayed(Shell shell) {
        Monitor monitor;
        if (shell == null) {
            SWT.error((int)4);
        }
        if (shell.isDisposed()) {
            SWT.error((int)24);
        }
        if ((monitor = shell.getMonitor()) == null) {
            monitor = shell.getDisplay().getPrimaryMonitor();
        }
        return monitor.getBounds();
    }

    public static void applyHTMLFormating(StyledText styledText) {
        try {
            new HTMLStyledTextParser(styledText).parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ImageData blur(ImageData originalImageData, int radius) {
        if (radius < 1) {
            return originalImageData;
        }
        ImageData newImageData = new ImageData(originalImageData.width, originalImageData.height, 24, new PaletteData(255, 65280, 0xFF0000));
        if (radius >= newImageData.height || radius >= newImageData.width) {
            radius = Math.min(newImageData.height, newImageData.width) - 1;
        }
        ArrayList<RGB[]> rowCache = new ArrayList<RGB[]>();
        int cacheSize = radius * 2 + 1 > newImageData.height ? newImageData.height : radius * 2 + 1;
        int cacheStartIndex = 0;
        int row = 0;
        while (row < cacheSize) {
            rowCache.add(rowCache.size(), SWTGraphicUtil.blurRow(originalImageData, row, radius));
            ++row;
        }
        RGB[] rowRGBSums = new RGB[newImageData.width];
        int[] rowRGBAverages = new int[newImageData.width];
        int topSumBoundary = 0;
        int targetRow = 0;
        int bottomSumBoundary = 0;
        int numRows = 0;
        int i = 0;
        while (i < newImageData.width) {
            rowRGBSums[i] = new RGB(0, 0, 0);
            ++i;
        }
        while (targetRow < newImageData.height) {
            int col;
            if (bottomSumBoundary < newImageData.height) {
                do {
                    col = 0;
                    while (col < newImageData.width) {
                        rowRGBSums[col].red += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].red;
                        rowRGBSums[col].green += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].green;
                        rowRGBSums[col].blue += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].blue;
                        ++col;
                    }
                    ++numRows;
                    if (++bottomSumBoundary >= newImageData.height || bottomSumBoundary - cacheStartIndex <= radius * 2) continue;
                    rowCache.add(rowCache.size(), SWTGraphicUtil.blurRow(originalImageData, bottomSumBoundary, radius));
                } while (bottomSumBoundary <= radius);
            }
            if (targetRow - topSumBoundary > radius) {
                col = 0;
                while (col < newImageData.width) {
                    rowRGBSums[col].red -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].red;
                    rowRGBSums[col].green -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].green;
                    rowRGBSums[col].blue -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].blue;
                    ++col;
                }
                --numRows;
                ++topSumBoundary;
                rowCache.remove(0);
                ++cacheStartIndex;
            }
            col = 0;
            while (col < newImageData.width) {
                rowRGBAverages[col] = newImageData.palette.getPixel(new RGB(rowRGBSums[col].red / numRows, rowRGBSums[col].green / numRows, rowRGBSums[col].blue / numRows));
                ++col;
            }
            newImageData.setPixels(0, targetRow, newImageData.width, rowRGBAverages, 0);
            ++targetRow;
        }
        return newImageData;
    }

    private static RGB[] blurRow(ImageData originalImageData, int row, int radius) {
        RGB[] rowRGBAverages = new RGB[originalImageData.width];
        int[] lineData = new int[originalImageData.width];
        originalImageData.getPixels(0, row, originalImageData.width, lineData, 0);
        int r = 0;
        int g = 0;
        int b = 0;
        int leftSumBoundary = 0;
        int targetColumn = 0;
        int rightSumBoundary = 0;
        int numCols = 0;
        while (targetColumn < lineData.length) {
            RGB rgb;
            if (rightSumBoundary < lineData.length) {
                do {
                    rgb = originalImageData.palette.getRGB(lineData[rightSumBoundary]);
                    r += rgb.red;
                    g += rgb.green;
                    b += rgb.blue;
                    ++numCols;
                } while (++rightSumBoundary <= radius);
            }
            if (targetColumn - leftSumBoundary > radius) {
                rgb = originalImageData.palette.getRGB(lineData[leftSumBoundary]);
                r -= rgb.red;
                g -= rgb.green;
                b -= rgb.blue;
                --numCols;
                ++leftSumBoundary;
            }
            rowRGBAverages[targetColumn] = new RGB(r / numCols, g / numCols, b / numCols);
            ++targetColumn;
        }
        return rowRGBAverages;
    }

    public static void enableAllChildrenWidgets(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                SWTGraphicUtil.enableAllChildrenWidgets(c);
                ++n2;
            }
        }
        boolean enable = true;
        Boolean previousState = (Boolean)control.getData(SWTGraphicUtil.class.toString() + "_enableState");
        if (previousState != null) {
            enable = previousState;
        }
        control.setEnabled(enable);
    }

    public static void disableAllChildrenWidgets(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                SWTGraphicUtil.disableAllChildrenWidgets(c);
                ++n2;
            }
        }
        control.setData(SWTGraphicUtil.class.toString() + "_enableState", (Object)control.isEnabled());
        control.setEnabled(false);
    }

    public static Font buildFontFrom(Control control, int style) {
        Font temp = control.getFont();
        FontData[] fontData = temp.getFontData();
        if (fontData == null || fontData.length == 0) {
            return temp;
        }
        return new Font((Device)control.getDisplay(), fontData[0].getName(), fontData[0].getHeight(), style);
    }

    public static Font buildFontFrom(Control control, int style, int size) {
        Font temp = control.getFont();
        FontData[] fontData = temp.getFontData();
        if (fontData == null || fontData.length == 0) {
            return temp;
        }
        return new Font((Device)control.getDisplay(), fontData[0].getName(), size, style);
    }

    public static boolean isMacOS() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isLinux() {
        return OS.indexOf("nux") >= 0;
    }

    public static Color getDefaultColor(Control control, int red, int green, int blue) {
        Color defaultColor = new Color((Device)control.getDisplay(), red, green, blue);
        SWTGraphicUtil.addDisposer((Widget)control, new Resource[]{defaultColor});
        return defaultColor;
    }

    public static int computeWidth(String text) {
        return SWTGraphicUtil.computeSize((String)text, null).x;
    }

    public static Point computeSize(String text, Font font) {
        if (text == null) {
            return new Point(0, 0);
        }
        GC gc = new GC((Drawable)Display.getDefault());
        if (font != null) {
            gc.setFont(font);
        }
        Point size = gc.textExtent(text);
        gc.dispose();
        return size;
    }
}

