/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.provisonnal.com.eclipsesource.json.ParseException;

public class HttpHelper {
    public static final boolean DEFAULT_REMOTE_ACCESS = false;
    public static final int DEFAULT_REMOTE_PORT = 1234;
    public static final long DEFAULT_TIMEOUT = 200L;
    public static final int DEFAULT_TEST_NUMBER = 50;
    public static final boolean DEFAULT_PERSISTENT = false;

    public static JsonValue makeRequest(String url) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpGet httpGet = new HttpGet(url);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            InputStream in = entity.getContent();
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            try {
                JsonValue response;
                JsonValue jsonValue = response = JsonValue.readFrom(new InputStreamReader(in));
                return jsonValue;
            }
            catch (ParseException e) {
                try {
                    throw new IOException(e);
                }
                catch (Exception e2) {
                    if (e2 instanceof IOException) {
                        throw (IOException)e2;
                    }
                    throw new IOException(e2);
                }
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static long getElapsedTimeInMs(long startTime) {
        return (System.nanoTime() - startTime) / 1000000L;
    }
}

