/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal.editor;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class UpdateServerPropertyOperation
extends AbstractOperation {
    private GenericServer fGenericServer;
    private String fPropertyName;
    private String fPRopertyValue;
    private String fOldValue;

    public UpdateServerPropertyOperation(IServerWorkingCopy server, String name, String propertyName, String propertyValue) {
        super(name);
        if (server != null) {
            this.fGenericServer = (GenericServer)server.loadAdapter(GenericServer.class, (IProgressMonitor)new NullProgressMonitor());
        }
        this.fPropertyName = propertyName;
        this.fPRopertyValue = propertyValue;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        HashMap<String, String> map = new HashMap<String, String>(this.fGenericServer.getServerInstanceProperties());
        if (map.containsKey(this.fPropertyName)) {
            this.fOldValue = (String)map.get(this.fPropertyName);
            map.put(this.fPropertyName, this.fPRopertyValue);
            this.fGenericServer.setServerInstanceProperties(map);
            return null;
        }
        return new Status(4, "org.eclipse.jst.server.generic.ui", 0, "Property can not be found", null);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        HashMap<String, String> map = new HashMap<String, String>(this.fGenericServer.getServerInstanceProperties());
        map.put(this.fPropertyName, this.fOldValue);
        this.fGenericServer.setServerInstanceProperties(map);
        return null;
    }
}

