/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum PHPVersion {
    PHP5("php5"),
    PHP5_3("php5.3"),
    PHP5_4("php5.4"),
    PHP5_5("php5.5"),
    PHP5_6("php5.6"),
    PHP7_0("php7.0"),
    PHP7_1("php7.1"),
    PHP7_2("php7.2"),
    PHP7_3("php7.3"),
    PHP7_4("php7.4"),
    PHP8_0("php8.0"),
    PHP8_1("php8.1"),
    PHP8_2("php8.2"),
    PHP8_3("php8.3");

    private String alias;
    private boolean isExperimentalSupport;

    private PHPVersion(String alias, boolean isExperimentalSupport) {
        this.alias = alias;
        this.isExperimentalSupport = isExperimentalSupport;
        Aliases.map.put(alias, this);
    }

    private PHPVersion(String alias) {
        this(alias, false);
    }

    public String getAlias() {
        return this.alias;
    }

    public static PHPVersion byAlias(String alias) {
        return Aliases.map.get(alias);
    }

    public boolean isLessThan(PHPVersion phpVersion) {
        return this.ordinal() < phpVersion.ordinal();
    }

    public boolean isGreaterThan(PHPVersion phpVersion) {
        return this.ordinal() > phpVersion.ordinal();
    }

    public boolean isExperimentalSupport() {
        return this.isExperimentalSupport;
    }

    public static Collection<PHPVersion> getAllVersions() {
        return Aliases.map.values();
    }

    public static PHPVersion[] supportedVersions() {
        return new PHPVersion[]{PHP8_3, PHP8_2, PHP8_1, PHP8_0, PHP7_4, PHP7_3, PHP7_2, PHP7_1, PHP7_0, PHP5_6, PHP5_5, PHP5_4, PHP5_3, PHP5};
    }

    public static PHPVersion getLatestVersion() {
        return PHP8_2;
    }

    private static class Aliases {
        private static Map<String, PHPVersion> map = new HashMap<String, PHPVersion>();

        private Aliases() {
        }
    }
}

