/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IProcessesV1;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;

class TCFConsole
extends AbstractConsole {
    public static final int TYPE_PROCESS_CONSOLE = 1;
    public static final int TYPE_PROCESS_TERMINAL = 2;
    public static final int TYPE_UART_TERMINAL = 3;
    public static final int TYPE_CMD_LINE = 4;
    public static final int TYPE_DPRINTF = 5;
    private static int page_id_cnt = 0;
    private final TCFModel model;
    private final Display display;
    private final String ctx_id;
    private final int type;
    private final LinkedList<ViewPage> pages = new LinkedList();
    private final LinkedList<Message> history = new LinkedList();

    TCFConsole(TCFModel model, int type, String ctx_id) {
        super(TCFConsole.getViewName(type, ctx_id), null, TCFConsole.getImageDescriptor(ctx_id), false);
        this.model = model;
        this.type = type;
        this.ctx_id = ctx_id;
        this.display = model.getDisplay();
        model.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PlatformUI.getWorkbench().isClosing()) {
                        return;
                    }
                    if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                        TCFConsole.this.display.timerExec(200, (Runnable)this);
                        return;
                    }
                    IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                    manager.addConsoles(new IConsole[]{TCFConsole.this});
                    manager.showConsoleView((IConsole)TCFConsole.this);
                }
                catch (Throwable x) {
                    Activator.log("Cannot open Console view", x);
                }
            }
        });
    }

    private static ImageDescriptor getImageDescriptor(String ctx_id) {
        String image = ctx_id != null ? "icons/full/obj16/debugt_obj" : "icons/tcf";
        return ImageCache.getImageDescriptor(image);
    }

    private static String getViewName(int type, String name) {
        String title = "TCF";
        switch (type) {
            case 1: {
                title = String.valueOf(title) + " Debug Process Console - " + name;
                break;
            }
            case 2: {
                title = String.valueOf(title) + " Debug Process Terminal - " + name;
                break;
            }
            case 3: {
                title = String.valueOf(title) + " Debug Virtual Terminal - " + name;
                break;
            }
            case 4: {
                title = String.valueOf(title) + " Debugger Command Line";
                break;
            }
            case 5: {
                title = "Debug Dynamic Printf";
            }
        }
        return title;
    }

    void onModelConnected() {
        if (this.ctx_id != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!TCFConsole.this.model.createNode(TCFConsole.this.ctx_id, this)) {
                        return;
                    }
                    TCFNode node = TCFConsole.this.model.getNode(TCFConsole.this.ctx_id);
                    if (node instanceof TCFNodeExecContext) {
                        TCFNodeExecContext exe = (TCFNodeExecContext)node;
                        TCFDataCache<IRunControl.RunControlContext> ctx_cache = exe.getRunContext();
                        if (!ctx_cache.validate((Runnable)this)) {
                            return;
                        }
                        IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
                        if (ctx_data != null && ctx_data.getName() != null) {
                            final String name = ctx_data.getName();
                            TCFConsole.this.model.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TCFConsole.this.setName(TCFConsole.getViewName(TCFConsole.this.type, name));
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int stream_id, byte[] data) {
        assert (Protocol.isDispatchThread());
        if (data == null || data.length == 0) {
            return;
        }
        Message m = new Message();
        m.stream_id = stream_id;
        m.data = data;
        this.history.add(m);
        if (this.history.size() > 1000) {
            this.history.removeFirst();
        }
        for (ViewPage p : this.pages) {
            LinkedList linkedList = p.inp_queue;
            synchronized (linkedList) {
                p.inp_queue.add(m);
                p.inp_queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        assert (Protocol.isDispatchThread());
        Message m = new Message();
        for (ViewPage p : this.pages) {
            LinkedList linkedList = p.inp_queue;
            synchronized (linkedList) {
                p.inp_queue.add(m);
                p.inp_queue.notify();
            }
        }
        this.model.asyncExec(new Runnable(){

            @Override
            public void run() {
                IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                manager.removeConsoles(new IConsole[]{TCFConsole.this});
            }
        });
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new ViewPage();
    }

    private static class Message {
        int stream_id;
        byte[] data;

        private Message() {
        }
    }

    private class ViewPage
    extends Page
    implements ITerminalConnector,
    ITerminalListener {
        private final String page_id;
        private final LinkedList<Message> inp_queue;
        private final OutputStream out_stream;
        private ITerminalViewControl view_control;
        private OutputStream rtt;
        private int ws_col;
        private int ws_row;
        private final Thread inp_thread;

        private ViewPage() {
            StringBuilder stringBuilder = new StringBuilder("Page-");
            int n = page_id_cnt;
            page_id_cnt = n + 1;
            this.page_id = stringBuilder.append(n).toString();
            this.inp_queue = new LinkedList();
            this.out_stream = new OutputStream(){

                @Override
                public void write(final int b) throws IOException {
                    if (TCFConsole.this.ctx_id == null) {
                        return;
                    }
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String s = "" + (char)b;
                                byte[] buf = s.getBytes("UTF8");
                                TCFConsole.this.model.getLaunch().writeProcessInputStream(TCFConsole.this.ctx_id, buf, 0, buf.length);
                            }
                            catch (Exception x) {
                                TCFConsole.this.model.onProcessStreamError(TCFConsole.this.ctx_id, 0, x, 0);
                            }
                        }
                    });
                }
            };
            this.inp_thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        block10: while (true) {
                            Message m = null;
                            LinkedList linkedList = ViewPage.this.inp_queue;
                            synchronized (linkedList) {
                                while (ViewPage.this.inp_queue.size() == 0) {
                                    ViewPage.this.inp_queue.wait();
                                }
                                m = (Message)ViewPage.this.inp_queue.removeFirst();
                            }
                            if (m.data != null) {
                                if (TCFConsole.this.type == 1) {
                                    String s = "\u001b[30m";
                                    switch (m.stream_id) {
                                        case 1: {
                                            s = "\u001b[31m";
                                            break;
                                        }
                                        case 2: {
                                            s = "\u001b[34m";
                                            break;
                                        }
                                        case 3: {
                                            s = "\u001b[32m";
                                        }
                                    }
                                    ViewPage.this.rtt.write(s.getBytes("UTF8"));
                                    int i = 0;
                                    while (true) {
                                        if (i >= m.data.length) continue block10;
                                        int ch = m.data[i] & 0xFF;
                                        if (ch == 10) {
                                            ViewPage.this.rtt.write(13);
                                        }
                                        ViewPage.this.rtt.write(ch);
                                        ++i;
                                    }
                                }
                                if (TCFConsole.this.type == 5) {
                                    int i = 0;
                                    int j = 0;
                                    while (j < m.data.length) {
                                        if (m.data[j] == 10) {
                                            ViewPage.this.rtt.write(m.data, i, j - i);
                                            ViewPage.this.rtt.write(13);
                                            i = j;
                                        }
                                        ++j;
                                    }
                                    ViewPage.this.rtt.write(m.data, i, m.data.length - i);
                                    continue;
                                }
                                ViewPage.this.rtt.write(m.data);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable x) {
                        Activator.log("Cannot write console output", x);
                    }
                }
            };
        }

        public void createControl(Composite parent) {
            assert (this.view_control == null);
            this.view_control = TerminalViewControlFactory.makeControl((ITerminalListener)this, (Composite)parent, null);
            this.view_control.setConnector((ITerminalConnector)this);
            this.view_control.connectTerminal();
        }

        public void dispose() {
            if (this.view_control != null) {
                this.view_control.disposeTerminal();
                this.view_control.setConnector(null);
                this.view_control = null;
            }
        }

        public Control getControl() {
            return this.view_control.getRootControl();
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
            this.view_control.setFocus();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public void setTerminalSize(final int w, final int h) {
            if (this.ws_col == w && this.ws_row == h) {
                return;
            }
            this.ws_col = w;
            this.ws_row = h;
            if (TCFConsole.this.type != 2) {
                return;
            }
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    final TCFLaunch launch = TCFConsole.this.model.getLaunch();
                    if (launch.isProcessExited()) {
                        return;
                    }
                    final IChannel channel = launch.getChannel();
                    if (channel.getState() != 1) {
                        return;
                    }
                    IProcessesV1 prs = (IProcessesV1)channel.getRemoteService(IProcessesV1.class);
                    if (prs == null) {
                        return;
                    }
                    prs.setWinSize(TCFConsole.this.ctx_id, w, h, new IProcesses.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error == null) {
                                return;
                            }
                            if (launch.isProcessExited()) {
                                return;
                            }
                            if (channel.getState() != 1) {
                                return;
                            }
                            if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
                                return;
                            }
                            Activator.log("Cannot set process TTY window size", error);
                        }
                    });
                }
            });
        }

        public void save(ISettingsStore store) {
        }

        public void setDefaultSettings() {
        }

        public void load(ISettingsStore store) {
        }

        public boolean isLocalEcho() {
            return false;
        }

        public boolean isInitialized() {
            return true;
        }

        public boolean isHidden() {
            return false;
        }

        public OutputStream getTerminalToRemoteStream() {
            return this.out_stream;
        }

        public String getSettingsSummary() {
            return null;
        }

        public String getName() {
            return TCFConsole.this.getName();
        }

        public String getInitializationErrorMessage() {
            return null;
        }

        public String getId() {
            return this.page_id;
        }

        public void disconnect() {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TCFConsole.this.pages.remove((Object)ViewPage.this);
                    LinkedList linkedList = ViewPage.this.inp_queue;
                    synchronized (linkedList) {
                        ViewPage.this.inp_queue.add(new Message());
                        ViewPage.this.inp_queue.notify();
                    }
                }
            });
        }

        public void connect(ITerminalControl term_control) {
            try {
                term_control.setState(TerminalState.CONNECTING);
                term_control.setEncoding("UTF8");
                this.rtt = term_control.getRemoteToTerminalOutputStream();
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TCFConsole.this.pages.add(ViewPage.this);
                        for (Message m : TCFConsole.this.history) {
                            ViewPage.this.inp_queue.add(m);
                        }
                        ViewPage.this.inp_thread.setName("TCF Console Input");
                        ViewPage.this.inp_thread.start();
                    }
                });
                term_control.setState(TerminalState.CONNECTED);
            }
            catch (Exception x) {
                Activator.log("Cannot connect a terminal", x);
                term_control.setState(TerminalState.CLOSED);
            }
        }

        public void setState(TerminalState state) {
        }

        public void setTerminalTitle(String title) {
        }

        public ISettingsPage makeSettingsPage() {
            return null;
        }
    }
}

