/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.services;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.services.AbstractServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.services.nls.Messages;
import org.osgi.framework.Bundle;

public class ServiceManager
extends AbstractServiceManager {
    ServiceManager() {
    }

    public static ServiceManager getInstance() {
        return LazyInstance.instance;
    }

    public <V extends IService> V getService(Class<? extends V> serviceType, boolean unique) {
        return super.getService(null, serviceType, unique);
    }

    public <V extends IService> V getService(Class<? extends V> serviceType) {
        return super.getService(null, serviceType);
    }

    @Override
    protected void loadServices() {
        IExtension[] extensions;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tcf.te.runtime.services.services");
        if (ep != null && (extensions = ep.getExtensions()) != null) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                if (configElements != null) {
                    IConfigurationElement[] iConfigurationElementArray = configElements;
                    int n3 = configElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        if ("service".equals(configElement.getName())) {
                            AbstractServiceManager.ServiceProxy proxy = this.getServiceProxy(configElement);
                            IConfigurationElement[] serviceTypes = configElement.getChildren("serviceType");
                            if (serviceTypes != null && serviceTypes.length > 0) {
                                IConfigurationElement[] iConfigurationElementArray2 = serviceTypes;
                                int n5 = serviceTypes.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IConfigurationElement serviceType = iConfigurationElementArray2[n6];
                                    try {
                                        Bundle bundle;
                                        String type = serviceType.getAttribute("class");
                                        String bundleId = serviceType.getAttribute("bundleId");
                                        Bundle bundle2 = bundle = bundleId != null ? (bundle = Platform.getBundle((String)bundleId)) : null;
                                        if (bundle == null) {
                                            bundle = Platform.getBundle((String)configElement.getDeclaringExtension().getNamespaceIdentifier());
                                        }
                                        if (bundle == null) {
                                            bundle = CoreBundleActivator.getContext().getBundle();
                                        }
                                        Class typeClass = bundle != null ? bundle.loadClass(type) : Class.forName(type);
                                        proxy.addType(typeClass);
                                    }
                                    catch (Exception e) {
                                        Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ServiceManager_warning_failedToLoadServiceType, (Object)serviceType.getAttribute("class"), (Object)configElement.getAttribute("class")), (Throwable)e);
                                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                                    }
                                    ++n6;
                                }
                            }
                            this.addService(proxy);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private static class LazyInstance {
        public static ServiceManager instance = new ServiceManager();

        private LazyInstance() {
        }
    }
}

