/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.DefaultUnitConverter;
import com.jgoodies.forms.util.UnitConverter;
import java.awt.Component;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JFrame;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class FormSizeConstantInfo {
    private double m_value;
    private ConstantSize.Unit m_unit;
    private static final DecimalFormat FORMAT = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ENGLISH));
    static Component m_toolkitComponent = new JFrame();

    public FormSizeConstantInfo(double value, ConstantSize.Unit unit) {
        this.m_value = value;
        this.m_unit = unit;
    }

    public double getValue() {
        return this.m_value;
    }

    public int getAsPixels() {
        return FormSizeConstantInfo.convertToPixels(this.m_value, this.m_unit);
    }

    public void setValue(double value) {
        this.m_value = value;
    }

    public void setValueString(String s) {
        try {
            this.m_value = FORMAT.parse(s).doubleValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setAsPixels(int pixels) throws Exception {
        this.m_value = FormSizeConstantInfo.convertFromPixels(pixels, this.m_unit);
    }

    public ConstantSize.Unit getUnit() {
        return this.m_unit;
    }

    public void setUnit(ConstantSize.Unit unit) throws Exception {
        this.m_value = FormSizeConstantInfo.convertValue(this.m_value, this.m_unit, unit);
        this.m_unit = unit;
    }

    public String getSource(boolean asString, boolean horizontal) {
        Object encoded = FORMAT.format(this.m_value) + this.m_unit.abbreviation();
        encoded = StringUtils.replace((String)encoded, (String)"dluX", (String)"dlu");
        encoded = StringUtils.replace((String)encoded, (String)"dluY", (String)"dlu");
        if (asString) {
            return encoded;
        }
        return "com.jgoodies.forms.layout.Sizes.constant(\"" + (String)encoded + "\", " + horizontal + ")";
    }

    public Size getSize(boolean horizontal) {
        return Sizes.constant((String)this.getSource(true, horizontal), (boolean)horizontal);
    }

    private static double convertValue(double value, ConstantSize.Unit oldUnit, ConstantSize.Unit newUnit) throws Exception {
        if (oldUnit == ConstantSize.CENTIMETER && newUnit == ConstantSize.MILLIMETER) {
            return value * 10.0;
        }
        if (oldUnit == ConstantSize.MILLIMETER && newUnit == ConstantSize.CENTIMETER) {
            return value / 10.0;
        }
        if (oldUnit != newUnit) {
            int pixels = FormSizeConstantInfo.convertToPixels(value, oldUnit);
            return FormSizeConstantInfo.convertFromPixels(pixels, newUnit);
        }
        return value;
    }

    public static int convertToPixels(double value, ConstantSize.Unit unit) {
        DefaultUnitConverter converter = DefaultUnitConverter.getInstance();
        int pixels = 0;
        if (unit == ConstantSize.PIXEL) {
            pixels = (int)value;
        } else if (unit == ConstantSize.POINT) {
            pixels = converter.pointAsPixel((int)value, m_toolkitComponent);
        } else if (unit == ConstantSize.DLUX) {
            pixels = converter.dialogUnitXAsPixel((int)value, m_toolkitComponent);
        } else if (unit == ConstantSize.DLUY) {
            pixels = converter.dialogUnitYAsPixel((int)value, m_toolkitComponent);
        } else if (unit == ConstantSize.MILLIMETER) {
            pixels = converter.millimeterAsPixel(value, m_toolkitComponent);
        } else if (unit == ConstantSize.CENTIMETER) {
            pixels = converter.centimeterAsPixel(value, m_toolkitComponent);
        } else if (unit == ConstantSize.INCH) {
            pixels = converter.inchAsPixel(value, m_toolkitComponent);
        }
        return pixels;
    }

    public static double convertFromPixels(int pixels, ConstantSize.Unit unit) throws Exception {
        if (unit == ConstantSize.PIXEL) {
            return pixels;
        }
        if (unit == ConstantSize.POINT) {
            return FormSizeConstantInfo.convertFromPixelsInt(pixels, "pointAsPixel");
        }
        if (unit == ConstantSize.DLUX) {
            return FormSizeConstantInfo.convertFromPixelsInt(pixels, "dialogUnitXAsPixel");
        }
        if (unit == ConstantSize.DLUY) {
            return FormSizeConstantInfo.convertFromPixelsInt(pixels, "dialogUnitYAsPixel");
        }
        if (unit == ConstantSize.MILLIMETER) {
            return FormSizeConstantInfo.convertFromPixelsDouble(pixels, "millimeterAsPixel");
        }
        if (unit == ConstantSize.CENTIMETER) {
            return FormSizeConstantInfo.convertFromPixelsDouble(pixels, "centimeterAsPixel");
        }
        Assert.isTrue((unit == ConstantSize.INCH ? 1 : 0) != 0);
        return FormSizeConstantInfo.convertFromPixelsDouble(pixels, "inchAsPixel");
    }

    private static int convertFromPixelsInt(int pixels, String methodName) throws Exception {
        DefaultUnitConverter converter = DefaultUnitConverter.getInstance();
        Method method = UnitConverter.class.getMethod(methodName, Integer.TYPE, Component.class);
        int result = 0;
        Integer newPixelsValue;
        int newPixels;
        while ((newPixels = (newPixelsValue = (Integer)method.invoke((Object)converter, result, m_toolkitComponent)).intValue()) <= pixels) {
            ++result;
        }
        return result;
    }

    private static double convertFromPixelsDouble(int pixels, String methodName) throws Exception {
        DefaultUnitConverter converter = DefaultUnitConverter.getInstance();
        Method method = UnitConverter.class.getMethod(methodName, Double.TYPE, Component.class);
        double result = 0.0;
        Integer newPixelsValue;
        int newPixels;
        while ((newPixels = (newPixelsValue = (Integer)method.invoke((Object)converter, result, m_toolkitComponent)).intValue()) <= pixels) {
            result += 0.05;
        }
        return (double)((int)(result * 10.0)) / 10.0;
    }
}

