/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability;

import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.internal.traceability.AcceleoTraceabilityMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class AcceleoTraceabilityPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.traceability";
    private static AcceleoTraceabilityPlugin plugin;

    public static AcceleoTraceabilityPlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e, boolean blocker) {
        if (e == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString((String)"AcceleoTraceabilityPlugin.LogNullException"));
        }
        if (AcceleoTraceabilityPlugin.getDefault() == null) {
            e.printStackTrace();
        } else if (e instanceof CoreException) {
            AcceleoTraceabilityPlugin.log(((CoreException)e).getStatus());
        } else if (e instanceof NullPointerException) {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoTraceabilityPlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, AcceleoEngineMessages.getString((String)"AcceleoTraceabilityPlugin.ElementNotFound"), (Throwable)e));
        } else {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoTraceabilityPlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, e.getMessage(), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        if (status == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString((String)"AcceleoTraceabilityPlugin.LogNullStatus"));
        }
        if (AcceleoTraceabilityPlugin.getDefault() != null) {
            AcceleoTraceabilityPlugin.getDefault().getLog().log(status);
        } else {
            System.err.println(status.getMessage());
            status.getException().printStackTrace();
        }
    }

    public static void log(String message, boolean blocker) {
        if (AcceleoTraceabilityPlugin.getDefault() == null) {
            System.err.println(message);
        } else {
            String errorMessage;
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            if ((errorMessage = message) == null || "".equals(errorMessage)) {
                errorMessage = AcceleoTraceabilityMessages.getString("AcceleoTraceabilityPlugin.UnexpectedException");
            }
            AcceleoTraceabilityPlugin.log((IStatus)new Status(severity, PLUGIN_ID, errorMessage));
        }
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }
}

