/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorsComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfoComparator;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorPreviewCanvas;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorsGridComposite;

public abstract class AbstractColorsGridComposite
extends AbstractColorsComposite {
    private ColorPreviewCanvas m_colorHintCanvas;
    private final List<ColorsGridComposite> m_colorsGrids = new ArrayList<ColorsGridComposite>();

    public AbstractColorsGridComposite(Composite parent, int style, AbstractColorDialog colorDialog) {
        super(parent, style, colorDialog);
        this.setLayout((Layout)new GridLayout());
        this.createColorHint();
    }

    private void createColorHint() {
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.AbstractColorsGridComposite_colorHintGroup);
        group.setLayout((Layout)new FillLayout());
        group.setLayoutData((Object)new GridData(256));
        this.m_colorHintCanvas = new ColorPreviewCanvas((Composite)group, 0, this.showShortTextInColorPreview());
    }

    protected boolean showShortTextInColorPreview() {
        return false;
    }

    protected final ColorsGridComposite createColorsGroup(Composite parent, String title, ColorInfo[] colors) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new FillLayout());
        if (title != null) {
            group.setText(title);
        }
        return this.createColorsGrid((Composite)group, colors);
    }

    protected final ColorsGridComposite createColorsGrid(Composite parent, ColorInfo[] colors) {
        ColorsGridComposite colorsGrid = new ColorsGridComposite(parent, 0);
        colorsGrid.setColors(colors);
        this.m_colorsGrids.add(colorsGrid);
        colorsGrid.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                ColorInfo colorInfo = (ColorInfo)event.data;
                AbstractColorsGridComposite.this.m_colorHintCanvas.setColor(colorInfo);
            }
        });
        colorsGrid.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorInfo colorInfo = (ColorInfo)event.data;
                AbstractColorsGridComposite.this.m_colorDialog.setResultColor(colorInfo);
            }
        });
        colorsGrid.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                AbstractColorsGridComposite.this.m_colorDialog.closeOk();
            }
        });
        return colorsGrid;
    }

    protected final Group createSortGroup(Composite parent, List<String> titles, List<ColorInfoComparator> comparators) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(titles.size(), false));
        group.setText(Messages.AbstractColorsGridComposite_sortGroup);
        int i = 0;
        while (i < titles.size()) {
            String title = titles.get(i);
            final ColorInfoComparator comparator = comparators.get(i);
            Button button = new Button((Composite)group, 16);
            button.setText(title);
            if (i == 0) {
                button.setSelection(true);
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractColorsGridComposite.this.setComparator(comparator);
                }
            });
            ++i;
        }
        return group;
    }

    protected final void setComparator(ColorInfoComparator comparator) {
        for (ColorsGridComposite colorsGrid : this.m_colorsGrids) {
            Arrays.sort(colorsGrid.getColors(), comparator);
            colorsGrid.redraw();
        }
    }
}

