/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclEnsemblePart;

public class IncrTclEnsemble
extends Declaration {
    private List<IncrTclEnsemble> ensembles;
    private List<IncrTclEnsemblePart> parts;

    public IncrTclEnsemble(int start, int end) {
        super(start, end);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.ensembles != null) {
                for (IncrTclEnsemble incrTclEnsemble : this.ensembles) {
                    incrTclEnsemble.traverse(visitor);
                }
            }
            if (this.parts != null) {
                for (IncrTclEnsemblePart incrTclEnsemblePart : this.parts) {
                    incrTclEnsemblePart.traverse(visitor);
                }
            }
            visitor.endvisit((Statement)this);
        }
    }

    public void addEnsamble(IncrTclEnsemble part) {
        this.initialize();
        this.ensembles.add(part);
    }

    private void initialize() {
        if (this.ensembles == null) {
            this.ensembles = new ArrayList<IncrTclEnsemble>();
        }
        if (this.parts == null) {
            this.parts = new ArrayList<IncrTclEnsemblePart>();
        }
    }

    public List<IncrTclEnsemble> getEnsembles() {
        this.initialize();
        return this.ensembles;
    }

    public void setEnsembles(List<IncrTclEnsemble> ensembles) {
        this.ensembles = ensembles;
        this.initialize();
    }

    public List<IncrTclEnsemblePart> getParts() {
        this.initialize();
        return this.parts;
    }

    public void setParts(List<IncrTclEnsemblePart> parts) {
        this.parts = parts;
        this.initialize();
    }

    public void addPart(IncrTclEnsemblePart part) {
        this.initialize();
        this.parts.add(part);
    }
}

