/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.viewsupport;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class ContextActivator
implements IWindowListener,
IPartListener2 {
    private static ContextActivator sInstance = new ContextActivator();
    private Map<ContentOutline, IContextActivation> fActivationPerOutline = new HashMap<ContentOutline, IContextActivation>();
    private Map<CommonNavigator, SelectionListener> fActivationPerNavigator = new HashMap<CommonNavigator, SelectionListener>();
    private Collection<IWorkbenchWindow> fWindows = new HashSet<IWorkbenchWindow>();

    private ContextActivator() {
    }

    public static ContextActivator getInstance() {
        return sInstance;
    }

    public void install() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchPartReference part;
            IWorkbenchPage activePage;
            workbench.addWindowListener((IWindowListener)this);
            IWorkbenchWindow[] wnds = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < wnds.length) {
                IWorkbenchWindow window = wnds[i];
                this.register(window);
                ++i;
            }
            IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (ww != null && (activePage = ww.getActivePage()) != null && (part = activePage.getActivePartReference()) != null) {
                this.partActivated(part);
            }
        }
    }

    public void uninstall() {
        for (IWorkbenchWindow window : this.fWindows) {
            this.unregister(window);
        }
        for (SelectionListener l : this.fActivationPerNavigator.values()) {
            l.uninstall();
        }
    }

    private void register(IWorkbenchWindow wnd) {
        wnd.getPartService().addPartListener((IPartListener2)this);
        this.fWindows.add(wnd);
    }

    private void unregister(IWorkbenchWindow wnd) {
        wnd.getPartService().removePartListener((IPartListener2)this);
        this.fWindows.remove(wnd);
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.register(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.unregister(window);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    private void onContentOutlineClosed(ContentOutline outline) {
        this.fActivationPerOutline.remove(outline);
    }

    private void onContentOutlineActivated(ContentOutline outline) {
        IPage page = outline.getCurrentPage();
        if (page instanceof ScriptOutlinePage) {
            if (!this.fActivationPerOutline.containsKey(outline)) {
                IContextService ctxtService = (IContextService)outline.getViewSite().getService(IContextService.class);
                IContextActivation activateContext = ctxtService.activateContext("org.eclipse.dltk.ui.context.views");
                this.fActivationPerOutline.put(outline, activateContext);
            }
        } else {
            IContextActivation activation = this.fActivationPerOutline.remove(outline);
            if (activation != null) {
                IContextService ctxtService = (IContextService)outline.getViewSite().getService(IContextService.class);
                ctxtService.deactivateContext(activation);
            }
        }
    }

    private void onCommonNavigatorActivated(CommonNavigator part) {
        SelectionListener l = this.fActivationPerNavigator.get(part);
        if (l == null) {
            l = new SelectionListener(part.getSite());
            this.fActivationPerNavigator.put(part, l);
        }
    }

    private void onCommonNavigatorClosed(CommonNavigator part) {
        this.fActivationPerNavigator.remove(part);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof ContentOutline) {
            this.onContentOutlineActivated((ContentOutline)part);
        } else if (part instanceof CommonNavigator) {
            this.onCommonNavigatorActivated((CommonNavigator)part);
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof ContentOutline) {
            this.onContentOutlineClosed((ContentOutline)part);
        } else if (part instanceof CommonNavigator) {
            this.onCommonNavigatorClosed((CommonNavigator)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private static class SelectionListener
    implements ISelectionChangedListener {
        private IWorkbenchPartSite fSite;
        private IContextService fCtxService;
        private IContextActivation fActivation;

        public SelectionListener(IWorkbenchPartSite site) {
            this.fSite = site;
            this.fCtxService = (IContextService)this.fSite.getService(IContextService.class);
            ISelectionProvider sp = site.getSelectionProvider();
            if (sp != null && this.fCtxService != null) {
                sp.addSelectionChangedListener((ISelectionChangedListener)this);
                this.onNewSelection(sp.getSelection());
            }
        }

        public void uninstall() {
            ISelectionProvider sp = this.fSite.getSelectionProvider();
            if (sp != null && this.fCtxService != null) {
                this.onNewSelection(null);
                sp.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.onNewSelection(event.getSelection());
        }

        private void onNewSelection(ISelection selection) {
            boolean isRelevant = false;
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof ModelElement) {
                isRelevant = true;
            }
            if (isRelevant) {
                if (this.fActivation == null) {
                    this.fActivation = this.fCtxService.activateContext("org.eclipse.dltk.ui.context.views");
                }
            } else if (this.fActivation != null) {
                this.fCtxService.deactivateContext(this.fActivation);
                this.fActivation = null;
            }
        }
    }
}

