/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.VariablesUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.debugger.CurrentContextExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsUtil;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsValueDeserializer;
import org.eclipse.php.internal.debug.core.zend.debugger.StackVariable;

public class DefaultExpressionsManager
implements ExpressionsManager {
    private static final Expression[] EMPTY_VARIABLE_ARRAY = new Expression[0];
    private static final byte[] ILLEGAL_VAR = new byte[]{78};
    private Debugger debugger;
    private Map<String, Object> hashResultDepthOne = new HashMap<String, Object>();
    private Map<String, byte[]> hashResultDepthZero = new HashMap<String, byte[]>();
    private ExpressionsValueDeserializer expressionValueDeserializer;
    private ExpressionsUtil fExpressionsUtil;

    public DefaultExpressionsManager(Debugger debugger, String transferEncoding) {
        this.debugger = debugger;
        this.expressionValueDeserializer = new ExpressionsValueDeserializer(transferEncoding);
        this.fExpressionsUtil = ExpressionsUtil.getInstance(this);
    }

    @Override
    public byte[] getExpressionValue(Expression expression, int depth) {
        if (!this.debugger.isActive()) {
            return ILLEGAL_VAR;
        }
        if (expression instanceof StackVariable) {
            return this.getStackVariableValue((StackVariable)expression, depth);
        }
        String[] name = DefaultExpressionsManager.minimizeArray(expression.getName());
        return this.getVariableValue(name, depth);
    }

    @Override
    public boolean assignValue(Expression expression, String value, int depth) {
        String[] name = DefaultExpressionsManager.minimizeArray(expression.getName());
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        boolean status = true;
        status = this.debugger.assignValue(name[0], value, depth, path);
        byte[] eValue = this.debugger.getVariableValue(name[0], depth, path);
        if (status) {
            String key = DefaultExpressionsManager.buildKey(name);
            if (depth == 1) {
                this.hashResultDepthOne.put(key, eValue);
            } else if (depth == 0) {
                this.hashResultDepthZero.put(key, eValue);
            }
        }
        return status;
    }

    @Override
    public Expression[] getCurrentVariables(int depth) {
        Expression staticClassContext;
        byte[] value;
        Expression contextExpression = CurrentContextExpression.build(this.debugger);
        ExpressionValue variableValue = this.expressionValueDeserializer.deserializer(contextExpression, value = this.getExpressionValue(contextExpression, depth));
        Object[] variables = variableValue.getOriChildren();
        if (variables == null || variables.length == 0) {
            return EMPTY_VARIABLE_ARRAY;
        }
        boolean hasThis = false;
        ArrayList<Expression> currentVariables = new ArrayList<Expression>();
        int i = 0;
        while (i < variables.length - 1) {
            String s = variables[i].getFullName();
            if (!s.equals("$GLOBALS")) {
                if (s.equals("$this")) {
                    hasThis = true;
                }
                currentVariables.add(variables[i]);
            }
            ++i;
        }
        Expression dummyClass = variables[variables.length - 1];
        String className = (String)dummyClass.getValue().getValue();
        if (!hasThis && !"0".equals(className) && (staticClassContext = this.fExpressionsUtil.fetchStaticContext(className)) != null) {
            currentVariables.add(staticClassContext);
        }
        variables = currentVariables.toArray(new Expression[currentVariables.size()]);
        VariablesUtil.sortContextMembers(variables);
        this.hashResultDepthOne.put("LOCALS", variables);
        return variables;
    }

    @Override
    public Expression buildExpression(String name) {
        return new DefaultExpression(name);
    }

    @Override
    public void update(Expression expression, int depth) {
        if (expression.getValue().getDataType() == IPHPDataType.DataType.PHP_VIRTUAL_CLASS) {
            return;
        }
        byte[] value = this.getExpressionValue(expression, depth);
        ExpressionValue expressionValue = this.expressionValueDeserializer.deserializer(expression, value);
        if (expressionValue.getDataType() == IPHPDataType.DataType.PHP_OBJECT && CurrentContextExpression.supportsStaticContext(this.debugger)) {
            Expression[] expressionStaticNodes = this.fExpressionsUtil.fetchStaticMembers((String)expressionValue.getValue());
            ArrayList<Expression> allNodes = new ArrayList<Expression>();
            allNodes.addAll(Arrays.asList(expressionStaticNodes));
            allNodes.addAll(Arrays.asList(expressionValue.getChildren()));
            expressionValue = new ExpressionValue(IPHPDataType.DataType.PHP_OBJECT, expressionValue.getValue(), expressionValue.getValueAsString(), allNodes.toArray(new Expression[allNodes.size()]), expressionValue.getChildrenCount() + expressionStaticNodes.length);
        }
        if (!PHPProjectPreferences.isSortByName() && expressionValue.getDataType() == IPHPDataType.DataType.PHP_OBJECT) {
            VariablesUtil.sortObjectMembers(expressionValue.getOriChildren());
        }
        expression.setValue(expressionValue);
    }

    private byte[] getVariableValue(String[] name, int depth) {
        String key = DefaultExpressionsManager.buildKey(name);
        if (this.hashResultDepthOne.containsKey(key)) {
            return (byte[])this.hashResultDepthOne.get(key);
        }
        if (depth == 0 && this.hashResultDepthZero.containsKey(key)) {
            return this.hashResultDepthZero.get(key);
        }
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        byte[] value = this.debugger.getVariableValue(name[0], depth, path);
        if (value != null) {
            if (depth == 1) {
                this.hashResultDepthOne.put(key, value);
            } else if (depth == 0) {
                this.hashResultDepthZero.put(key, value);
            }
        } else {
            value = new byte[]{78};
        }
        return value;
    }

    private byte[] getStackVariableValue(StackVariable variable, int depth) {
        int layer = variable.getStackDepth();
        String[] name = variable.getName();
        String[] path = new String[name.length - 1];
        System.arraycopy(name, 1, path, 0, name.length - 1);
        return this.debugger.getStackVariableValue(layer, name[0], depth, path);
    }

    private static String buildKey(String[] name) {
        StringBuilder buffer = new StringBuilder(name.length * 5);
        int i = 0;
        while (i < name.length) {
            buffer.append(name[i]);
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    private static String[] minimizeArray(String[] name) {
        Object firstName = name[0];
        if (((String)firstName).startsWith("$GLOBALS[GLOBALS]")) {
            name[0] = firstName = "$GLOBALS" + ((String)firstName).substring(17);
            return DefaultExpressionsManager.minimizeArray(name);
        }
        if (name.length < 2) {
            return name;
        }
        if (name[0].equals("get_defined_vars()") && name[1].equals("GLOBALS")) {
            String[] newName = new String[name.length - 1];
            newName[0] = "$GLOBALS";
            System.arraycopy(name, 2, newName, 1, name.length - 2);
            return DefaultExpressionsManager.minimizeArray(newName);
        }
        if (name[0].equals("$GLOBALS") && name[1].equals("GLOBALS")) {
            String[] newName = new String[name.length - 1];
            newName[0] = name[0];
            System.arraycopy(name, 2, newName, 1, name.length - 2);
            return DefaultExpressionsManager.minimizeArray(newName);
        }
        return name;
    }
}

