/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;

@Immutable
public abstract class MIEvent<V extends IDMContext>
extends AbstractDMEvent<V> {
    private final int fToken;
    private final MIResult[] fResults;

    public MIEvent(V dmc, int token, MIResult[] results) {
        super(dmc);
        this.fToken = token;
        this.fResults = results;
    }

    public int getToken() {
        return this.fToken;
    }

    public MIResult[] getResults() {
        return this.fResults;
    }

    public String toString() {
        if (this.fResults == null) {
            return super.toString();
        }
        if (this.fResults.length == 1) {
            return this.fResults[0].toString();
        }
        StringBuilder builder = new StringBuilder();
        MIResult[] mIResultArray = this.fResults;
        int n = this.fResults.length;
        int n2 = 0;
        while (n2 < n) {
            MIResult result = mIResultArray[n2];
            builder.append(result);
            builder.append('\n');
            ++n2;
        }
        return builder.toString();
    }
}

