/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class PingJob
extends Job {
    private IConnectionProfile icp;
    private Shell shell;

    public PingJob(Shell shell, IConnectionProfile profile) {
        super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.job"));
        this.setSystem(false);
        this.setUser(true);
        this.shell = shell;
        this.icp = profile;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
        IConnection con = PingJob.createTestConnection(this.icp);
        monitor.done();
        new PingUIJob(this.shell, PingJob.getTestConnectionException(con)).schedule();
        if (con != null) {
            con.close();
        }
        return Status.OK_STATUS;
    }

    public static IConnection createTestConnection(IConnectionProfile icp) {
        if (icp == null) {
            return null;
        }
        return icp.createConnection("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
    }

    public static Throwable getTestConnectionException(IConnection conn) {
        return conn != null ? conn.getConnectException() : new RuntimeException(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"));
    }

    public static class PingUIJob
    extends UIJob {
        private Shell shell;
        private Throwable exception;

        public PingUIJob(Shell shell, Throwable exception) {
            super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.uijob"));
            this.setSystem(false);
            this.exception = exception;
            this.shell = shell;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            PingUIJob.showTestConnectionMessage(this.shell, this.exception);
            return Status.OK_STATUS;
        }

        public static void showTestConnectionMessage(Shell shell, Throwable exception) {
            if (exception == null) {
                MessageDialog.openInformation((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.success"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.success"));
            } else {
                ExceptionHandler.showException(shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), exception);
            }
        }
    }
}

