/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.core.IRepositoryTag;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.RepositoryTag;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DockerImageTagSearchResult;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageSearchModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageSearchPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ImageTagSelectionPage
extends WizardPage {
    private final ImageSearchModel model;
    private final DataBindingContext ctx = new DataBindingContext();
    private IRegistry registry;

    public ImageTagSelectionPage(ImageSearchModel model, IRegistry registry) {
        super("ImageTagSelectionPage", WizardMessages.getString("ImageTagSelectionPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImageTagSelectionPage.title"));
        this.model = model;
        this.registry = registry;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.searchTags();
        }
    }

    private void searchTags() {
        try {
            ArrayBlockingQueue searchResultQueue = new ArrayBlockingQueue(1);
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask(WizardMessages.getString("ImageTagSelectionPage.searchTask"), 2);
                String selectedImageName = this.model.getSelectedImage().getName();
                try {
                    List repositoryTags = this.registry.getTags(selectedImageName);
                    List<RepositoryTag> tags = repositoryTags.stream().map(c -> (RepositoryTag)c).toList();
                    Collections.sort(tags);
                    monitor.worked(1);
                    IDockerConnection connection = this.model.getSelectedConnection();
                    List<DockerImageTagSearchResult> searchResults = repositoryTags.stream().map(t -> new DockerImageTagSearchResult(selectedImageName, (IRepositoryTag)t, connection.hasImage(selectedImageName, t.getName()))).toList();
                    monitor.worked(1);
                    searchResultQueue.offer(searchResults);
                }
                catch (DockerException dockerException) {
                }
                finally {
                    monitor.done();
                }
            });
            List res = (List)searchResultQueue.poll(10L, TimeUnit.SECONDS);
            List searchResult = res == null ? new ArrayList() : res;
            Display.getCurrent().asyncExec(() -> {
                this.model.setImageTagSearchResult(searchResult);
                this.getWizard().getContainer().updateButtons();
            });
            if (searchResult.isEmpty()) {
                this.setMessage(WizardMessages.getString("ImageTagSelectionPage.noTagWarning"), 2);
            } else if (searchResult.size() == 1) {
                this.setMessage(WizardMessages.getString("ImageTagSelectionPage.oneTagMatched"), 1);
            } else {
                this.setMessage(WizardMessages.getFormattedString("ImageTagSelectionPage.tagsMatched", Integer.toString(searchResult.size())), 1);
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    public DockerImageTagSearchResult getSelectedImageTag() {
        return this.model.getSelectedImageTag();
    }

    public boolean isPageComplete() {
        return this.model.getSelectedImageTag() != null;
    }

    public void dispose() {
        this.ctx.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        boolean COLUMNS = true;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(6, 6).spacing(10, 2).applyTo(container);
        Table table = new Table(container, 68352);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(1, 1).hint(200, 200).applyTo((Control)table);
        TableViewer tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addTableViewerColum(tableViewer, WizardMessages.getString("ImageTagSelectionPage.column.tag"), 0, 16384, 200, (CellLabelProvider)new RepositoryTagColumnLabelProvider());
        this.addTableViewerColum(tableViewer, WizardMessages.getString("ImageTagSelectionPage.column.layer"), 0, 16384, 200, (CellLabelProvider)new RepositoryLayerColumnLabelProvider());
        this.addTableViewerColum(tableViewer, WizardMessages.getString("ImageTagSelectionPage.column.localcopy"), 0, 16384, 75, (CellLabelProvider)new ImagePulledColumnLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        IObservableList observableSearchResultModel = BeanProperties.list(ImageSearchModel.class, (String)"imageTagSearchResult").observe((Object)this.model);
        tableViewer.setInput((Object)observableSearchResultModel);
        this.ctx.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)tableViewer), BeanProperties.value((String)"selectedImageTag").observe((Object)this.model));
        this.setControl((Control)container);
    }

    private TableViewerColumn addTableViewerColum(TableViewer tableViewer, String title, int style, int alignment, int width, CellLabelProvider columnLabelProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setAlignment(alignment);
        column.setWidth(width);
        viewerColumn.setLabelProvider(columnLabelProvider);
        return viewerColumn;
    }

    static class RepositoryTagColumnLabelProvider
    extends ColumnLabelProvider {
        RepositoryTagColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DockerImageTagSearchResult) {
                return ((DockerImageTagSearchResult)element).getName();
            }
            return super.getText(element);
        }
    }

    static class RepositoryLayerColumnLabelProvider
    extends ColumnLabelProvider {
        RepositoryLayerColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DockerImageTagSearchResult) {
                String layer = ((DockerImageTagSearchResult)element).getLayer();
                if (layer == null || layer.equals("Unknown")) {
                    return "";
                }
                return layer;
            }
            return super.getText(element);
        }
    }

    static class ImagePulledColumnLabelProvider
    extends ImageSearchPage.IconColumnLabelProvider {
        ImagePulledColumnLabelProvider() {
        }

        @Override
        boolean doPaint(Object element) {
            return element instanceof DockerImageTagSearchResult && ((DockerImageTagSearchResult)element).isResolved();
        }
    }
}

