/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.infra.browser.editor.ui.internal.editor.TreeEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && activeEditor instanceof TreeEditor) {
            ArrayList<String> names = new ArrayList<String>();
            TreeEditor editor = (TreeEditor)activeEditor;
            ILabelProvider labelProvider = editor.getViewerLabelProvider();
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object item : structSelection) {
                String name = labelProvider.getText(item);
                names.add(name);
            }
            if (!names.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                for (String name : names) {
                    buffer.append(name);
                    buffer.append('\n');
                }
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                Clipboard clipboard = new Clipboard(shell.getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{buffer.toString().replaceAll("\n$", "")}, new Transfer[]{textTransfer});
            }
        }
        return null;
    }
}

