/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console;

import com.google.inject.Injector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.common.internal.preferences.BooleanPreference;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.xtext.console.ColorManager;
import org.eclipse.ocl.examples.xtext.console.OCLConsole;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.actions.CloseAction;
import org.eclipse.ocl.examples.xtext.console.actions.DebugAction;
import org.eclipse.ocl.examples.xtext.console.actions.LoadExpressionAction;
import org.eclipse.ocl.examples.xtext.console.actions.SaveExpressionAction;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.AbstractLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.options.PivotConsoleOptions;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocument;
import org.eclipse.ocl.xtext.base.ui.utilities.BaseUIUtil;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.DefaultContentAssistantFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OCLConsolePage
extends Page {
    private final OCLConsole console;
    private Composite page;
    private ITextViewer output;
    private ColorManager colorManager;
    private SourceViewer input;
    private EmbeddedXtextEditor editor;
    private String lastOCLExpression;
    private DebugAction debugAction;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private @Nullable EObject contextObject = null;
    private @Nullable Iterable<@NonNull Class> contextModelClasses = null;
    private ParserContext parserContext;

    protected OCLConsolePage(OCLConsole console) {
        this.console = console;
    }

    protected void append(String text, RGB rgb, boolean bold) {
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLength();
            text = String.valueOf(text != null ? text : "") + '\n';
            int length = text.length();
            if (offset > 0) {
                doc.replace(offset, 0, text);
            } else {
                doc.set(text);
            }
            StyleRange style = new StyleRange();
            style.start = offset;
            style.length = length;
            style.foreground = this.colorManager.getColor(rgb);
            if (bold) {
                style.fontStyle = 1;
            }
            this.output.getTextWidget().setStyleRange(style);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, XtextConsolePlugin.getPluginId(), 1, ConsoleMessages.Output_Exception, (Throwable)e);
            XtextConsolePlugin.getInstance().getLog().log((IStatus)status);
        }
    }

    public void cancelValidation() {
        BaseDocument editorDocument = this.getEditorDocument();
        Job validationJob = editorDocument.getValidationJob();
        if (validationJob != null) {
            validationJob.cancel();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            while (validationJob.getState() == 4) {
                validationJob.cancel();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void createControl(Composite parent) {
        this.page = new SashForm(parent, 0x2000200);
        this.output = new TextViewer(this.page, 2818);
        this.output.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.output.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.output.setEditable(false);
        this.output.setDocument((IDocument)new Document());
        this.colorManager = new ColorManager();
        this.createEditor(this.page);
        this.input = this.editor.getViewer();
        this.input.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.input.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
                OutlinePage outlinePage;
                IXtextDocument xtextDocument;
                Element pivotElement;
                ContentOutline contentOutline;
                IPage currentPage;
                IConsole console;
                if (part instanceof IConsoleView && (console = ((IConsoleView)part).getConsole()) instanceof OCLConsole) {
                    return;
                }
                if (part instanceof ContentOutline && (currentPage = (contentOutline = (ContentOutline)part).getCurrentPage()) instanceof OutlinePage && (pivotElement = (Element)(xtextDocument = (outlinePage = (OutlinePage)currentPage).getXtextDocument()).readOnly((IUnitOfWork)new IUnitOfWork<Element, XtextResource>(){

                    public Element exec(@Nullable XtextResource state) throws Exception {
                        Element pivotObject;
                        EObject csObject;
                        EObjectNode eObjectNode;
                        URI uri;
                        Object selectedObject;
                        IStructuredSelection structuredSelection;
                        if (state != null && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedObject = structuredSelection.getFirstElement()) instanceof EObjectNode && (uri = (eObjectNode = (EObjectNode)selectedObject).getEObjectURI()) != null && (csObject = state.getEObject(uri.fragment())) instanceof Pivotable && (pivotObject = ((Pivotable)csObject).getPivot()) != null) {
                            return pivotObject;
                        }
                        return null;
                    }
                })) != null) {
                    OCLConsolePage.this.selectionChanged((ISelection)new StructuredSelection((Object)pivotElement));
                    return;
                }
                OCLConsolePage.this.selectionChanged(selection);
            }
        };
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionService.addPostSelectionListener(this.selectionListener);
        ISelection selection = BaseUIUtil.getActiveSelection((IWorkbenchSite)this.getSite());
        this.selectionChanged(selection);
        ((SashForm)this.page).setWeights(new int[]{2, 1});
        ClearOutputAction clear = new ClearOutputAction(this.output);
        CloseAction close = new CloseAction();
        SaveExpressionAction saveExpression = new SaveExpressionAction(this);
        LoadExpressionAction loadExpression = new LoadExpressionAction(this);
        this.debugAction = new DebugAction(this);
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        menu.add((IAction)loadExpression);
        menu.add((IAction)saveExpression);
        menu.add((IAction)clear);
        menu.add((IAction)close);
        menu.add((IAction)this.debugAction);
        IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
        toolbar.appendToGroup("outputGroup", (IAction)loadExpression);
        toolbar.appendToGroup("outputGroup", (IAction)saveExpression);
        toolbar.appendToGroup("outputGroup", (IAction)clear);
        toolbar.appendToGroup("outputGroup", (IAction)close);
        toolbar.appendToGroup("outputGroup", (IAction)this.debugAction);
    }

    private int convertHeightInCharsToPixels(int i) {
        GC gc = new GC((Drawable)Display.getDefault());
        gc.setFont(this.editor.getViewer().getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int ret = (fontMetrics.getHeight() + fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading()) * i;
        gc.dispose();
        return ret;
    }

    protected @Nullable EnvironmentFactoryAdapter createEditor(Composite s1) {
        Composite client = s1;
        Injector injector = XtextConsolePlugin.getInstance().getInjector("org.eclipse.ocl.xtext.essentialocl.EssentialOCL");
        Composite editorComposite = client;
        EnvironmentFactoryInternal currentEnvironmentFactory = ThreadLocalExecutor.basicGetEnvironmentFactory();
        this.editor = new EmbeddedXtextEditor(editorComposite, injector, 770, currentEnvironmentFactory);
        this.editor.getViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if ((e.keyCode == 0x1000050 || e.keyCode == 13) && (e.stateMask & 0x60000) == 0) {
                    e.doit = false;
                }
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        editorComposite.setLayoutData((Object)data);
        ResourceSet resourceSet = this.editor.getResourceSet();
        return resourceSet != null ? EnvironmentFactoryAdapter.find((Notifier)resourceSet) : null;
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        this.colorManager.dispose();
        this.selectionService.removePostSelectionListener(this.selectionListener);
        this.reset();
        super.dispose();
    }

    private void error(String message) {
        this.append(message, ColorManager.OUTPUT_ERROR, false);
        this.scrollText();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean evaluate(final String expression) {
        if (expression == null || expression.trim().length() <= 0) {
            this.error(ConsoleMessages.Result_NoExpression);
            return false;
        }
        result = true;
        try {
            block17: {
                doc = this.getDocument();
                if (doc.getLength() > 0) {
                    this.append("", ColorManager.DEFAULT, false);
                }
                this.append(ConsoleMessages.Heading_Evaluating, ColorManager.DEFAULT, true);
                this.append(expression, ColorManager.DEFAULT, false);
                this.append(ConsoleMessages.Heading_Results, ColorManager.DEFAULT, true);
                editorDocument = this.getEditorDocument();
                value = null;
                try {
                    value = editorDocument.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                        public Object exec(@Nullable XtextResource state) throws Exception {
                            if (state != null) {
                                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                                EvaluationRunnable runnable = new EvaluationRunnable((CSResource)state, expression);
                                progressService.busyCursorWhile((IRunnableWithProgress)runnable);
                                return runnable.getValue();
                            }
                            return null;
                        }
                    });
                    break block17;
                }
                catch (Throwable e) {
                    ** while (e.getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    e = e.getCause();
                    continue;
                }
lbl21:
                // 1 sources

                this.append(e.toString(), ColorManager.OUTPUT_ERROR, false);
            }
            if (value instanceof InvalidValueException) {
                exception = (InvalidValueException)value;
                this.append(exception.getMessage(), ColorManager.OUTPUT_ERROR, true);
                cause = exception.getCause();
                if (cause != null && cause != exception) {
                    if (cause instanceof ParserException) {
                        this.append(cause.getMessage(), ColorManager.OUTPUT_ERROR, false);
                    } else {
                        s = new StringWriter();
                        pw = new PrintWriter(s);
                        cause.printStackTrace(pw);
                        this.append(s.toString(), ColorManager.OUTPUT_ERROR, false);
                    }
                }
            } else if (value != null) {
                collectionValue = ValueUtil.isCollectionValue((Object)value);
                if (collectionValue != null) {
                    for (T elementValue : collectionValue.iterable()) {
                        this.append(ValueUtil.stringValueOf(elementValue), ColorManager.OUTPUT_RESULTS, false);
                    }
                } else {
                    this.append(ValueUtil.stringValueOf((Object)value), ColorManager.OUTPUT_RESULTS, false);
                }
            } else {
                this.append(ValueUtil.stringValueOf((Object)value), ColorManager.OUTPUT_ERROR, false);
            }
            this.scrollText();
            this.lastOCLExpression = expression;
        }
        catch (Exception e) {
            result = false;
            this.error(e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage());
        }
        return result;
    }

    protected void flushEvents() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        while (workbench.getDisplay().readAndDispatch()) {
        }
    }

    public @Nullable EObject getContextObject() {
        return this.contextObject;
    }

    public Control getControl() {
        return this.page;
    }

    private IDocument getDocument() {
        return this.output.getDocument();
    }

    public IXtextDocument getDocument(URI trimFragment) {
        return this.getEditorDocument();
    }

    public BaseDocument getEditorDocument() {
        return (BaseDocument)this.editor.getDocument();
    }

    public OCL getEditorOCL() {
        return this.editor.getOCL();
    }

    public String getLastOCLExpression() {
        return this.lastOCLExpression;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory(@Nullable EObject contextObject) {
        Resource contextResource;
        ResourceSet contextResourceSet = null;
        if (contextObject != null && (contextResource = contextObject.eResource()) != null) {
            contextResourceSet = contextResource.getResourceSet();
        }
        this.editor.setContext(contextResourceSet);
        return this.editor.getEnvironmentFactory();
    }

    protected ILaunch internalLaunchDebugger() {
        return this.debugAction.launch();
    }

    protected void popUpModelTypesUsageInformation() {
        final Shell shell = this.getControl().getShell();
        if (!shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)shell, (String)ConsoleMessages.ModelTypesUsage_Title, (String)ConsoleMessages.ModelTypesUsage_Message);
                }
            });
        }
    }

    protected void refreshSelection(final Object selected) {
        block5: {
            if (this.getControl().isDisposed()) {
                return;
            }
            BaseDocument editorDocument = this.getEditorDocument();
            try {
                editorDocument.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                    /*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    public Value exec(@Nullable XtextResource resource) throws Exception {
                        EObject instanceContext;
                        Object selectedObject = selected;
                        if (selectedObject instanceof IAdaptable) {
                            boolean isNonNull;
                            Object adapted = ((IAdaptable)selectedObject).getAdapter(EObject.class);
                            boolean bl = isNonNull = adapted != null;
                            if (isNonNull) {
                                selectedObject = adapted;
                            }
                        }
                        if (selectedObject instanceof EObject) {
                            OCLConsolePage.this.contextObject = (EObject)selectedObject;
                        } else {
                            OCLConsolePage.this.contextObject = null;
                        }
                        if (resource instanceof BaseCSResource) {
                            ((BaseCSResource)resource).dispose();
                        }
                        EnvironmentFactoryInternal environmentFactory = ThreadLocalExecutor.getEnvironmentFactory();
                        IdResolver.IdResolverExtension idResolver = (IdResolver.IdResolverExtension)environmentFactory.getIdResolver();
                        Class staticType = idResolver.getStaticTypeOfValue(null, (Object)OCLConsolePage.this.contextObject);
                        Class contextType = environmentFactory.getMetamodelManager().getPrimaryClass(staticType);
                        @NonNull Iterable savedContextModelClasses = OCLConsolePage.this.contextModelClasses;
                        OCLConsolePage.this.contextModelClasses = OCLConsolePage.this.contextObject != null ? idResolver.getModelClassesOf((Object)OCLConsolePage.this.contextObject) : null;
                        BooleanPreference option = PivotConsoleOptions.ConsoleModeltypesInformation;
                        if (OCLConsolePage.this.contextModelClasses != null && !OCLConsolePage.this.contextModelClasses.equals(savedContextModelClasses) && ((Boolean)option.getPreferredValue()).booleanValue()) {
                            OCLConsolePage.this.popUpModelTypesUsageInformation();
                        }
                        if ((instanceContext = OCLConsolePage.this.contextObject) != null && !(instanceContext instanceof Element)) {
                            instanceContext = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory).getASOf(Element.class, instanceContext);
                        }
                        OCLConsolePage.this.parserContext = (ParserContext)new ClassContext((EnvironmentFactory)environmentFactory, null, contextType, instanceContext instanceof Type && !(instanceContext instanceof ElementExtension) ? (Type)instanceContext : null);
                        EssentialOCLCSResource csResource = (EssentialOCLCSResource)resource;
                        if (csResource != null) {
                            ResourceSet resourceSet;
                            if (OCLConsolePage.this.contextObject != null) {
                                csResource.getCS2AS();
                            }
                            if ((resourceSet = OCLConsolePage.this.editor.getResourceSet()) != null) {
                                environmentFactory.adapt((Notifier)resourceSet);
                            }
                            csResource.setParserContext(OCLConsolePage.this.parserContext);
                        }
                        OCLConsolePage.this.console.setSelection(OCLConsolePage.this.contextObject, contextType);
                        return null;
                    }
                });
            }
            catch (WrappedException e) {
                Shell shell = this.getControl().getShell();
                if (!shell.isDisposed()) {
                    Throwable t = e.getCause();
                    Status status = new Status(4, "org.eclipse.ocl.examples.xtext.console", t.getLocalizedMessage(), t);
                    ErrorDialog.openError((Shell)shell, (String)ConsoleMessages.SelectionError_Title, (String)ConsoleMessages.SelectionError_Message, (IStatus)status);
                    this.console.setSelection(null, null);
                }
            }
            catch (Exception e) {
                Shell shell = this.getControl().getShell();
                if (shell.isDisposed()) break block5;
                Status status = new Status(4, "org.eclipse.ocl.examples.xtext.console", e.getLocalizedMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)shell, (String)ConsoleMessages.SelectionError_Title, (String)ConsoleMessages.SelectionError_Message, (IStatus)status);
                this.console.setSelection(null, null);
            }
        }
    }

    public void reset() {
        if (this.editor != null) {
            this.flushEvents();
        }
        this.parserContext = null;
        this.contextObject = null;
    }

    protected void resetDocument() {
        IDocument doc = this.getDocument();
        if (doc != null) {
            doc.set("");
        }
    }

    private void scrollText() {
        this.output.revealRange(this.getDocument().getLength(), 0);
    }

    private void selectionChanged(ISelection sel) {
        VMVariableData vmVar;
        Object selectedObject = BaseUIUtil.getSelectedObject((ISelection)sel, (IWorkbenchSite)this.getSite());
        if (selectedObject instanceof VMVariable && (vmVar = ((VMVariable)selectedObject).getVmVar()) != null) {
            selectedObject = vmVar.valueObject;
        }
        this.refreshSelection(selectedObject);
    }

    public void setFocus() {
        this.input.getTextWidget().setFocus();
    }

    public static enum ColorChoices {
        DEFAULT,
        ERROR;

    }

    private class EvaluationRunnable
    implements IRunnableWithProgress {
        private final @NonNull CSResource resource;
        private final @NonNull String expression;
        private Object value = null;

        public EvaluationRunnable(@NonNull CSResource resource, String expression) {
            this.resource = resource;
            this.expression = expression;
        }

        public Object getValue() {
            return this.value;
        }

        /*
         * Loose catch block
         */
        public void run(IProgressMonitor monitor) {
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Progress_Title, (Object)this.expression), 10);
            monitor.subTask(ConsoleMessages.Progress_Synchronising);
            monitor.worked(1);
            EnvironmentFactoryInternal environmentFactory = (EnvironmentFactoryInternal)OCLConsolePage.this.editor.getEnvironmentFactory();
            ThreadLocalExecutor.attachEnvironmentFactory((EnvironmentFactoryInternal)environmentFactory);
            try {
                block17: {
                    ExpressionInOCL expressionInOCL;
                    try {
                        PivotUtil.checkResourceErrors((String)"", (Resource)this.resource);
                        expressionInOCL = OCLConsolePage.this.parserContext.getExpression(this.resource);
                    }
                    catch (ParserException e) {
                        this.value = new InvalidValueException((Exception)((Object)e), ConsoleMessages.Result_ParsingFailure);
                        ThreadLocalExecutor.detachEnvironmentFactory((EnvironmentFactory)environmentFactory);
                        return;
                    }
                    if (expressionInOCL != null) {
                        monitor.subTask(ConsoleMessages.Progress_Extent);
                        ModelManager modelManager = environmentFactory.createModelManager((Object)OCLConsolePage.this.contextObject);
                        assert (ThreadLocalExecutor.basicGetExecutor() == null);
                        ExecutorInternal executor = ((EnvironmentFactory.EnvironmentFactoryExtension)environmentFactory).createExecutor(modelManager);
                        ThreadLocalExecutor.setExecutor((Executor)executor);
                        executor.initializeEvaluationEnvironment((NamedElement)expressionInOCL);
                        EvaluationEnvironment evaluationEnvironment = executor.getRootEvaluationEnvironment();
                        Object contextValue = executor.getIdResolver().boxedValueOf((Object)OCLConsolePage.this.contextObject);
                        evaluationEnvironment.add((TypedElement)ClassUtil.nonNullModel((Object)expressionInOCL.getOwnedContext()), contextValue);
                        monitor.worked(2);
                        monitor.subTask(ConsoleMessages.Progress_Evaluating);
                        try {
                            EvaluationVisitor evaluationVisitor = executor.getEvaluationVisitor();
                            evaluationVisitor.setMonitor(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                            executor.setLogger((EvaluationLogger)new AbstractLogger(){

                                public void print(final @NonNull String message) {
                                    OCLConsolePage.this.getControl().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            OCLConsolePage.this.append(message, ColorManager.DEFAULT, false);
                                        }
                                    });
                                }
                            });
                            this.value = evaluationVisitor.visitExpressionInOCL(expressionInOCL);
                        }
                        catch (EvaluationHaltedException e) {
                            this.value = new InvalidValueException(ConsoleMessages.Result_EvaluationTerminated, new Object[0]);
                            ThreadLocalExecutor.setExecutor(null);
                            break block17;
                        }
                        catch (InvalidValueException e) {
                            this.value = e;
                            break block17;
                        }
                        catch (Exception e) {
                            this.value = new InvalidValueException(e, ConsoleMessages.Result_EvaluationFailure);
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            ThreadLocalExecutor.setExecutor(null);
                            break block17;
                        }
                        {
                            finally {
                                ThreadLocalExecutor.setExecutor(null);
                            }
                        }
                        ThreadLocalExecutor.setExecutor(null);
                    }
                }
                monitor.worked(4);
            }
            finally {
                ThreadLocalExecutor.detachEnvironmentFactory((EnvironmentFactory)environmentFactory);
            }
        }
    }

    private class InputKeyListener
    implements KeyListener {
        private boolean evaluationSuccess = false;
        private List<String> history = new ArrayList<String>();
        private int currentHistoryPointer = 0;

        private InputKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            IContentAssistant contentAssistant = OCLConsolePage.this.editor.getViewer().getContentAssistant();
            if (contentAssistant instanceof InterrogatableContentAssistant && ((InterrogatableContentAssistant)contentAssistant).isProposalPopupActive()) {
                return;
            }
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    String text = OCLConsolePage.this.getEditorDocument().get();
                    this.evaluationSuccess = OCLConsolePage.this.evaluate(text.trim());
                    break;
                }
                case 0x1000005: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    if (this.currentHistoryPointer == 0 && this.history.size() > 0) {
                        if (this.history.size() > 0 && this.history.get(0).length() == 0) {
                            this.history.remove(0);
                        }
                        this.history.add(0, OCLConsolePage.this.getEditorDocument().get().trim());
                        this.currentHistoryPointer = 1;
                        this.setTextFromHistory();
                        break;
                    }
                    if (this.currentHistoryPointer >= this.history.size() - 1) break;
                    ++this.currentHistoryPointer;
                    this.setTextFromHistory();
                    break;
                }
                case 0x1000006: {
                    if ((e.stateMask & 0x60000) != 0 || this.currentHistoryPointer <= 0) break;
                    --this.currentHistoryPointer;
                    this.setTextFromHistory();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    if (this.evaluationSuccess) {
                        OCLConsolePage.this.getEditorDocument().set("");
                        if (this.history.size() > 0 && this.history.get(0).trim().length() == 0) {
                            this.history.remove(0);
                        }
                        if (this.history.size() == 0 || !this.history.get(0).equals(OCLConsolePage.this.lastOCLExpression.trim())) {
                            this.history.add(0, OCLConsolePage.this.lastOCLExpression.trim());
                        }
                        this.currentHistoryPointer = 0;
                    }
                    this.evaluationSuccess = false;
                }
            }
        }

        protected void setTextFromHistory() {
            String newText = this.history.get(this.currentHistoryPointer);
            OCLConsolePage.this.getEditorDocument().set(newText);
            OCLConsolePage.this.input.setSelectedRange(newText.length(), 0);
        }
    }

    public static final class InterrogatableContentAssistant
    extends ContentAssistant {
        public boolean isProposalPopupActive() {
            return super.isProposalPopupActive();
        }
    }

    public static class InterrogatableContentAssistantFactory
    extends DefaultContentAssistantFactory {
        protected ContentAssistant createAssistant() {
            return new InterrogatableContentAssistant();
        }
    }
}

