/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.utilities;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.qvtd.umlx.RelDiagram;
import org.eclipse.qvtd.umlx.RelDomainNode;
import org.eclipse.qvtd.umlx.RelInvocationEdge;
import org.eclipse.qvtd.umlx.RelInvocationNode;
import org.eclipse.qvtd.umlx.RelPatternEdge;
import org.eclipse.qvtd.umlx.RelPatternNode;
import org.eclipse.qvtd.umlx.TxKeyNode;
import org.eclipse.qvtd.umlx.TxPackageNode;
import org.eclipse.qvtd.umlx.TxPartNode;
import org.eclipse.qvtd.umlx.TxQueryNode;
import org.eclipse.qvtd.umlx.TxTypedModelNode;
import org.eclipse.qvtd.umlx.UMLXElement;
import org.eclipse.qvtd.umlx.UMLXModel;
import org.eclipse.qvtd.umlx.UMLXNamedElement;
import org.eclipse.qvtd.umlx.UMLXTypedElement;
import org.eclipse.qvtd.umlx.util.AbstractExtendingUMLXVisitor;

public class UMLXToStringVisitor
extends AbstractExtendingUMLXVisitor<Object, StringBuilder> {
    public static @NonNull String toString(@NonNull UMLXElement umlxElement) {
        UMLXToStringVisitor umlxToStringVisitor = new UMLXToStringVisitor();
        umlxElement.accept(umlxToStringVisitor);
        return umlxToStringVisitor.toString();
    }

    protected UMLXToStringVisitor() {
        super(new StringBuilder());
    }

    private void append(@Nullable String string) {
        ((StringBuilder)this.context).append(string != null ? string : "null");
    }

    public @NonNull String toString() {
        return ((StringBuilder)this.context).toString();
    }

    @Override
    public @Nullable Object visitRelDomainNode(@NonNull RelDomainNode relDomainNode) {
        TxTypedModelNode txTypedModelNode = relDomainNode.getReferredTxTypedModelNode();
        this.append(txTypedModelNode != null ? txTypedModelNode.getName() : null);
        return null;
    }

    @Override
    public @Nullable Object visitRelInvocationEdge(@NonNull RelInvocationEdge relInvocationEdge) {
        RelPatternNode relPatternNode = relInvocationEdge.getReferredRelPatternNode();
        if (relPatternNode != null) {
            return relPatternNode.accept(this);
        }
        this.append(null);
        return null;
    }

    @Override
    public @Nullable Object visitRelInvocationNode(@NonNull RelInvocationNode relInvocationNode) {
        RelDiagram relDiagram = relInvocationNode.getReferredRelDiagram();
        this.append(relDiagram != null ? relDiagram.getName() : null);
        return null;
    }

    @Override
    public @Nullable Object visitRelPatternEdge(@NonNull RelPatternEdge relPatternEdge) {
        EStructuralFeature eStructuralFeature = relPatternEdge.getReferredEStructuralFeature();
        if (eStructuralFeature != null) {
            this.append(LabelUtil.getLabel((Object)eStructuralFeature));
        } else {
            this.append("\u00ab" + relPatternEdge.getSourceIndex() + "\u00bb");
        }
        return null;
    }

    @Override
    public @Nullable Object visitRelPatternNode(@NonNull RelPatternNode relPatternNode) {
        if (relPatternNode.isExpression().booleanValue()) {
            EList<String> lines = relPatternNode.getInitExpressionLines();
            if (lines.size() > 0) {
                boolean firstLine = true;
                for (String line : lines) {
                    if (!firstLine) {
                        this.append("\n");
                    }
                    this.append(line);
                    firstLine = false;
                }
            }
            return null;
        }
        this.visitUMLXTypedElement(relPatternNode);
        EList<String> lines = relPatternNode.getInitExpressionLines();
        if (lines.size() > 0) {
            this.append(" = ");
            boolean firstLine = true;
            for (String line : lines) {
                if (!firstLine) {
                    this.append("\n");
                }
                this.append(line);
                firstLine = false;
            }
        }
        return null;
    }

    @Override
    public @Nullable Object visitTxKeyNode(@NonNull TxKeyNode txKeyNode) {
        EClass eClassifier = txKeyNode.getReferredEClass();
        this.append(LabelUtil.getLabel((Object)eClassifier));
        return null;
    }

    @Override
    public @Nullable Object visitTxPackageNode(@NonNull TxPackageNode txPackageNode) {
        EPackage ePackage = txPackageNode.getReferredEPackage();
        this.append(LabelUtil.getLabel((Object)ePackage));
        return null;
    }

    @Override
    public @Nullable Object visitTxPartNode(@NonNull TxPartNode txPartNode) {
        EStructuralFeature eStructuralFeature = txPartNode.getReferredEStructuralFeature();
        if (txPartNode.isIsOpposite()) {
            this.append("~");
        }
        this.append(LabelUtil.getLabel((Object)eStructuralFeature));
        return null;
    }

    @Override
    public @Nullable Object visitTxQueryNode(@NonNull TxQueryNode txQueryNode) {
        this.visitUMLXTypedElement(txQueryNode);
        EList<String> lines = txQueryNode.getInitExpressionLines();
        if (lines.size() > 0) {
            this.append(" = ");
            boolean firstLine = true;
            for (String line : lines) {
                if (!firstLine) {
                    this.append("\n");
                }
                this.append(line);
                firstLine = false;
            }
        }
        return null;
    }

    @Override
    public @Nullable Object visitTxTypedModelNode(@NonNull TxTypedModelNode txTypedModelNode) {
        this.append(txTypedModelNode.getName());
        return null;
    }

    @Override
    public @Nullable Object visitUMLXModel(@NonNull UMLXModel umlxModel) {
        return "UMLXModel";
    }

    @Override
    public @Nullable Object visitUMLXNamedElement(@NonNull UMLXNamedElement umlxNamedElement) {
        this.append(umlxNamedElement.getName());
        return null;
    }

    @Override
    public @Nullable Object visitUMLXTypedElement(@NonNull UMLXTypedElement umlxTypedElement) {
        EClassifier eClassifier = umlxTypedElement.getReferredEClassifier();
        this.append(umlxTypedElement.getName());
        this.append(" : ");
        if (umlxTypedElement.isIsMany()) {
            if (umlxTypedElement.isIsUnique()) {
                this.append(umlxTypedElement.isIsOrdered() ? "OrderedSet" : "Set");
            } else {
                this.append(umlxTypedElement.isIsOrdered() ? "Sequence" : "Bag");
            }
            this.append("(");
            this.append(LabelUtil.getLabel((Object)eClassifier));
            this.append(umlxTypedElement.isIsNullFree() ? "[*|1]" : "[*|?]");
            this.append(")");
        } else {
            this.append(LabelUtil.getLabel((Object)eClassifier));
        }
        this.append(umlxTypedElement.isIsRequired() ? "[1]" : "[?]");
        return null;
    }

    @Override
    public @Nullable Object visiting(@NonNull UMLXElement umlxElement) {
        this.append("Unsupported " + this.getClass().getSimpleName() + " for " + umlxElement.eClass().getName());
        return null;
    }
}

