/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wildwebdeveloper.Activator;

public class FileUtils {
    public static final String FILE_SCHEME = "file";

    public static File uriToFile(String uri) {
        return Paths.get(URI.create(uri)).toFile();
    }

    public static Path uriToPath(String uri) {
        return Paths.get(URI.create(uri));
    }

    public static URI toUri(String filePath) {
        return FileUtils.toUri(new File(filePath));
    }

    public static URI toUri(File file) {
        try {
            String path = file.getAbsoluteFile().toURI().getPath();
            if (path.startsWith("//")) {
                int slash = path.indexOf(47, 2);
                String authority = slash > 2 ? path.substring(2, slash) : path.substring(2);
                String absPath = slash > 2 ? path.substring(slash) : "/";
                return new URI(FILE_SCHEME, authority, absPath, null);
            }
            return new URI(FILE_SCHEME, "", path, null);
        }
        catch (URISyntaxException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper", 0, ex.getMessage(), (Throwable)ex));
            return file.getAbsoluteFile().toURI();
        }
    }
}

