/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;

public class CASTFunctionDeclarator
extends CASTDeclarator
implements IASTStandardFunctionDeclarator {
    private IASTParameterDeclaration[] parameters;
    private int parametersPos = -1;
    private boolean varArgs;
    private IScope scope;

    public CASTFunctionDeclarator() {
    }

    public CASTFunctionDeclarator(IASTName name) {
        super(name);
    }

    @Override
    public CASTFunctionDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTFunctionDeclarator copy(IASTNode.CopyStyle style) {
        CASTFunctionDeclarator copy = new CASTFunctionDeclarator();
        copy.varArgs = this.varArgs;
        IASTParameterDeclaration[] iASTParameterDeclarationArray = this.getParameters();
        int n = iASTParameterDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTParameterDeclaration param = iASTParameterDeclarationArray[n2];
            copy.addParameterDeclaration(param == null ? null : param.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTParameterDeclaration[] getParameters() {
        if (this.parameters == null) {
            return IASTParameterDeclaration.EMPTY_PARAMETERDECLARATION_ARRAY;
        }
        this.parameters = ArrayUtil.trimAt(IASTParameterDeclaration.class, this.parameters, this.parametersPos);
        return this.parameters;
    }

    @Override
    public void addParameterDeclaration(IASTParameterDeclaration parameter) {
        this.assertNotFrozen();
        if (parameter != null) {
            parameter.setParent(this);
            parameter.setPropertyInParent(FUNCTION_PARAMETER);
            this.parameters = ArrayUtil.appendAt(IASTParameterDeclaration.class, this.parameters, ++this.parametersPos, parameter);
        }
    }

    @Override
    public boolean takesVarArgs() {
        return this.varArgs;
    }

    @Override
    public void setVarArgs(boolean value) {
        this.assertNotFrozen();
        this.varArgs = value;
    }

    @Override
    protected boolean postAccept(ASTVisitor action) {
        IASTParameterDeclaration[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            if (!params[i].accept(action)) {
                return false;
            }
            ++i;
        }
        return super.postAccept(action);
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (child == this.parameters[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.parameters[i] = (IASTParameterDeclaration)other;
                    return;
                }
                ++i;
            }
        }
        super.replace(child, other);
    }

    @Override
    public IScope getFunctionScope() {
        if (this.scope != null) {
            return this.scope;
        }
        IASTNode node = this.getParent();
        while (!(node instanceof IASTDeclaration)) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        if (node instanceof IASTParameterDeclaration) {
            return null;
        }
        if (node instanceof IASTFunctionDefinition) {
            this.scope = ((IASTFunctionDefinition)node).getScope();
        } else if (ASTQueries.findTypeRelevantDeclarator(this) == this) {
            this.scope = new CScope(this, EScopeKind.eLocal);
        }
        return this.scope;
    }
}

