/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.enablement.ibm.util.ConnectionProfileUtility;
import org.eclipse.datatools.enablement.ibm.util.DBVersion;

public class DB2Version
extends DBVersion {
    protected static DB2Version sharedDefault;
    protected static ArrayList<DB2Version> sharedInstances;

    static {
        sharedInstances = new ArrayList();
    }

    public static DB2Version getSharedInstance(String product, int version, int release, int mod) {
        DB2Version db2version;
        if (product == null) {
            product = "WORKSTATION";
        }
        if ((db2version = DB2Version.findSharedInstance(product, version, release, mod)) == null) {
            db2version = new DB2Version(product, version, release, mod);
            sharedInstances.add(db2version);
        }
        return db2version;
    }

    public static DB2Version getSharedInstance(String product, String productVersion) {
        int[] v = DB2Version.getVersionArray((String)productVersion);
        return DB2Version.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public static DB2Version getSharedInstance(IConnectionProfile profile) {
        if (profile == null) {
            return DB2Version.getDefault();
        }
        ConnectionInfo conInfo = ConnectionProfileUtility.getConnectionInfo((IConnectionProfile)profile, (boolean)false);
        if (conInfo != null) {
            return DB2Version.getSharedInstance(conInfo);
        }
        DatabaseDefinition dbDef = ConnectionProfileUtility.getDatabaseDefinition((IConnectionProfile)profile);
        return DB2Version.getSharedInstance(dbDef);
    }

    public static DB2Version getSharedInstance(ConnectionInfo myConnection) {
        boolean isOracleDatabase;
        Connection con;
        if (myConnection == null) {
            return DB2Version.getDefault();
        }
        DatabaseDefinition dbDef = myConnection.getDatabaseDefinition();
        String productVersion = myConnection.getDatabaseProductVersion();
        if (productVersion == null && (con = myConnection.getSharedConnection()) != null) {
            try {
                DatabaseMetaData dbmd = con.getMetaData();
                productVersion = dbmd.getDatabaseProductVersion();
            }
            catch (SQLException sQLException) {
                productVersion = null;
            }
        }
        if (DB2Version.isSybase((DatabaseDefinition)dbDef)) {
            productVersion = dbDef.getVersion();
        } else if (DB2Version.isIMS((DatabaseDefinition)dbDef)) {
            productVersion = dbDef.getVersion();
        }
        boolean bl = isOracleDatabase = dbDef.getProduct().equalsIgnoreCase("Oracle");
        if (productVersion == null || isOracleDatabase) {
            productVersion = dbDef.getVersion();
        }
        String product = dbDef.getProduct();
        if (productVersion != null && productVersion.length() > 0) {
            int[] v = DB2Version.getVersionArray((String)productVersion);
            if (v == null) {
                v = new int[3];
            } else if (DB2Version.isIDS((DatabaseDefinition)dbDef) && v[1] >= 10) {
                v[1] = v[1] / 10;
            }
            return DB2Version.getSharedInstance(product, v[0], v[1], v[2]);
        }
        int[] v = DB2Version.getVersionArray((String)myConnection.getDatabaseDefinition().getVersion());
        if (v == null) {
            v = new int[3];
        }
        return DB2Version.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public static DB2Version getSharedInstance(DatabaseDefinition dbDef) {
        if (dbDef == null) {
            return DB2Version.getDefault();
        }
        String version = dbDef.getVersion();
        String product = dbDef.getProduct();
        int[] v = DB2Version.getVersionArray((String)version);
        if (v == null) {
            v = new int[3];
        }
        return DB2Version.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public static DB2Version getSharedInstance(Connection connection) {
        String product;
        String versionString = null;
        try {
            product = connection.getMetaData().getDatabaseProductName();
            versionString = connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            product = "WORKSTATION";
            versionString = "8.2.0";
        }
        int[] v = DB2Version.getVersionArray((String)versionString);
        if (v == null) {
            v = new int[3];
        }
        return DB2Version.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public DB2Version(Connection connection) {
        super(connection);
    }

    public DB2Version(String product, String versionString) {
        super(product, versionString);
    }

    public DB2Version(String versionString) {
        super(versionString);
    }

    public DB2Version(int version, int release, int mod) {
        super(version, release, mod);
    }

    public DB2Version(String prod, int version, int release, int mod) {
        super(prod, version, release, mod);
    }

    public DB2Version(DB2Version copyme) {
        super((DBVersion)copyme);
    }

    public DB2Version(IConnectionProfile profile) {
        super(profile);
    }

    public DB2Version(ConnectionInfo conInfo) {
        super(conInfo);
    }

    public DB2Version(DatabaseDefinition dbDef) {
        super(dbDef);
    }

    public static DB2Version getDefault() {
        if (sharedDefault == null) {
            sharedDefault = new DB2Version("WORKSTATION", 8, 2, 0);
        }
        return sharedDefault;
    }

    protected static DB2Version findSharedInstance(String product, int version, int release, int mod) {
        for (DB2Version db2version : sharedInstances) {
            if (!product.equals(db2version.getProduct()) || version != db2version.getVersion() || release != db2version.getRelease() || mod != db2version.getMod()) continue;
            return db2version;
        }
        return null;
    }
}

