/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.internal.viewers.GenericFeatureViewerComparator;
import org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider;
import org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider;
import org.eclipse.emf.parsley.viewers.ColumnLabelProviderFactory;
import org.eclipse.emf.parsley.viewers.LayoutHelper;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableViewerColumnBuilder {
    @Inject
    @Named(value="DefaultTableColumnWeight")
    private int defaultWeight;
    @Inject
    @Named(value="TableColumnWeights")
    private List<Integer> weights;
    @Inject
    private ColumnLabelProviderFactory columnLabelProviderFactory;
    @Inject
    private FeatureCaptionProvider featureCaptionProvider;
    @Inject
    private TableFeaturesProvider featuresProvider;
    @Inject
    private LayoutHelper layoutHelper;
    @Inject
    private GenericFeatureViewerComparator viewerComparator;

    public void buildTableViewer(TableViewer tableViewer, EClass eClass) {
        Layout layout = this.layoutHelper.adjustForTableLayout(tableViewer);
        List<EStructuralFeature> typeFeatures = this.featuresProvider.getFeatures(eClass);
        int i = 0;
        int columnIndex = 0;
        tableViewer.setComparator((ViewerComparator)this.viewerComparator);
        this.viewerComparator.init(typeFeatures);
        for (EStructuralFeature eStructuralFeature : typeFeatures) {
            int weight = this.defaultWeight;
            if (this.weights.size() > i) {
                weight = this.weights.get(i++);
            }
            this.buildTableViewerColumn(tableViewer, layout, eClass, eStructuralFeature, weight, columnIndex++);
        }
    }

    protected TableViewerColumn buildTableViewerColumn(TableViewer tableViewer, Layout layout, EClass eClass, EStructuralFeature eStructuralFeature, int weight) {
        TableViewerColumn viewerColumn = this.createTableViewerColumn(tableViewer, eStructuralFeature);
        TableColumn objectColumn = viewerColumn.getColumn();
        this.layoutHelper.adjustLayoutColumnData(layout, (Widget)objectColumn, weight);
        objectColumn.setText(this.featureCaptionProvider.getText(eClass, eStructuralFeature));
        objectColumn.setResizable(true);
        return viewerColumn;
    }

    protected TableViewerColumn buildTableViewerColumn(TableViewer tableViewer, Layout layout, EClass eClass, EStructuralFeature eStructuralFeature, int weight, int colNumber) {
        TableViewerColumn viewerColumn = this.buildTableViewerColumn(tableViewer, layout, eClass, eStructuralFeature, weight);
        TableColumn objectColumn = viewerColumn.getColumn();
        objectColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(tableViewer, objectColumn, colNumber));
        return viewerColumn;
    }

    protected TableViewerColumn createTableViewerColumn(TableViewer tableViewer, EStructuralFeature eStructuralFeature) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)this.columnLabelProviderFactory.createColumnLabelProvider(eStructuralFeature));
        return tableViewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer viewer, final TableColumn column, final int index) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericFeatureViewerComparator comparator = (GenericFeatureViewerComparator)viewer.getComparator();
                comparator.setPropertyIndex(index);
                int dir = comparator.getDirection();
                viewer.getTable().setSortDirection(dir);
                viewer.getTable().setSortColumn(column);
                viewer.refresh();
            }
        };
    }
}

