/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

public class ArrayLongCompressed {
    private static final int BIT_LENGTH = 64;
    private byte[] data;
    private byte varyingBits;
    private byte trailingClearBits;

    public ArrayLongCompressed(byte[] bytes) {
        this.data = bytes;
        this.varyingBits = this.data[0];
        this.trailingClearBits = this.data[1];
    }

    public ArrayLongCompressed(int size, int leadingClearBits, int trailingClearBits) {
        this.init(size, 64 - leadingClearBits - trailingClearBits, trailingClearBits);
    }

    public ArrayLongCompressed(long[] longs) {
        this(longs, 0, longs.length);
    }

    public ArrayLongCompressed(long[] longs, int offset, int length) {
        long mask = 0L;
        int i = 0;
        while (i < length) {
            mask |= longs[offset + i];
            ++i;
        }
        int leadingClearBits = 0;
        int trailingClearBits = 0;
        while ((mask & (long)(1 << 64 - leadingClearBits - 1)) == 0L && leadingClearBits < 64) {
            ++leadingClearBits;
        }
        while ((mask & (long)(1 << trailingClearBits)) == 0L && trailingClearBits < 64 - leadingClearBits) {
            ++trailingClearBits;
        }
        this.init(length, 64 - leadingClearBits - trailingClearBits, trailingClearBits);
        int i2 = 0;
        while (i2 < length) {
            this.set(i2, longs[offset + i2]);
            ++i2;
        }
    }

    private void init(int size, int varyingBits, int trailingClearBits) {
        this.data = new byte[2 + (int)(((long)size * (long)varyingBits - 1L) / 8L) + 1];
        this.varyingBits = this.data[0] = (byte)varyingBits;
        this.trailingClearBits = this.data[1] = (byte)trailingClearBits;
    }

    public void set(int index, long value) {
        value >>>= this.trailingClearBits;
        long pos = (long)index * (long)this.varyingBits;
        int idx = 2 + (int)(pos >>> 3);
        int off = (int)pos & 7;
        if ((off += this.varyingBits) > 8) {
            int n = idx;
            this.data[n] = (byte)((long)this.data[n] & ((1L << this.varyingBits - (off -= 8)) - 1L ^ 0xFFFFFFFFFFFFFFFFL));
            int n2 = idx++;
            this.data[n2] = (byte)(this.data[n2] | (byte)(value >>> off));
            while (off > 8) {
                this.data[idx++] = (byte)(value >>> (off -= 8));
            }
        }
        int n = idx;
        this.data[n] = (byte)((long)this.data[n] & ((2L << this.varyingBits - 1) - 1L << 8 - off ^ 0xFFFFFFFFFFFFFFFFL));
        int n3 = idx;
        this.data[n3] = (byte)(this.data[n3] | (byte)(value << 8 - off));
    }

    public long get(int index) {
        long value = 0L;
        long pos = (long)index * (long)this.varyingBits;
        int idx = 2 + (int)(pos >>> 3);
        int off = (int)pos & 7;
        if (off + this.varyingBits > 8) {
            value = (this.data[idx++] << off & 0xFF) >>> off;
            off += this.varyingBits - 8;
            while (off > 8) {
                value <<= 8;
                value |= (long)(this.data[idx++] & 0xFF);
                off -= 8;
            }
            value <<= off;
            value |= (long)((this.data[idx] & 0xFF) >>> 8 - off);
        } else {
            value = (this.data[idx] << off & 0xFF) >>> 8 - this.varyingBits;
        }
        return value << this.trailingClearBits;
    }

    public byte[] toByteArray() {
        return this.data;
    }
}

