/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.common.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.modisco.common.core.internal.CommonCorePlugin;

public final class Logger {
    private static Stack<Set<IStatus>> expectedStatusesStack = null;

    private Logger() {
    }

    public static void logError(Throwable e, Plugin plugin) {
        Logger.log(e, 4, e.getMessage(), plugin);
    }

    public static void logError(String message, Plugin plugin) {
        Logger.log(null, 4, message, plugin);
    }

    public static void logError(Throwable e, String message, Plugin plugin) {
        Logger.log(e, 4, message, plugin);
    }

    public static void logWarning(Throwable e, Plugin plugin) {
        Logger.log(e, 2, e.getMessage(), plugin);
    }

    public static void logWarning(String message, Plugin plugin) {
        Logger.log(null, 2, message, plugin);
    }

    public static void logWarning(Throwable e, String message, Plugin plugin) {
        Logger.log(e, 2, message, plugin);
    }

    public static void logInfo(Throwable e, Plugin plugin) {
        Logger.log(e, 1, e.getMessage(), plugin);
    }

    public static void logInfo(String message, Plugin plugin) {
        Logger.log(null, 1, message, plugin);
    }

    public static void logError(Plugin plugin, String messageTemplate, Object ... args) {
        Logger.log(null, 4, plugin, messageTemplate, args);
    }

    public static void logError(Throwable e, Plugin plugin, String messageTemplate, Object ... args) {
        Logger.log(e, 4, plugin, messageTemplate, args);
    }

    public static void logWarning(Plugin plugin, String messageTemplace, Object ... args) {
        Logger.log(null, 2, plugin, messageTemplace, args);
    }

    public static void logWarning(Throwable e, Plugin plugin, String messageTemplace, Object ... args) {
        Logger.log(e, 2, plugin, messageTemplace, args);
    }

    public static void logInfo(Plugin plugin, String messageTemplace, Object ... args) {
        Logger.log(null, 1, plugin, messageTemplace, args);
    }

    public static void log(Throwable e, int level, Plugin plugin, String messageTemplate, Object ... args) {
        String message = String.format(messageTemplate, args);
        Logger.log(e, level, message, plugin);
    }

    public static void log(Throwable e, int level, String message, Plugin plugin) {
        Throwable effectiveE = e;
        Plugin effectivePlugin = plugin;
        String effectiveMessage = message;
        MultiStatus status = null;
        if (effectiveE instanceof InvocationTargetException) {
            effectiveE = ((InvocationTargetException)effectiveE).getTargetException();
        }
        if (effectivePlugin == null) {
            effectivePlugin = CommonCorePlugin.getDefault();
        }
        if (effectiveE instanceof CoreException) {
            MultiStatus mstatus;
            status = mstatus = new MultiStatus(plugin.getBundle().getSymbolicName(), level, new IStatus[]{((CoreException)effectiveE).getStatus()}, message, effectiveE);
        } else {
            if (effectiveMessage == null && effectiveE != null) {
                effectiveMessage = effectiveE.getMessage();
            }
            if (effectiveMessage == null && effectiveE != null) {
                effectiveMessage = effectiveE.toString();
            }
            if (effectiveMessage == null) {
                effectiveMessage = "";
            }
            try {
                effectiveMessage = String.valueOf(effectiveMessage) + " (" + effectivePlugin.getBundle().getSymbolicName() + "_" + effectivePlugin.getBundle().getVersion() + ")";
            }
            catch (NullPointerException e2) {
                effectiveMessage = String.valueOf(effectiveMessage) + " (activator class = " + effectivePlugin.getClass().getName() + ")";
            }
            if (effectiveE == null && level > 1) {
                effectiveE = new LogStackTrace();
            }
            status = new Status(level, effectivePlugin.getBundle().getSymbolicName(), effectiveMessage, effectiveE);
        }
        if (expectedStatusesStack != null) {
            Set<IStatus> expectedStatuses = expectedStatusesStack.peek();
            for (IStatus expectedStatus : expectedStatuses) {
                if (!Logger.isEqual((IStatus)status, expectedStatus)) continue;
                expectedStatuses.remove(expectedStatus);
                if (expectedStatuses.isEmpty()) {
                    expectedStatusesStack.pop();
                    if (expectedStatusesStack.isEmpty()) {
                        expectedStatusesStack = null;
                    }
                }
                return;
            }
            Status extraStatus = new Status(4, effectivePlugin.getBundle().getSymbolicName(), "Expected messages were not logged", null);
            effectivePlugin.getLog().log((IStatus)extraStatus);
        }
        effectivePlugin.getLog().log((IStatus)status);
    }

    private static boolean isEqual(IStatus status, IStatus expectedStatus) {
        if (status.getSeverity() != expectedStatus.getSeverity()) {
            return false;
        }
        if (expectedStatus.getException() == null ? !(status.getException() instanceof LogStackTrace) : !Objects.equals(status.getException(), expectedStatus.getException())) {
            return false;
        }
        return status.getMessage().startsWith(expectedStatus.getMessage());
    }

    public static void addExpectedStatuses(Set<IStatus> expectedStatuses) {
        if (expectedStatusesStack == null) {
            expectedStatusesStack = new Stack();
        }
        expectedStatusesStack.push(expectedStatuses);
    }

    public static Stack<Set<IStatus>> resetExpectedStatuses() {
        try {
            Stack<Set<IStatus>> stack = expectedStatusesStack;
            return stack;
        }
        finally {
            expectedStatusesStack = null;
        }
    }

    protected static class LogStackTrace
    extends Exception {
        private static final long serialVersionUID = 309882934616507415L;

        protected LogStackTrace() {
        }
    }
}

